/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm.cache;

import java.io.Serializable;
import java.util.Collection;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.cache.MembershipCacheKey;
import org.exoplatform.services.organization.cache.OrganizationCacheHandler;
import org.exoplatform.services.organization.idm.MembershipTypeDAOImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.impl.MembershipTypeImpl;

public class CacheableMembershipTypeHandlerImpl
extends MembershipTypeDAOImpl {
    private final ExoCache<String, MembershipType> membershipTypeCache;
    private final ExoCache<MembershipCacheKey, Object> membershipCache;
    private final FutureExoCache<String, MembershipType, Object> futureMembershipTypeCache;
    private final ThreadLocal<Boolean> disableCacheInThread = new ThreadLocal();

    public CacheableMembershipTypeHandlerImpl(OrganizationCacheHandler organizationCacheHandler, PicketLinkIDMOrganizationServiceImpl orgService, PicketLinkIDMService service) {
        super(orgService, service);
        this.membershipTypeCache = organizationCacheHandler.getMembershipTypeCache();
        this.futureMembershipTypeCache = new FutureExoCache((Loader)new Loader<String, MembershipType, Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public MembershipType retrieve(Object context, String key) throws Exception {
                CacheableMembershipTypeHandlerImpl.this.disableCacheInThread.set(true);
                try {
                    MembershipType membershipType = CacheableMembershipTypeHandlerImpl.this.findMembershipType(key);
                    return membershipType;
                }
                finally {
                    CacheableMembershipTypeHandlerImpl.this.disableCacheInThread.set(false);
                }
            }
        }, this.membershipTypeCache);
        this.membershipCache = organizationCacheHandler.getMembershipCache();
    }

    @Override
    public MembershipType findMembershipType(String name) throws Exception {
        if (this.disableCacheInThread.get() == null || !this.disableCacheInThread.get().booleanValue()) {
            MembershipType membershipType = (MembershipType)this.futureMembershipTypeCache.get(null, (Object)name);
            return membershipType == null ? membershipType : ((MembershipTypeImpl)membershipType).clone();
        }
        return super.findMembershipType(name);
    }

    @Override
    public Collection<MembershipType> findMembershipTypes() throws Exception {
        return super.findMembershipTypes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        MembershipType membershipType = null;
        this.disableCacheInThread.set(true);
        try {
            membershipType = super.removeMembershipType(name, broadcast);
            this.membershipTypeCache.remove((Serializable)((Object)name));
            if (membershipType != null) {
                this.membershipCache.select((CachedObjectSelector)new ClearMembershipCacheByMembershipTypeSelector(name));
            }
        }
        finally {
            this.disableCacheInThread.set(false);
        }
        return membershipType;
    }

    @Override
    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        mt = super.createMembershipType(mt, broadcast);
        this.membershipTypeCache.remove((Serializable)((Object)mt.getName()));
        return mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        this.disableCacheInThread.set(true);
        try {
            mt = super.saveMembershipType(mt, broadcast);
            this.membershipTypeCache.remove((Serializable)((Object)mt.getName()));
            MembershipType membershipType = mt;
            return membershipType;
        }
        finally {
            this.disableCacheInThread.set(false);
        }
    }

    public void clearCache() {
        this.membershipTypeCache.clearCache();
    }

    public void disableCache() {
        this.disableCacheInThread.set(true);
    }

    public void enableCache() {
        this.disableCacheInThread.set(null);
    }

    public static final class ClearMembershipCacheByMembershipTypeSelector
    implements CachedObjectSelector<MembershipCacheKey, Object> {
        private String membershipType;

        public ClearMembershipCacheByMembershipTypeSelector(String membershipType) {
            this.membershipType = membershipType;
        }

        public void onSelect(ExoCache<? extends MembershipCacheKey, ? extends Object> cache, MembershipCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) throws Exception {
            cache.remove((Serializable)key);
        }

        public boolean select(MembershipCacheKey key, ObjectCacheInfo<? extends Object> ocinfo) {
            Membership cachedMembership;
            Object obj = ocinfo.get();
            return obj instanceof Membership ? (cachedMembership = (Membership)ocinfo.get()).getMembershipType().equals(this.membershipType) : obj instanceof Collection;
        }
    }
}

