/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addons.gamification.service.mapper;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.exoplatform.addons.gamification.entities.domain.configuration.BadgeEntity;
import org.exoplatform.addons.gamification.service.dto.configuration.BadgeDTO;
import org.exoplatform.addons.gamification.service.mapper.DomainMapper;

public class BadgeMapper {
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private BadgeMapper() {
    }

    public static BadgeDTO badgeToBadgeDTO(BadgeEntity badgeEntity) {
        BadgeDTO badgeDTO = new BadgeDTO();
        badgeDTO.setId(badgeEntity.getId());
        badgeDTO.setTitle(badgeEntity.getTitle());
        badgeDTO.setDescription(badgeEntity.getDescription());
        badgeDTO.setNeededScore(badgeEntity.getNeededScore());
        badgeDTO.setStartValidityDate(BadgeMapper.formatDate(badgeEntity.getStartValidityDate()));
        badgeDTO.setEndValidityDate(BadgeMapper.formatDate(badgeEntity.getEndValidityDate()));
        badgeDTO.setEnabled(badgeEntity.isEnabled());
        badgeDTO.setDeleted(badgeEntity.isDeleted());
        badgeDTO.setCreatedBy(badgeEntity.getCreatedBy());
        badgeDTO.setCreatedDate(BadgeMapper.formatDate(badgeEntity.getCreatedDate()));
        badgeDTO.setLastModifiedBy(badgeEntity.getLastModifiedBy());
        badgeDTO.setLastModifiedDate(BadgeMapper.formatDate(badgeEntity.getLastModifiedDate()));
        badgeDTO.setDomainDTO(badgeEntity.getDomainEntity() == null ? null : DomainMapper.domainEntityToDomainDTO(badgeEntity.getDomainEntity()));
        badgeDTO.setIconFileId(badgeEntity.getIconFileId());
        return badgeDTO;
    }

    public static List<BadgeDTO> badgesToBadgeDTOs(List<BadgeEntity> badges) {
        return badges.stream().filter(Objects::nonNull).map(BadgeMapper::badgeToBadgeDTO).collect(Collectors.toList());
    }

    public static BadgeEntity badgeDTOToBadge(BadgeDTO badgeDTO) {
        if (badgeDTO == null) {
            return null;
        }
        BadgeEntity badge = new BadgeEntity();
        badge.setId(badgeDTO.getId());
        badge.setTitle(badgeDTO.getTitle());
        badge.setDescription(badgeDTO.getDescription());
        badge.setNeededScore(badgeDTO.getNeededScore());
        badge.setIconFileId(badgeDTO.getIconFileId());
        if (badgeDTO.getStartValidityDate() != null) {
            badge.setStartValidityDate(BadgeMapper.parseDate(badgeDTO.getStartValidityDate()));
        }
        if (badgeDTO.getEndValidityDate() != null) {
            badge.setEndValidityDate(BadgeMapper.parseDate(badgeDTO.getEndValidityDate()));
        }
        badge.setEnabled(badgeDTO.isEnabled());
        badge.setDeleted(badgeDTO.isDeleted());
        badge.setCreatedBy(badgeDTO.getCreatedBy());
        if (badgeDTO.getCreatedDate() != null) {
            badge.setCreatedDate(BadgeMapper.parseDate(badgeDTO.getCreatedDate()));
        }
        badge.setLastModifiedBy(badgeDTO.getLastModifiedBy());
        if (badgeDTO.getLastModifiedDate() != null) {
            badge.setLastModifiedDate(BadgeMapper.parseDate(badgeDTO.getLastModifiedDate()));
        }
        badge.setDomainEntity(DomainMapper.domainDTOToDomainEntity(badgeDTO.getDomainDTO()));
        return badge;
    }

    private static Date parseDate(String dateString) {
        return dateString == null ? null : Date.from(LocalDate.parse(dateString, DATE_FORMATTER).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private static String formatDate(Date date) {
        return date == null ? null : LocalDate.ofInstant(date.toInstant(), ZoneId.systemDefault()).format(DATE_FORMATTER);
    }
}

