/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.resource;

import java.io.Reader;

public abstract class Resource {
    private final String contextPath;
    private final String parentPath;
    private final String fileName;

    public Resource(String path) {
        int index = path.indexOf("/", 2);
        String relativeCSSPath = path.substring(index);
        int index2 = relativeCSSPath.lastIndexOf("/") + 1;
        this.contextPath = path.substring(0, index);
        this.parentPath = relativeCSSPath.substring(0, index2);
        this.fileName = relativeCSSPath.substring(index2);
    }

    public Resource(String contextPath, String parentPath, String fileName) {
        this.contextPath = contextPath;
        this.parentPath = parentPath;
        this.fileName = fileName;
    }

    public final String getPath() {
        return this.getContextPath() + this.getParentPath() + this.getFileName();
    }

    public final String getContextPath() {
        return this.contextPath;
    }

    public final String getParentPath() {
        return this.parentPath;
    }

    public final String getFileName() {
        return this.fileName;
    }

    public final String getResourcePath() {
        return this.getParentPath() + this.getFileName();
    }

    public abstract Reader read();
}

