/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.activity.filter;

import org.apache.commons.lang.ArrayUtils;

public class ActivityUpdateFilter {
    private String[] excludedActivities = new String[0];
    private boolean refreshTab = false;

    public ActivityUpdateFilter() {
        this.refreshTab = false;
    }

    public ActivityUpdateFilter(boolean refreshTab) {
        this.refreshTab = refreshTab;
    }

    public ActivityFilterType connectionType() {
        return ActivityFilterType.CONNECTIONS_ACTIVITIES;
    }

    public ActivityFilterType userActivitiesType() {
        return ActivityFilterType.USER_ACTIVITIES;
    }

    public ActivityFilterType userSpaceActivitiesType() {
        return ActivityFilterType.USER_SPACE_ACTIVITIES;
    }

    public ActivityFilterType spaceActivitiesType() {
        return ActivityFilterType.SPACE_ACTIVITIES;
    }

    public ActivityFilterType activityFeedType() {
        return ActivityFilterType.ACTIVITY_FEED;
    }

    public String[] excludedActivities() {
        return this.excludedActivities;
    }

    public void addExcludedActivities(String ... activityIds) {
        if (activityIds == null) {
            return;
        }
        for (String id : activityIds) {
            if (ArrayUtils.contains((Object[])this.excludedActivities, (Object)id)) continue;
            this.excludedActivities = (String[])ArrayUtils.add((Object[])this.excludedActivities, (Object)id);
        }
    }

    public boolean isRefreshTab() {
        return this.refreshTab;
    }

    public static enum ActivityFilterType {
        ACTIVITY_FEED,
        CONNECTIONS_ACTIVITIES,
        USER_ACTIVITIES,
        USER_SPACE_ACTIVITIES,
        SPACE_ACTIVITIES;

        private Long oldFromSinceTime;
        private Long fromSinceTime;
        private Long toSinceTime;
        private long lastNumberOfUpdated;

        public ActivityFilterType fromSinceTime(Long fromSinceTime) {
            this.fromSinceTime = fromSinceTime;
            return this;
        }

        public ActivityFilterType oldFromSinceTime(Long oldFromSinceTime) {
            this.oldFromSinceTime = oldFromSinceTime;
            return this;
        }

        public ActivityFilterType toSinceTime(Long toSinceTime) {
            this.toSinceTime = toSinceTime;
            return this;
        }

        public ActivityFilterType lastNumberOfUpdated(Long lastNumberOfUpdated) {
            this.lastNumberOfUpdated = lastNumberOfUpdated;
            return this;
        }

        public Long lastNumberOfUpdated() {
            return this.lastNumberOfUpdated;
        }

        public Long toSinceTime() {
            return this.toSinceTime;
        }

        public Long fromSinceTime() {
            return this.fromSinceTime;
        }

        public Long oldFromSinceTime() {
            return this.oldFromSinceTime;
        }
    }
}

