/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.jpa.search;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.search.domain.Document;
import org.exoplatform.commons.search.index.impl.ElasticIndexingServiceConnector;
import org.exoplatform.commons.utils.HTMLSanitizer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ActivityStream;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ActivitySearchProcessor;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.processor.I18NActivityProcessor;
import org.exoplatform.social.core.search.DocumentWithMetadata;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;

public class ActivityIndexingServiceConnector
extends ElasticIndexingServiceConnector {
    public static final String TYPE = "activity";
    private static final Log LOG = ExoLogger.getLogger(ActivityIndexingServiceConnector.class);
    private final ActivitySearchProcessor activitySearchProcessor;
    private final I18NActivityProcessor i18nActivityProcessor;
    private final ActivityManager activityManager;
    private final IdentityManager identityManager;
    private final MetadataService metadataService;

    public ActivityIndexingServiceConnector(ActivitySearchProcessor activitySearchProcessor, I18NActivityProcessor i18nActivityProcessor, IdentityManager identityManager, ActivityManager activityManager, MetadataService metadataService, InitParams initParams) {
        super(initParams);
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.metadataService = metadataService;
        this.activitySearchProcessor = activitySearchProcessor;
        this.i18nActivityProcessor = i18nActivityProcessor;
    }

    public Document create(String id) {
        return this.getDocument(id);
    }

    public Document update(String id) {
        return this.getDocument(id);
    }

    public List<String> getAllIds(int offset, int limit) {
        throw new UnsupportedOperationException();
    }

    public String getConnectorName() {
        return TYPE;
    }

    private Document getDocument(String id) {
        Object body;
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("id is mandatory");
        }
        LOG.debug("Index document for activity id={}", new Object[]{id});
        ExoSocialActivity activity = this.activityManager.getActivity(id);
        if (activity == null) {
            throw new IllegalStateException("activity with id '" + id + "' is mandatory");
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        String activityId = activity.getId();
        String documentId = activityId.replace("comment", "");
        fields.put("id", documentId);
        if (activity.getTitleId() != null) {
            try {
                activity = this.i18nActivityProcessor.process(activity, Locale.ENGLISH);
            }
            catch (Exception e) {
                LOG.warn("Error while indexing I18N activity '{}' with type '{}'", new Object[]{activity.getId(), activity.getType(), e});
            }
        }
        if (StringUtils.isBlank((String)(body = activity.getBody()))) {
            body = activity.getTitle();
        }
        fields.put("body", (String)body);
        if (StringUtils.isNotBlank((String)activity.getParentId())) {
            fields.put("parentId", activity.getParentId());
        }
        if (StringUtils.isNotBlank((String)activity.getParentCommentId())) {
            fields.put("parentCommentId", activity.getParentCommentId().replace("comment", ""));
        }
        if (StringUtils.isNotBlank((String)activity.getType())) {
            fields.put("type", activity.getType());
        }
        if (StringUtils.isNotBlank((String)activity.getPosterId())) {
            fields.put("posterId", activity.getPosterId());
            Identity posterIdentity = this.identityManager.getIdentity(activity.getPosterId());
            if (posterIdentity != null && posterIdentity.getProfile() != null && StringUtils.isNotBlank((String)posterIdentity.getProfile().getFullName())) {
                fields.put("posterName", posterIdentity.getProfile().getFullName());
            }
        }
        ActivityStream activityStream = activity.getActivityStream();
        String ownerIdentityId = null;
        if (activity.getParentId() != null && (activityStream == null || activityStream.getType() == null || StringUtils.isBlank((String)activityStream.getPrettyId()))) {
            ExoSocialActivity parentActivity = this.activityManager.getActivity(activity.getParentId());
            activityStream = parentActivity.getActivityStream();
        }
        if (activityStream != null && activityStream.getType() != null && StringUtils.isNotBlank((String)activityStream.getPrettyId())) {
            String prettyId = activityStream.getPrettyId();
            String providerId = activityStream.getType().getProviderId();
            Identity streamOwner = this.identityManager.getOrCreateIdentity(providerId, prettyId);
            ownerIdentityId = streamOwner.getId();
            fields.put("streamType", String.valueOf(activityStream.getType().ordinal()));
            fields.put("streamOwner", String.valueOf(ownerIdentityId));
        }
        if (activity.getPostedTime() != null) {
            fields.put("postedTime", activity.getPostedTime().toString());
        }
        DocumentWithMetadata document = new DocumentWithMetadata();
        document.setId(id);
        document.setLastUpdatedDate(activity.getUpdated());
        HashSet<String> permissions = new HashSet<String>();
        permissions.add(ownerIdentityId);
        if (ActivityStream.Type.USER.equals((Object)activity.getActivityStream().getType()) && !StringUtils.equals((String)ownerIdentityId, (String)activity.getPosterId())) {
            permissions.add(activity.getPosterId());
        }
        document.setPermissions(permissions);
        document.setFields(fields);
        this.activitySearchProcessor.index(activity, (Document)document);
        body = (String)document.getFields().get("body");
        if (activity.getTemplateParams() != null && activity.getTemplateParams().containsKey("description")) {
            body = (String)body + "\n";
            body = (String)body + (String)activity.getTemplateParams().get("description");
        }
        if (StringUtils.isNotBlank((String)body)) {
            body = StringEscapeUtils.unescapeHtml((String)body);
            try {
                body = HTMLSanitizer.sanitize((String)body);
            }
            catch (Exception e) {
                LOG.warn("Error sanitizing activity '{}' body", new Object[]{activity.getId()});
            }
            body = this.htmlToText((String)body);
            document.addField("body", (String)body);
        }
        if (!activity.hasSpecificMetadataObject()) {
            this.addDocumentMetadata(document, activity.getMetadataObject());
        }
        return document;
    }

    private void addDocumentMetadata(DocumentWithMetadata document, MetadataObject metadataObject) {
        List metadataItems = this.metadataService.getMetadataItemsByObject(metadataObject);
        document.setMetadataItems(metadataItems);
    }

    private String htmlToText(String source) {
        source = source.replaceAll("<( )*head([^>])*>", "<head>");
        source = source.replaceAll("(<( )*(/)( )*head( )*>)", "</head>");
        source = source.replaceAll("(<head>).*(</head>)", "");
        source = source.replaceAll("<( )*script([^>])*>", "<script>");
        source = source.replaceAll("(<( )*(/)( )*script( )*>)", "</script>");
        source = source.replaceAll("(<script>).*(</script>)", "");
        source = source.replace("javascript:", "");
        source = source.replaceAll("<( )*style([^>])*>", "<style>");
        source = source.replaceAll("(<( )*(/)( )*style( )*>)", "</style>");
        source = source.replaceAll("(<style>).*(</style>)", "");
        source = source.replaceAll("<( )*td([^>])*>", "\t");
        source = source.replaceAll("<( )*br( )*(/)*>", "\n");
        source = source.replaceAll("<( )*li( )*>", "\n");
        source = source.replaceAll("<( )*div([^>])*>", "\n");
        source = source.replaceAll("<( )*tr([^>])*>", "\n");
        source = source.replaceAll("<( )*p([^>])*>", "\n");
        source = source.replaceAll("<[^>]*>", "");
        return source;
    }
}

