/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.login;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class LoginUtils {
    public static final String COOKIE_NAME = "rememberme";
    public static final String OAUTH_COOKIE_NAME = "oauth_rememberme";
    public static final String SESSION_ATTRIBUTE_REMEMBER_ME = "_rememberme";

    private LoginUtils() {
    }

    public static String getRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String getOauthRememberMeTokenCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!OAUTH_COOKIE_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }
}

