/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetNode;
import juzu.impl.common.Tools;

public class AssetDeployment {
    final ArrayList<AssetNode> assets = new ArrayList();
    private final AssetManager manager;
    private boolean deployed;

    AssetDeployment(AssetManager manager) {
        this.manager = manager;
    }

    public AssetDeployment addAsset(String id, String type, AssetLocation location, String value, Boolean header, String minifiedValue, Integer maxAge, URL url, String ... dependencies) throws NullPointerException, IllegalArgumentException {
        return this.addAsset(id, type, location, value, header, minifiedValue, maxAge, url, Tools.set(dependencies));
    }

    public AssetDeployment addAsset(String id, String type, AssetLocation location, String value, Boolean header, String minifiedValue, Integer maxAge, URL resource, Set<String> dependencies) throws NullPointerException, IllegalArgumentException {
        this.assets.add(new AssetNode(id, type, location, value, header, minifiedValue, maxAge, resource, dependencies));
        return this;
    }

    public boolean deploy() {
        this.deployed = this.manager.deploy(this);
        return this.deployed;
    }

    public void undeploy() {
        if (this.deployed) {
            this.deployed = false;
            this.manager.undeploy(this);
        }
    }
}

