/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.branding;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.commons.file.services.FileStorageException;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.branding.model.Background;
import org.exoplatform.portal.branding.model.Branding;
import org.exoplatform.portal.branding.model.BrandingFile;
import org.exoplatform.portal.branding.model.Favicon;
import org.exoplatform.portal.branding.model.Logo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.picocontainer.Startable;

public class BrandingServiceImpl
implements BrandingService,
Startable {
    private static final Log LOG = ExoLogger.getExoLogger(BrandingServiceImpl.class);
    public static final String BRANDING_RESET_ATTACHMENT_ID = "0";
    public static final String BRANDING_LOGO_BASE_PATH = "/portal/rest/v1/platform/branding/logo?v=";
    public static final String BRANDING_FAVICON_BASE_PATH = "/portal/rest/v1/platform/branding/favicon?v=";
    public static final String BRANDING_LOGIN_BG_BASE_PATH = "/portal/rest/v1/platform/branding/loginBackground?v=";
    public static final String BRANDING_COMPANY_NAME_INIT_PARAM = "exo.branding.company.name";
    public static final String BRANDING_SITE_NAME_INIT_PARAM = "exo.branding.company.siteName";
    public static final String BRANDING_COMPANY_LINK_INIT_PARAM = "exo.branding.company.link";
    public static final String BRANDING_LOGIN_TITLE_PARAM = "authentication.title";
    public static final String BRANDING_LOGIN_SUBTITLE_PARAM = "authentication.subtitle";
    public static final String BRANDING_LOGIN_BG_INIT_PARAM = "authentication.background";
    public static final String BRANDING_LOGO_INIT_PARAM = "exo.branding.company.logo";
    public static final String BRANDING_FAVICON_INIT_PARAM = "exo.branding.company.favicon";
    public static final String BRANDING_COMPANY_NAME_SETTING_KEY = "exo.branding.company.name";
    public static final String BRANDING_SITE_NAME_SETTING_KEY = "exo.branding.company.siteName";
    public static final String BRANDING_LOGIN_TEXT_COLOR_KEY = "authentication.loginBackgroundTextColor";
    public static final String BRANDING_TITLE_SETTING_KEY = "authentication.title.";
    public static final String BRANDING_SUBTITLE_SETTING_KEY = "authentication.subtitle.";
    public static final String BRANDING_COMPANY_LINK_SETTING_KEY = "exo.branding.company.link";
    public static final String BRANDING_THEME_LESS_PATH = "exo.branding.theme.path";
    public static final String BRANDING_THEME_VARIABLES = "exo.branding.theme.variables";
    public static final String BRANDING_TOPBAR_THEME_SETTING_KEY = "bar_navigation_style";
    public static final String BRANDING_LOGO_ID_SETTING_KEY = "exo.branding.company.id";
    public static final String BRANDING_FAVICON_ID_SETTING_KEY = "exo.branding.company.favicon.id";
    public static final String BRANDING_LOGIN_BG_ID_SETTING_KEY = "authentication.background";
    public static final String BRANDING_LAST_UPDATED_TIME_KEY = "branding.lastUpdatedTime";
    public static final String FILE_API_NAME_SPACE = "CompanyBranding";
    public static final String LOGO_NAME = "logo.png";
    public static final String FAVICON_NAME = "favicon.ico";
    public static final String LOGIN_BACKGROUND_NAME = "loginBackground.png";
    public static final String BRANDING_DEFAULT_LOGO_PATH = "/skin/images/logo/DefaultLogo.png";
    public static final String BRANDING_DEFAULT_FAVICON_PATH = "/skin/images/favicon.ico";
    public static final Context BRANDING_CONTEXT = Context.GLOBAL.id("BRANDING");
    public static final Scope BRANDING_SCOPE = Scope.APPLICATION.id("BRANDING");
    public static final long DEFAULT_LAST_MODIFED = System.currentTimeMillis();
    private PortalContainer container;
    private LocaleConfigService localeConfigService;
    private SettingService settingService;
    private FileService fileService;
    private UploadService uploadService;
    private ConfigurationManager configurationManager;
    private String defaultCompanyName = "";
    private String defaultSiteName = "";
    private String defaultCompanyLink = "";
    private String defaultTopbarTheme = "Dark";
    private String defaultConfiguredLogoPath = null;
    private String defaultConfiguredFaviconPath = null;
    private String defaultConfiguredLoginBgPath = null;
    private String lessFilePath = null;
    private Map<String, String> themeVariables = null;
    private String defaultLoginTitle = null;
    private String defaultLoginSubtitle = null;
    private Map<String, String> loginTitle = null;
    private Map<String, String> loginSubtitle = null;
    private Map<String, String> supportedLanguages = null;
    private String lessThemeContent = null;
    private String themeCSSContent = null;
    private Logo logo = null;
    private Favicon favicon = null;
    private Background loginBackground = null;

    public BrandingServiceImpl(PortalContainer container, ConfigurationManager configurationManager, SettingService settingService, FileService fileService, UploadService uploadService, LocaleConfigService localeConfigService, InitParams initParams) {
        this.container = container;
        this.configurationManager = configurationManager;
        this.settingService = settingService;
        this.fileService = fileService;
        this.uploadService = uploadService;
        this.localeConfigService = localeConfigService;
        this.loadLanguages();
        this.loadInitParams(initParams);
    }

    public void start() {
        this.computeThemeCSS();
    }

    public void stop() {
    }

    public String getThemeCSSContent() {
        if (this.themeCSSContent == null) {
            this.computeThemeCSS();
        }
        return this.themeCSSContent;
    }

    public Branding getBrandingInformation() {
        return this.getBrandingInformation(true);
    }

    public Branding getBrandingInformation(boolean retrieveBinaries) {
        Branding branding = new Branding();
        branding.setDefaultLanguage(this.getDefaultLanguage());
        branding.setSupportedLanguages(Collections.unmodifiableMap(this.supportedLanguages));
        branding.setCompanyName(this.getCompanyName());
        branding.setCompanyLink(this.getCompanyLink());
        branding.setSiteName(this.getSiteName());
        branding.setTopBarTheme(this.getTopBarTheme());
        branding.setLogo(this.getLogo());
        branding.setFavicon(this.getFavicon());
        branding.setLoginBackground(this.getLoginBackground());
        branding.setLoginBackgroundTextColor(this.getLoginBackgroundTextColor());
        branding.setThemeColors(this.getThemeColors());
        branding.setLoginTitle(this.getLoginTitle());
        branding.setLoginSubtitle(this.getLoginSubtitle());
        branding.setLastUpdatedTime(this.getLastUpdatedTime());
        if (!retrieveBinaries) {
            Favicon brandingFile;
            if (branding.getFavicon() != null && branding.getFavicon().getData() != null) {
                brandingFile = branding.getFavicon().clone();
                brandingFile.setData(null);
                branding.setFavicon(brandingFile);
            }
            if (branding.getLogo() != null && branding.getLogo().getData() != null) {
                brandingFile = branding.getLogo().clone();
                brandingFile.setData(null);
                branding.setLogo((Logo)brandingFile);
            }
            if (branding.getLoginBackground() != null && branding.getLoginBackground().getData() != null) {
                brandingFile = branding.getLoginBackground().clone();
                brandingFile.setData(null);
                branding.setLoginBackground((Background)brandingFile);
            }
        }
        return branding;
    }

    public long getLastUpdatedTime() {
        SettingValue lastUpdatedTime = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY);
        if (lastUpdatedTime == null || lastUpdatedTime.getValue() == null) {
            return DEFAULT_LAST_MODIFED;
        }
        return Long.parseLong(lastUpdatedTime.getValue().toString());
    }

    public void updateBrandingInformation(Branding branding) {
        try {
            this.updateCompanyName(branding.getCompanyName(), false);
            this.updateSiteName(branding.getSiteName(), false);
            this.updateCompanyLink(branding.getCompanyLink(), false);
            this.updateTopBarTheme(branding.getTopBarTheme(), false);
            this.updateLogo(branding.getLogo(), false);
            this.updateFavicon(branding.getFavicon(), false);
            this.updateLoginBackground(branding.getLoginBackground(), false);
            this.updateLoginBackgroundTextColor(branding.getLoginBackgroundTextColor(), false);
            this.updateThemeColors(branding.getThemeColors(), false);
            this.updateLoginTitle(branding.getLoginTitle());
            this.updateLoginSubtitle(branding.getLoginSubtitle());
        }
        finally {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    public String getCompanyName() {
        SettingValue brandingCompanyName = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        if (brandingCompanyName != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingCompanyName.getValue()))) {
            return (String)brandingCompanyName.getValue();
        }
        return this.defaultCompanyName;
    }

    public String getCompanyLink() {
        SettingValue brandingCompanyLink = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link");
        if (brandingCompanyLink != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingCompanyLink.getValue()))) {
            return (String)brandingCompanyLink.getValue();
        }
        return this.defaultCompanyLink;
    }

    public String getSiteName() {
        SettingValue brandingSiteName = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName");
        if (brandingSiteName != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingSiteName.getValue()))) {
            return (String)brandingSiteName.getValue();
        }
        return this.defaultSiteName;
    }

    public String getLoginBackgroundTextColor() {
        SettingValue brandingLoginTextColor = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGIN_TEXT_COLOR_KEY);
        if (brandingLoginTextColor != null && StringUtils.isNotBlank((CharSequence)((CharSequence)brandingLoginTextColor.getValue()))) {
            return (String)brandingLoginTextColor.getValue();
        }
        return null;
    }

    public void updateCompanyName(String companyName) {
        this.updateCompanyName(companyName, true);
    }

    public void updateCompanyLink(String companyLink) {
        this.updateCompanyLink(companyLink, true);
    }

    public void updateSiteName(String siteName) {
        this.updateSiteName(siteName, true);
    }

    public void updateLoginBackgroundTextColor(String textColor) {
        this.updateLoginBackgroundTextColor(textColor, true);
    }

    public String getTopBarTheme() {
        SettingValue topBarTheme = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        if (topBarTheme != null && StringUtils.isNotBlank((CharSequence)((CharSequence)topBarTheme.getValue()))) {
            return (String)topBarTheme.getValue();
        }
        return this.defaultTopbarTheme;
    }

    public Long getLogoId() {
        SettingValue logoId = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGO_ID_SETTING_KEY);
        if (logoId != null && logoId.getValue() != null) {
            return Long.parseLong((String)logoId.getValue());
        }
        return null;
    }

    public Long getFaviconId() {
        SettingValue faviconId = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, BRANDING_FAVICON_ID_SETTING_KEY);
        if (faviconId != null && faviconId.getValue() != null) {
            return Long.parseLong((String)faviconId.getValue());
        }
        return null;
    }

    public Long getLoginBackgroundId() {
        SettingValue loginBackgroundId = this.settingService.get(Context.GLOBAL, Scope.GLOBAL, "authentication.background");
        if (loginBackgroundId != null && loginBackgroundId.getValue() != null) {
            return Long.parseLong((String)loginBackgroundId.getValue());
        }
        return null;
    }

    public Logo getLogo() {
        if (this.logo == null) {
            try {
                Long imageId = this.getLogoId();
                this.logo = imageId != null && imageId > 0L ? this.retrieveStoredBrandingFile(imageId, new Logo()) : this.retrieveDefaultBrandingFile(this.defaultConfiguredLogoPath, new Logo());
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving logo", (Throwable)e);
            }
        }
        return this.logo;
    }

    public Favicon getFavicon() {
        if (this.favicon == null) {
            try {
                Long imageId = this.getFaviconId();
                this.favicon = imageId != null ? this.retrieveStoredBrandingFile(imageId, new Favicon()) : this.retrieveDefaultBrandingFile(this.defaultConfiguredFaviconPath, new Favicon());
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving favicon", (Throwable)e);
            }
        }
        return this.favicon;
    }

    public Background getLoginBackground() {
        if (this.loginBackground == null) {
            try {
                Long imageId = this.getLoginBackgroundId();
                this.loginBackground = imageId != null ? this.retrieveStoredBrandingFile(imageId, new Background()) : (StringUtils.isNotBlank((CharSequence)this.defaultConfiguredLoginBgPath) ? this.retrieveDefaultBrandingFile(this.defaultConfiguredLoginBgPath, new Background()) : new Background());
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving login background", (Throwable)e);
            }
        }
        return this.loginBackground;
    }

    public String getLogoPath() {
        Logo brandingLogo = this.getLogo();
        return brandingLogo == null || brandingLogo.getData() == null ? null : BRANDING_LOGO_BASE_PATH + Objects.hash(brandingLogo.getUpdatedDate());
    }

    public String getFaviconPath() {
        Favicon brandingFavicon = this.getFavicon();
        return brandingFavicon == null || brandingFavicon.getData() == null ? null : BRANDING_FAVICON_BASE_PATH + Objects.hash(brandingFavicon.getUpdatedDate());
    }

    public String getLoginBackgroundPath() {
        Background background = this.getLoginBackground();
        return background == null || background.getData() == null ? null : BRANDING_LOGIN_BG_BASE_PATH + Objects.hash(background.getUpdatedDate());
    }

    public void updateTopBarTheme(String topBarTheme) {
        this.updateTopBarTheme(topBarTheme, true);
    }

    public void updateLastUpdatedTime(long lastUpdatedTimestamp) {
        if (lastUpdatedTimestamp <= 0L) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_LAST_UPDATED_TIME_KEY, SettingValue.create((Long)lastUpdatedTimestamp));
        }
    }

    public void updateLogo(Logo logo) {
        this.updateLogo(logo, true);
    }

    public void updateFavicon(Favicon favicon) {
        this.updateFavicon(favicon, true);
    }

    public void updateLoginBackground(Background loginBackground) {
        this.updateLoginBackground(loginBackground, true);
    }

    public void updateThemeColors(Map<String, String> themeColors) {
        this.updateThemeColors(themeColors, true);
    }

    public Map<String, String> getThemeColors() {
        if (this.themeVariables == null || this.themeVariables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> themeColors = new HashMap<String, String>();
        Set<String> variables = this.themeVariables.keySet();
        for (String themeVariable : variables) {
            SettingValue storedColorValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
            String colorValue = storedColorValue == null || storedColorValue.getValue() == null ? this.themeVariables.get(themeVariable) : storedColorValue.getValue().toString();
            if (!StringUtils.isNotBlank((CharSequence)colorValue)) continue;
            themeColors.put(themeVariable, colorValue);
        }
        return themeColors;
    }

    public Map<String, String> getLoginTitle() {
        if (this.loginTitle == null) {
            HashMap<String, String> valuePerLanguage = new HashMap<String, String>();
            for (String language : this.supportedLanguages.keySet()) {
                SettingValue storedValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_TITLE_SETTING_KEY + language);
                if (storedValue == null || storedValue.getValue() == null) continue;
                valuePerLanguage.put(language, storedValue.getValue().toString());
            }
            valuePerLanguage.computeIfAbsent(this.getDefaultLanguage(), key -> this.defaultLoginTitle);
            this.loginTitle = valuePerLanguage;
        }
        return Collections.unmodifiableMap(this.loginTitle);
    }

    public Map<String, String> getLoginSubtitle() {
        if (this.loginSubtitle == null) {
            HashMap<String, String> valuePerLanguage = new HashMap<String, String>();
            for (String language : this.supportedLanguages.keySet()) {
                SettingValue storedValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_SUBTITLE_SETTING_KEY + language);
                if (storedValue == null || storedValue.getValue() == null) continue;
                valuePerLanguage.put(language, storedValue.getValue().toString());
            }
            valuePerLanguage.computeIfAbsent(this.getDefaultLanguage(), key -> this.defaultLoginSubtitle);
            this.loginSubtitle = valuePerLanguage;
        }
        return Collections.unmodifiableMap(this.loginSubtitle);
    }

    public String getLoginTitle(Locale locale) {
        Map<String, String> valuePerLanguage = this.getLoginTitle();
        if (valuePerLanguage.containsKey(locale.getLanguage())) {
            return valuePerLanguage.get(locale.getLanguage());
        }
        return valuePerLanguage.getOrDefault(this.getDefaultLanguage(), this.defaultLoginTitle);
    }

    public String getLoginSubtitle(Locale locale) {
        Map<String, String> valuePerLanguage = this.getLoginSubtitle();
        if (valuePerLanguage.containsKey(locale.getLanguage())) {
            return valuePerLanguage.get(locale.getLanguage());
        }
        return valuePerLanguage.getOrDefault(this.getDefaultLanguage(), this.defaultLoginTitle);
    }

    private void loadInitParams(InitParams initParams) {
        if (initParams != null) {
            ValuesParam lessVariablesParam;
            ValueParam lessFileParam;
            ValueParam loginSubtitleParam;
            ValueParam loginTitleParam;
            ValueParam loginBackgroundParam;
            ValueParam favIconParam;
            ValueParam logoParam;
            ValueParam siteNameParam;
            ValueParam companyLinkParam;
            ValueParam companyNameParam = initParams.getValueParam("exo.branding.company.name");
            if (companyNameParam != null) {
                this.defaultCompanyName = companyNameParam.getValue();
            }
            if ((companyLinkParam = initParams.getValueParam("exo.branding.company.link")) != null) {
                this.defaultCompanyLink = companyLinkParam.getValue();
            }
            if ((siteNameParam = initParams.getValueParam("exo.branding.company.siteName")) != null) {
                this.defaultSiteName = siteNameParam.getValue();
            }
            if ((logoParam = initParams.getValueParam(BRANDING_LOGO_INIT_PARAM)) != null) {
                this.defaultConfiguredLogoPath = logoParam.getValue();
            }
            if ((favIconParam = initParams.getValueParam(BRANDING_FAVICON_INIT_PARAM)) != null) {
                this.defaultConfiguredFaviconPath = favIconParam.getValue();
            }
            if ((loginBackgroundParam = initParams.getValueParam("authentication.background")) != null) {
                this.defaultConfiguredLoginBgPath = loginBackgroundParam.getValue();
            }
            if ((loginTitleParam = initParams.getValueParam(BRANDING_LOGIN_TITLE_PARAM)) != null) {
                this.defaultLoginTitle = loginTitleParam.getValue();
            }
            if ((loginSubtitleParam = initParams.getValueParam(BRANDING_LOGIN_SUBTITLE_PARAM)) != null) {
                this.defaultLoginSubtitle = loginSubtitleParam.getValue();
            }
            if ((lessFileParam = initParams.getValueParam(BRANDING_THEME_LESS_PATH)) != null) {
                this.lessFilePath = lessFileParam.getValue();
            }
            if ((lessVariablesParam = initParams.getValuesParam(BRANDING_THEME_VARIABLES)) != null) {
                List variables = lessVariablesParam.getValues();
                this.themeVariables = new HashMap<String, String>();
                for (String themeVariable : variables) {
                    if (StringUtils.isBlank((CharSequence)themeVariable) || !themeVariable.contains(":")) continue;
                    String[] themeVariablesPart = themeVariable.split(":");
                    this.themeVariables.put(themeVariablesPart[0], themeVariablesPart[1]);
                }
            }
        }
    }

    private void loadLanguages() {
        Locale defaultLocale = this.getDefaultLocale();
        this.supportedLanguages = this.localeConfigService.getLocalConfigs() == null ? Collections.singletonMap(defaultLocale.getLanguage(), this.getLocaleDisplayName(defaultLocale, defaultLocale)) : this.localeConfigService.getLocalConfigs().stream().filter(localeConfig -> !StringUtils.equals((CharSequence)localeConfig.getLocaleName(), (CharSequence)"ma")).collect(Collectors.toMap(LocaleConfig::getLocaleName, localeConfig -> this.getLocaleDisplayName(defaultLocale, localeConfig.getLocale())));
    }

    private Locale getDefaultLocale() {
        return this.localeConfigService.getDefaultLocaleConfig() == null ? Locale.getDefault() : this.localeConfigService.getDefaultLocaleConfig().getLocale();
    }

    private String getDefaultLanguage() {
        return this.getDefaultLocale().toLanguageTag();
    }

    private String getLocaleDisplayName(Locale defaultLocale, Locale locale) {
        return defaultLocale.equals(locale) ? defaultLocale.getDisplayName(defaultLocale) : locale.getDisplayName(defaultLocale) + " / " + locale.getDisplayName(locale);
    }

    private void updateTopBarTheme(String topBarTheme, boolean updateLastUpdatedTime) {
        if (StringUtils.isBlank((CharSequence)topBarTheme)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_TOPBAR_THEME_SETTING_KEY, SettingValue.create((String)topBarTheme));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateCompanyLink(String companyLink, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)companyLink)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.link", SettingValue.create((String)companyLink));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateSiteName(String siteName, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)siteName)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.siteName", SettingValue.create((String)siteName));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateLoginBackgroundTextColor(String textColor, boolean updateLastUpdatedTime) {
        if (StringUtils.isBlank((CharSequence)textColor)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGIN_TEXT_COLOR_KEY);
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, BRANDING_LOGIN_TEXT_COLOR_KEY, SettingValue.create((String)textColor));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateCompanyName(String companyName, boolean updateLastUpdatedTime) {
        if (StringUtils.isEmpty((CharSequence)companyName)) {
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name");
        } else {
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, "exo.branding.company.name", SettingValue.create((String)companyName));
        }
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateThemeColors(Map<String, String> themeColors, boolean updateLastUpdatedTime) {
        if (this.themeVariables == null || this.themeVariables.isEmpty()) {
            return;
        }
        Set<String> variables = this.themeVariables.keySet();
        for (String themeVariable : variables) {
            if (themeColors != null && themeColors.get(themeVariable) != null) {
                String themeColor = themeColors.get(themeVariable);
                this.settingService.set(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable, SettingValue.create((String)themeColor));
                continue;
            }
            this.settingService.remove(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
        }
        this.computeThemeCSS();
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateLoginTitle(Map<String, String> titles) {
        for (String language : this.supportedLanguages.keySet()) {
            if (titles.containsKey(language)) {
                String value = titles.get(language);
                this.settingService.set(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_TITLE_SETTING_KEY + language, SettingValue.create((String)(value == null ? "" : value)));
                continue;
            }
            this.settingService.remove(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_TITLE_SETTING_KEY + language);
        }
        this.loginTitle = null;
    }

    private void updateLoginSubtitle(Map<String, String> subtitles) {
        for (String language : this.supportedLanguages.keySet()) {
            if (subtitles.containsKey(language)) {
                String value = subtitles.get(language);
                this.settingService.set(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_SUBTITLE_SETTING_KEY + language, SettingValue.create((String)(value == null ? "" : value)));
                continue;
            }
            this.settingService.remove(BRANDING_CONTEXT, BRANDING_SCOPE, BRANDING_SUBTITLE_SETTING_KEY + language);
        }
        this.loginSubtitle = null;
    }

    private void updateLogo(Logo logo, boolean updateLastUpdatedTime) {
        this.updateBrandingFile((BrandingFile)logo, LOGO_NAME, this.getLogoId(), BRANDING_LOGO_ID_SETTING_KEY);
        this.logo = null;
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateFavicon(Favicon favicon, boolean updateLastUpdatedTime) {
        this.updateBrandingFile((BrandingFile)favicon, FAVICON_NAME, this.getFaviconId(), BRANDING_FAVICON_ID_SETTING_KEY);
        this.favicon = null;
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateLoginBackground(Background loginBackground, boolean updateLastUpdatedTime) {
        this.updateBrandingFile((BrandingFile)loginBackground, LOGIN_BACKGROUND_NAME, this.getLoginBackgroundId(), "authentication.background");
        this.loginBackground = null;
        if (updateLastUpdatedTime) {
            this.updateLastUpdatedTime(System.currentTimeMillis());
        }
    }

    private void updateBrandingFile(BrandingFile brandingFile, String fileName, Long fileId, String settingKey) {
        String uploadId;
        String string = uploadId = brandingFile == null ? null : brandingFile.getUploadId();
        if (StringUtils.isNotBlank((CharSequence)uploadId)) {
            try {
                if (StringUtils.equals((CharSequence)BRANDING_RESET_ATTACHMENT_ID, (CharSequence)uploadId)) {
                    this.removeBrandingFile(fileId, settingKey);
                } else {
                    this.updateBrandingFileByUploadId(uploadId, fileName, fileId, settingKey);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Error while updating login background", e);
            }
        }
    }

    private void removeBrandingFile(Long fileId, String settingKey) {
        if (fileId != null) {
            this.fileService.deleteFile(fileId.longValue());
            this.settingService.remove(Context.GLOBAL, Scope.GLOBAL, settingKey);
        }
    }

    private void updateBrandingFileByUploadId(String uploadId, String fileName, Long fileId, String settingKey) throws Exception {
        InputStream inputStream = this.getUploadDataAsStream(uploadId);
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot update " + fileName + ", the object must contain the image data or an upload id");
        }
        int size = inputStream.available();
        FileItem fileItem = new FileItem(fileId, fileName, "image/png", FILE_API_NAME_SPACE, (long)size, new Date(), this.getCurrentUserId(), false, inputStream);
        if (fileId == null) {
            fileItem = this.fileService.writeFile(fileItem);
            this.settingService.set(Context.GLOBAL, Scope.GLOBAL, settingKey, SettingValue.create((String)String.valueOf(fileItem.getFileInfo().getId())));
        } else {
            this.fileService.updateFile(fileItem);
        }
    }

    private String computeThemeCSS() {
        if (StringUtils.isNotBlank((CharSequence)this.lessFilePath)) {
            try {
                InputStream inputStream = this.configurationManager.getInputStream(this.lessFilePath);
                this.lessThemeContent = IOUtil.getStreamContentAsString((InputStream)inputStream);
            }
            catch (Exception e) {
                LOG.warn((Object)"Error retrieving less file content", (Throwable)e);
            }
        }
        if (this.themeVariables != null && !this.themeVariables.isEmpty()) {
            Set<String> variables = this.themeVariables.keySet();
            for (String themeVariable : variables) {
                SettingValue storedColorValue = this.settingService.get(BRANDING_CONTEXT, BRANDING_SCOPE, themeVariable);
                String colorValue = storedColorValue == null || storedColorValue.getValue() == null ? this.themeVariables.get(themeVariable) : storedColorValue.getValue().toString();
                if (!StringUtils.isNotBlank((CharSequence)colorValue) || !StringUtils.isNotBlank((CharSequence)this.lessThemeContent)) continue;
                this.lessThemeContent = this.lessThemeContent.replaceAll("@" + themeVariable + ":[ #a-zA-Z0-9]*;?\r?\n", "@" + themeVariable + ": " + colorValue + ";\n");
            }
            if (StringUtils.isNotBlank((CharSequence)this.lessThemeContent)) {
                ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                try {
                    LessCompiler.Configuration configuration = new LessCompiler.Configuration();
                    configuration.getSourceMapConfiguration().setLinkSourceMap(false);
                    LessCompiler.CompilationResult result = compiler.compile(this.lessThemeContent, configuration);
                    this.themeCSSContent = result.getCss();
                }
                catch (Less4jException e) {
                    LOG.warn((Object)"Error compiling less file content", (Throwable)e);
                }
            }
        }
        return this.themeCSSContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getUploadDataAsStream(String uploadId) throws FileNotFoundException {
        UploadResource uploadResource = this.uploadService.getUploadResource(uploadId);
        if (uploadResource == null) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(new File(uploadResource.getStoreLocation()));
            return fileInputStream;
        }
        finally {
            this.uploadService.removeUploadResource(uploadId);
        }
    }

    private String getCurrentUserId() {
        ConversationState conversationState = ConversationState.getCurrent();
        if (conversationState != null && conversationState.getIdentity() != null) {
            return conversationState.getIdentity().getUserId();
        }
        return null;
    }

    private <T extends BrandingFile> T retrieveStoredBrandingFile(long imageId, T brandingFile) throws FileStorageException {
        FileItem fileItem = this.fileService.getFile(imageId);
        if (fileItem != null) {
            brandingFile.setData(fileItem.getAsByte());
            brandingFile.setSize(fileItem.getFileInfo().getSize());
            brandingFile.setUpdatedDate(fileItem.getFileInfo().getUpdatedDate().getTime());
            brandingFile.setFileId(imageId);
        }
        return brandingFile;
    }

    private <T extends BrandingFile> T retrieveDefaultBrandingFile(String imagePath, T brandingFile) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)imagePath)) {
            File file = new File(imagePath);
            if (file.exists()) {
                brandingFile.setData(Files.readAllBytes(file.toPath()));
                brandingFile.setSize(file.length());
                brandingFile.setUpdatedDate(file.lastModified());
            } else {
                InputStream is = this.container.getPortalContext().getResourceAsStream(imagePath);
                if (is != null) {
                    byte[] streamContentAsBytes = IOUtil.getStreamContentAsBytes((InputStream)is);
                    brandingFile.setData(streamContentAsBytes);
                    brandingFile.setSize((long)streamContentAsBytes.length);
                    brandingFile.setUpdatedDate(DEFAULT_LAST_MODIFED);
                }
            }
        }
        return brandingFile;
    }
}

