/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.NavigationCategoryService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.rest.EntityBuilder;
import org.exoplatform.portal.mop.rest.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.HttpUserPortalContext;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/v1/navigations")
@Tag(name="v1/navigations", description="Retrieve sites navigations")
public class NavigationRest
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(NavigationRest.class);
    private static final Visibility[] DEFAULT_VISIBILITIES = Visibility.values();
    private UserPortalConfigService portalConfigService;
    private NavigationCategoryService navigationCategoryService;
    private LayoutService layoutService;
    private OrganizationService organizationService;
    private UserACL userACL;

    public NavigationRest(UserPortalConfigService portalConfigService, NavigationCategoryService navigationCategoryService, LayoutService layoutService, OrganizationService organizationService, UserACL userACL) {
        this.portalConfigService = portalConfigService;
        this.navigationCategoryService = navigationCategoryService;
        this.layoutService = layoutService;
        this.organizationService = organizationService;
        this.userACL = userACL;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets navigations", description="Gets navigations", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Navigation does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSiteNavigation(@Context HttpServletRequest request, @Parameter(description="Offset", required=false) @Schema(defaultValue="0") @QueryParam(value="offset") int offset, @Parameter(description="Limit, if equals to 0, it will use default limit.", required=false) @Schema(defaultValue="20") @QueryParam(value="limit") int limit) {
        String username;
        HttpUserPortalContext userPortalContext = new HttpUserPortalContext(request);
        String portalName = this.portalConfigService.getDefaultPortal();
        ConversationState state = ConversationState.getCurrent();
        Identity userIdentity = state == null ? null : state.getIdentity();
        String string = username = userIdentity == null ? null : userIdentity.getUserId();
        if (StringUtils.equals((String)username, (String)IdentityConstants.ANONIM)) {
            username = null;
        }
        try {
            UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig(portalName, username, userPortalContext);
            List<ResultUserNavigation> allNavs = userPortalConfig.getUserPortal().getNavigations().stream().filter(this::isValidNavigation).map(ResultUserNavigation::new).toList();
            return Response.ok(allNavs).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error retrieving navigations", (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @Path(value="/{siteType}")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets navigations of one or multiple site navigations", description="Gets navigations of one or multiple site navigations", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="404", description="Navigation does not exist"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getSiteTypeNavigations(@Context HttpServletRequest request, @Parameter(description="Portal site type, possible values: PORTAL, GROUP or USER", required=true) @PathParam(value="siteType") String siteTypeName, @Parameter(description="Portal site name", required=true) @QueryParam(value="siteName") String siteName, @Parameter(description="Scope of navigations tree to retrieve, possible values: ALL, CHILDREN, GRANDCHILDREN, SINGLE", required=false) @Schema(defaultValue="ALL") @QueryParam(value="scope") String scopeName, @Parameter(description="parent navigation node id") @QueryParam(value="nodeId") String nodeId, @Parameter(description="Multivalued visibilities of navigation nodes to retrieve, possible values: DISPLAYED, HIDDEN, SYSTEM or TEMPORAL. If empty, all visibilities will be used.", required=false) @Schema(defaultValue="All possible values combined") @QueryParam(value="visibility") List<String> visibilityNames, @Parameter(description="if to include Global site in results in portal type case", required=false) @DefaultValue(value="true") @QueryParam(value="includeGlobal") boolean includeGlobal, @Parameter(description="to include extra node page details in results") @QueryParam(value="expand") boolean expand, @Parameter(description="to check the navigation nodes scheduling start and end dates") @DefaultValue(value="true") @QueryParam(value="temporalCheck") boolean temporalCheck) {
        if (StringUtils.isBlank((String)siteTypeName)) {
            return Response.status((int)400).build();
        }
        return this.getNavigations(request, siteTypeName, siteName, scopeName, nodeId, visibilityNames, includeGlobal, expand, temporalCheck);
    }

    @Path(value="/categories")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Gets navigations categories for UI", description="Gets navigations categories for UI", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getNavigationCategories() {
        try {
            JSONObject object = new JSONObject();
            object.put("navs", this.navigationCategoryService.getNavigationCategories());
            object.put("categoriesOrder", this.navigationCategoryService.getNavigationCategoriesOrder());
            object.put("urisOrder", this.navigationCategoryService.getNavigationUriOrder());
            return Response.ok((Object)object.toString()).build();
        }
        catch (JSONException e) {
            LOG.warn((Object)"Error parsing navigation categories result", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private Response getNavigations(HttpServletRequest request, String siteTypeName, String siteName, String scopeName, String nodeId, List<String> visibilityNames, boolean includeGlobal, boolean expand, boolean temporalCheck) {
        String username;
        ConversationState state = ConversationState.getCurrent();
        Identity userIdentity = state == null ? null : state.getIdentity();
        String string = username = userIdentity == null ? null : userIdentity.getUserId();
        if (StringUtils.equals((String)username, (String)IdentityConstants.ANONIM)) {
            username = null;
        }
        SiteType siteType = null;
        try {
            siteType = SiteType.valueOf((String)StringUtils.upperCase((String)siteTypeName));
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)("Bad site type: " + siteTypeName)).build();
        }
        Scope scope = null;
        try {
            scope = this.getScope(scopeName);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)e.getMessage()).build();
        }
        Visibility[] visibilities = null;
        try {
            visibilities = this.convertVisibilities(visibilityNames);
        }
        catch (Exception e) {
            return Response.status((int)400).entity((Object)("Bad visibility names: " + visibilityNames + ". should be one of " + DEFAULT_VISIBILITIES)).build();
        }
        UserNodeFilterConfig userFilterConfig = NavigationRest.getUserFilterConfig(visibilities, temporalCheck);
        String portalName = siteName;
        if (siteType != SiteType.PORTAL || StringUtils.isBlank((String)siteName)) {
            portalName = this.portalConfigService.getDefaultPortal();
        }
        try {
            HttpUserPortalContext userPortalContext = new HttpUserPortalContext(request);
            UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig(portalName, username, userPortalContext);
            if (userPortalConfig == null) {
                return Response.status((int)404).build();
            }
            UserPortal userPortal = userPortalConfig.getUserPortal();
            Collection<Object> nodes = new ArrayList();
            if (nodeId != null && siteName != null) {
                SiteKey siteKey = new SiteKey(siteTypeName, siteName);
                UserNode userNode = userPortal.getNodeById(nodeId, siteKey, scope, userFilterConfig, null);
                nodes.add(userNode);
            } else if (siteType == SiteType.PORTAL || StringUtils.isBlank((String)siteName)) {
                nodes = userPortal.getNodes(siteType, scope, userFilterConfig, includeGlobal);
            } else {
                UserNavigation navigation = userPortal.getNavigation(new SiteKey(siteType, siteName));
                if (navigation == null) {
                    return Response.status((int)404).build();
                }
                UserNode rootNode = userPortal.getNode(navigation, scope, userFilterConfig, null);
                nodes = rootNode.getChildren();
            }
            List<UserNodeRestEntity> resultNodes = EntityBuilder.toUserNodeRestEntity(nodes, expand, this.organizationService, this.layoutService, this.userACL);
            return Response.ok(resultNodes).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error retrieving ");
            return Response.status((int)500).build();
        }
    }

    private static UserNodeFilterConfig getUserFilterConfig(Visibility[] visibilities, boolean temporalCheck) {
        UserNodeFilterConfig.Builder builder = UserNodeFilterConfig.builder();
        builder.withReadWriteCheck().withVisibility(visibilities.length > 0 ? visibilities : DEFAULT_VISIBILITIES).withReadCheck();
        if (temporalCheck) {
            builder.withTemporalCheck();
        }
        return builder.build();
    }

    private Visibility[] convertVisibilities(List<String> visibilityNames) {
        if (visibilityNames == null) {
            return new Visibility[0];
        }
        return visibilityNames.stream().map(visibilityName -> Visibility.valueOf((String)StringUtils.upperCase((String)visibilityName))).toList().toArray(new Visibility[0]);
    }

    private Scope getScope(String scopeName) {
        Scope scope = null;
        if (StringUtils.isBlank((String)scopeName)) {
            scope = Scope.ALL;
        } else {
            switch (StringUtils.upperCase((String)scopeName)) {
                case "SINGLE": {
                    scope = Scope.SINGLE;
                    break;
                }
                case "CHILDREN": {
                    scope = Scope.CHILDREN;
                    break;
                }
                case "GRANDCHILDREN": {
                    scope = Scope.GRANDCHILDREN;
                    break;
                }
                case "ALL": {
                    scope = Scope.ALL;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bad scope name: " + scopeName);
                }
            }
        }
        return scope;
    }

    private boolean isValidNavigation(UserNavigation userNavigation) {
        return !userNavigation.getKey().getName().equals(this.portalConfigService.getGlobalPortal());
    }

    public static final class ResultUserNavigation {
        private SiteKey key;
        private String label;

        public SiteKey getKey() {
            return this.key;
        }

        public String getLabel() {
            return this.label;
        }

        public ResultUserNavigation(UserNavigation userNavigation) {
            this.key = userNavigation.getKey();
            if (this.key.getType().equals((Object)SiteType.GROUP)) {
                try {
                    OrganizationService orgService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
                    Group group = orgService.getGroupHandler().findGroupById(this.key.getName());
                    if (group != null) {
                        this.label = group.getLabel();
                    }
                }
                catch (Exception e) {
                    LOG.error("Error when getting group label {}", new Object[]{this.key.getName(), e});
                }
            } else {
                this.label = this.key.getName();
            }
        }
    }
}

