/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.service;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.importer.Status;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorage;
import org.exoplatform.portal.pom.data.ModelChange;
import org.exoplatform.portal.pom.data.ModelData;
import org.exoplatform.portal.pom.data.PageData;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class LayoutServiceImpl
implements LayoutService {
    private static final Log LOG = ExoLogger.getLogger(LayoutServiceImpl.class);
    private ListenerService listenerService;
    private SiteStorage siteStorage;
    private PageStorage pageStorage;
    private LayoutStorage layoutStorage;
    private Map<String, Container> sharedLayouts = new HashMap<String, Container>();

    public LayoutServiceImpl(ListenerService listenerService, SiteStorage siteStorage, PageStorage pageStorage, LayoutStorage layoutStorage) {
        this.listenerService = listenerService;
        this.siteStorage = siteStorage;
        this.pageStorage = pageStorage;
        this.layoutStorage = layoutStorage;
    }

    public void create(PortalConfig config) {
        this.siteStorage.create(config.build());
        this.broadcastEvent(PORTAL_CONFIG_CREATED, config);
    }

    public void save(PortalConfig config) {
        this.siteStorage.save(config);
        this.broadcastEvent(PORTAL_CONFIG_UPDATED, config);
    }

    public void remove(PortalConfig config) {
        this.siteStorage.remove(config);
        this.broadcastEvent(PORTAL_CONFIG_REMOVED, config);
    }

    public PortalConfig getPortalConfig(String portalName) {
        return this.getPortalConfig(PortalConfig.PORTAL_TYPE, portalName);
    }

    public PortalConfig getPortalConfig(SiteKey siteKey) {
        PortalData portalData = this.siteStorage.getPortalConfig(siteKey);
        return portalData == null ? null : new PortalConfig(portalData);
    }

    public PortalConfig getPortalConfig(String ownerType, String portalName) {
        return this.siteStorage.getPortalConfig(ownerType, portalName);
    }

    public List<String> getSiteNames(SiteType siteType, int offset, int limit) {
        return this.siteStorage.getSiteNames(siteType, offset, limit);
    }

    public void create(Page page) {
        this.pageStorage.save(page.build());
        this.broadcastEvent(PAGE_CREATED, page);
    }

    public List<ModelChange> save(Page page) {
        this.pageStorage.save(page.build());
        this.broadcastEvent(PAGE_UPDATED, page);
        return Collections.emptyList();
    }

    public void save(PageContext pageContext, Page page) {
        this.pageStorage.savePage(pageContext);
        this.pageStorage.save(page.build());
        this.broadcastEvent(PAGE_UPDATED, page);
    }

    public void save(PageContext pageContext) {
        this.pageStorage.savePage(pageContext);
        this.broadcastEvent(PAGE_UPDATED, this.pageStorage.getPage(pageContext.getKey()));
    }

    public void removePages(SiteKey siteKey) {
        List pages = this.pageStorage.loadPages(siteKey);
        pages.forEach(context -> this.remove(context.getKey()));
    }

    public void remove(PageKey pageKey) {
        Page page = this.pageStorage.getPage(pageKey);
        this.remove(page);
    }

    public void remove(Page page) {
        this.pageStorage.destroyPage(page.getPageKey());
    }

    public Page getPage(String pageId) {
        return this.pageStorage.getPage(pageId);
    }

    public Page getPage(PageKey pageKey) {
        return this.pageStorage.getPage(pageKey);
    }

    public PageContext getPageContext(PageKey pageKey) {
        return this.pageStorage.loadPage(pageKey);
    }

    public List<PageContext> findPages(SiteKey siteKey) {
        return this.pageStorage.loadPages(siteKey);
    }

    public QueryResult<PageContext> findPages(int offset, int limit, SiteType siteKey, String siteName, String pageName, String pageTitle) {
        return this.pageStorage.findPages(offset, limit, siteKey, siteName, pageName, pageTitle);
    }

    public <S> S load(ApplicationState<S> state, ApplicationType<S> type) {
        return this.layoutStorage.load(state, type);
    }

    public <S> ApplicationState<S> save(ApplicationState<S> state, S preferences) {
        return this.layoutStorage.save(state, preferences);
    }

    public <S> String getId(ApplicationState<S> state) {
        return this.layoutStorage.getId(state);
    }

    public <S> Application<S> getApplicationModel(String applicationStorageId) {
        return this.layoutStorage.getApplicationModel(applicationStorageId);
    }

    public Container getSharedLayout(String siteName) {
        String cacheKey = siteName;
        if (StringUtils.isBlank((CharSequence)cacheKey)) {
            cacheKey = "DEFAULT-SITE";
        }
        if (PropertyManager.isDevelopping() || !this.sharedLayouts.containsKey(cacheKey)) {
            Container sharedLayout = this.siteStorage.getSharedLayout(siteName);
            if (sharedLayout == null && StringUtils.isNotBlank((CharSequence)siteName)) {
                return this.getSharedLayout(null);
            }
            this.sharedLayouts.put(cacheKey, sharedLayout);
        }
        return this.sharedLayouts.get(cacheKey);
    }

    public Status getImportStatus() {
        return this.siteStorage.getImportStatus();
    }

    public void saveImportStatus(Status status) {
        this.siteStorage.saveImportStatus(status);
    }

    public <T> LazyPageList<T> find(Query<T> q, Comparator<T> sortComparator) {
        return new LazyPageList(this.find2(q, sortComparator), 10);
    }

    public <T> ListAccess<T> find2(Query<T> q, Comparator<T> sortComparator) {
        Class type = q.getClassType();
        if (type == Page.class) {
            Bilto<Page, PageData> bilto = new Bilto<Page, PageData>(q, PageData.class, sortComparator){

                @Override
                protected Page create(PageData pageData) {
                    return new Page(pageData);
                }
            };
            return bilto.execute();
        }
        if (type == PortalConfig.class) {
            Bilto<PortalConfig, PortalData> bilto = new Bilto<PortalConfig, PortalData>(q, PortalData.class, sortComparator){

                @Override
                protected PortalConfig create(PortalData portalData) {
                    return new PortalConfig(portalData);
                }
            };
            return bilto.execute();
        }
        throw new UnsupportedOperationException("Cannot query type " + type);
    }

    public <T> LazyPageList<T> findLazyPageList(Query<T> q) {
        Class type = q.getClassType();
        if (PageData.class.equals((Object)type)) {
            throw new UnsupportedOperationException("Use PageService.findPages to instead of");
        }
        if (PortletPreferences.class.equals((Object)type)) {
            return new LazyPageList(new ListAccess<T>(){

                public T[] load(int index, int length) throws Exception {
                    throw new AssertionError();
                }

                public int getSize() throws Exception {
                    return 0;
                }
            }, 10);
        }
        if (PortalData.class.equals((Object)type)) {
            final String ownerType = q.getOwnerType();
            ListAccess<PortalData> la = new ListAccess<PortalData>(){
                private int cacheOffset;
                private int cacheLimit;
                private List<String> siteNames;

                public PortalData[] load(int offset, int limit) throws Exception {
                    SiteType siteType = ownerType == null ? SiteType.PORTAL : SiteType.valueOf((String)ownerType.toUpperCase());
                    return this.getSiteNames(offset, limit).stream().map(siteName -> LayoutServiceImpl.this.siteStorage.getPortalConfig(new SiteKey(siteType.getName(), siteName))).toList().toArray(new PortalData[this.siteNames.size()]);
                }

                public int getSize() throws Exception {
                    return this.getSiteNames(0, -1).size();
                }

                private List<String> getSiteNames(int offset, int limit) {
                    if (this.siteNames == null || this.cacheOffset != offset || this.cacheLimit != limit) {
                        SiteType siteType = ownerType == null ? SiteType.PORTAL : SiteType.valueOf((String)ownerType.toUpperCase());
                        this.siteNames = LayoutServiceImpl.this.siteStorage.getSiteNames(siteType, offset, limit);
                        this.cacheOffset = offset;
                        this.cacheLimit = limit;
                    }
                    return this.siteNames;
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
        if (PortalKey.class.equals((Object)type) && ("portal".equals(q.getOwnerType()) || "group".equals(q.getOwnerType()))) {
            final String ownerType = q.getOwnerType();
            ListAccess<PortalKey> la = new ListAccess<PortalKey>(){
                private List<String> siteNames;

                public PortalKey[] load(int offset, int limit) throws Exception {
                    return this.getSiteNames(offset, limit).stream().map(siteName -> new PortalKey(ownerType, siteName)).toList().toArray(new PortalKey[this.siteNames.size()]);
                }

                public int getSize() throws Exception {
                    return this.getSiteNames(0, -1).size();
                }

                private List<String> getSiteNames(int offset, int limit) {
                    if (this.siteNames == null) {
                        SiteType siteType = SiteType.PORTAL;
                        if (ownerType != null) {
                            siteType = SiteType.valueOf((String)ownerType.toUpperCase());
                        }
                        this.siteNames = LayoutServiceImpl.this.siteStorage.getSiteNames(siteType, offset, limit);
                    }
                    return this.siteNames;
                }
            };
            return new LazyPageList((ListAccess)la, 10);
        }
        throw new UnsupportedOperationException("Could not perform search on query " + q);
    }

    protected void broadcastEvent(String eventName, Object data) {
        try {
            this.listenerService.broadcast(eventName, (Object)this, data);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when broadcasting notification " + eventName + " for " + data), (Throwable)e);
        }
    }

    private abstract class Bilto<O extends ModelObject, D extends ModelData> {
        final Query<O> q;
        final Class<D> dataType;
        final Comparator<O> cp;

        Bilto(Query<O> q, Class<D> dataType, Comparator<O> cp) {
            this.q = q;
            this.dataType = dataType;
            this.cp = cp;
        }

        protected abstract O create(D var1);

        ListAccess<O> execute() {
            List<D> tmp;
            Query delegateQ = new Query(this.q, this.dataType);
            LazyPageList r = LayoutServiceImpl.this.findLazyPageList(delegateQ);
            try {
                tmp = r.getAll();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error retrieving element with query " + this.q, e);
            }
            final List<D> list = tmp = this.sort(tmp, this.cp);
            return new ListAccess<O>(){

                public int getSize() {
                    return list.size();
                }

                public O[] load(int index, int length) {
                    ModelObject[] pages = (ModelObject[])Array.newInstance(Bilto.this.q.getClassType(), length);
                    int i = 0;
                    for (ModelData data : list.subList(index, index + length)) {
                        pages[i++] = Bilto.this.create(data);
                    }
                    return pages;
                }
            };
        }

        private List<D> sort(List<D> list, Comparator<O> comparator) {
            if (comparator != null) {
                ArrayList<ModelData> tmpList = new ArrayList<ModelData>();
                for (int i = 0; i < list.size(); ++i) {
                    tmpList.add((ModelData)list.get(i));
                }
                Collections.sort(tmpList, (d1, d2) -> {
                    O o1 = this.create(d1);
                    O o2 = this.create(d2);
                    return comparator.compare(o1, o2);
                });
                return tmpList;
            }
            return list;
        }
    }
}

