/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.storage.cache;

import java.io.Serializable;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.dao.SiteDAO;
import org.exoplatform.portal.mop.storage.LayoutStorage;
import org.exoplatform.portal.mop.storage.NavigationStorage;
import org.exoplatform.portal.mop.storage.PageStorage;
import org.exoplatform.portal.mop.storage.SiteStorageImpl;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.PortalKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CacheSiteStorage
extends SiteStorageImpl {
    public static final String SITE_CACHE_NAME = "portal.SiteService";
    private final FutureExoCache<SiteKey, PortalData, Object> siteFutureCache;
    private final ExoCache<SiteKey, PortalData> siteCache;

    public CacheSiteStorage(CacheService cacheService, SettingService settingService, ConfigurationManager configurationManager, NavigationStorage navigationStorage, PageStorage pageStorage, LayoutStorage layoutStorage, SiteDAO siteDAO) {
        super(settingService, configurationManager, navigationStorage, pageStorage, layoutStorage, siteDAO);
        this.siteCache = cacheService.getCacheInstance(SITE_CACHE_NAME);
        this.siteFutureCache = new FutureExoCache((Loader)new Loader<SiteKey, PortalData, Object>(){

            public PortalData retrieve(Object context, SiteKey siteKey) throws Exception {
                PortalData portalData = CacheSiteStorage.super.getPortalConfig(siteKey);
                return portalData == null ? PortalData.NULL_OBJECT : portalData;
            }
        }, this.siteCache);
    }

    @Override
    public void create(PortalData config) {
        try {
            super.create(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
        }
    }

    @Override
    public void save(PortalData config) {
        try {
            super.save(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
        }
    }

    @Override
    public void remove(PortalData config) {
        try {
            super.remove(config);
        }
        finally {
            this.siteFutureCache.remove((Serializable)this.getSiteKey(config.getKey()));
        }
    }

    @Override
    public PortalData getPortalConfig(SiteKey key) {
        PortalData portalData = (PortalData)this.siteFutureCache.get(null, (Object)key);
        return portalData == null || portalData.isNull() ? null : portalData;
    }

    private SiteKey getSiteKey(PortalKey portalKey) {
        return new SiteKey(portalKey.getType(), portalKey.getId());
    }
}

