/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.application.registry.Application;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.CloneApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIComponentFactory;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIApplicationList;
import org.exoplatform.portal.webui.portal.UIContainerList;
import org.exoplatform.portal.webui.portal.UILanguageSelector;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.portal.UIPortalComposer;
import org.exoplatform.portal.webui.portal.UIPortalForm;
import org.exoplatform.portal.webui.portal.UISkinSelector;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIEditInlineWorkspace;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIPortalToolPanel;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UITabPane;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

public class UIPortalComponentActionListener {
    private static Log log = ExoLogger.getLogger(UIPortalComponentActionListener.class);
    private static final String UI_PORTLET_PREFIX = "UIPortlet-";

    private static void removeUIComponent(UIComponent uiComponent, PortalRequestContext pcontext, boolean isUpdate) {
        org.exoplatform.webui.core.UIContainer uiParent = (org.exoplatform.webui.core.UIContainer)uiComponent.getParent();
        uiParent.getChildren().remove(uiComponent);
        RequireJS module = pcontext.getJavascriptManager().require("SHARED/portal", "portal");
        if (isUpdate) {
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiParent);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
        } else {
            StringBuffer buffer = new StringBuffer();
            buffer.append("portal.UIPortal.removeComponent('");
            if (uiComponent instanceof UIPortlet) {
                buffer.append(UI_PORTLET_PREFIX);
            }
            buffer.append(uiComponent.getId());
            buffer.append("');");
            module.addScripts(buffer.toString());
        }
        module.require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
    }

    private static boolean canMove(UIComponent child, org.exoplatform.webui.core.UIContainer parent) {
        if (parent instanceof UIContainer) {
            UIContainer targetContainer = (UIContainer)parent;
            if (child instanceof UIPortlet) {
                return targetContainer.hasMoveAppsPermission();
            }
            if (child instanceof UIContainer) {
                return targetContainer.hasMoveContainersPermission();
            }
            if (child instanceof UIPageBody) {
                return true;
            }
            log.warn((Object)("Unexpected uiSource type '" + child.getClass().getName() + "'."));
            return false;
        }
        return false;
    }

    public static class EditPortalPropertiesActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            String portalName = event.getRequestContext().getRequestParameter("portalName");
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UserPortalConfigService service = (UserPortalConfigService)uiApp.getApplicationComponent(UserPortalConfigService.class);
            PortalRequestContext context = Util.getPortalRequestContext();
            if (portalName != null && service.getUserPortalConfig(portalName, event.getRequestContext().getRemoteUser()) == null) {
                uiApp.addMessage(new ApplicationMessage("UISiteManagement.msg.portal-not-exist", (Object[])new String[]{portalName}));
                context.addUIComponentToUpdateByAjax(uiApp.findFirstComponentOfType(UIWorkingWorkspace.class));
                context.setFullRender(true);
                return;
            }
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UIPortalForm portalForm = uiMaskWS.createUIComponent(UIPortalForm.class, null, "UIPortalForm");
            portalForm.setEditingSiteKey(SiteKey.portal((String)portalName));
            portalForm.setBindingBean();
            uiMaskWS.setWindowSize(700, -1);
            context.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    public static class ChangeApplicationListActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortalApplication application = Util.getUIPortalApplication();
            UIPortalComposer composer = (UIPortalComposer)application.findFirstComponentOfType(UIPortalComposer.class);
            UITabPane uiTabPane = (UITabPane)composer.getChild(UITabPane.class);
            String appListId = ((UIApplicationList)uiTabPane.getChild(UIApplicationList.class)).getId();
            uiTabPane.replaceChild(appListId, composer.createUIComponent(UIApplicationList.class, null, null));
        }
    }

    public static class ChangeSkinActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            UISkinSelector uiChangeSkin = uiMaskWS.createUIComponent(UISkinSelector.class, null, null);
            uiMaskWS.setUIComponent((UIComponent)uiChangeSkin);
            uiMaskWS.setWindowSize(640, 400);
            uiMaskWS.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        }
    }

    public static class ChangeLanguageActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            UIPortalApplication uiPortalApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWorkspace = (UIMaskWorkspace)uiPortalApp.getChildById("UIMaskWorkspace");
            uiMaskWorkspace.createUIComponent(UILanguageSelector.class, null, null);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWorkspace);
        }
    }

    public static class MoveChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            UIWorkingWorkspace uiWorkingWS;
            UIComponent uiWorking;
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            String insertPosition = pcontext.getRequestParameter("insertPosition");
            int position = -1;
            try {
                position = Integer.parseInt(insertPosition);
            }
            catch (Exception exp) {
                position = -1;
            }
            boolean newComponent = false;
            String paramNewComponent = pcontext.getRequestParameter("isAddingNewly");
            if (paramNewComponent != null) {
                newComponent = Boolean.valueOf(paramNewComponent);
            }
            UIPortalApplication uiApp = (UIPortalApplication)((org.exoplatform.webui.core.UIContainer)event.getSource()).getAncestorOfType(UIPortalApplication.class);
            UIPortalComposer portalComposer = (UIPortalComposer)uiApp.findFirstComponentOfType(UIPortalComposer.class);
            if (newComponent) {
                portalComposer.updateWorkspaceComponent();
                pcontext.ignoreAJAXUpdateOnPortlets(true);
            }
            if (!(uiWorking = (uiWorkingWS = (UIWorkingWorkspace)uiApp.getChild(UIWorkingWorkspace.class)).findFirstComponentOfType(UIPortalToolPanel.class)).isRendered()) {
                UIEditInlineWorkspace uiEditWS = (UIEditInlineWorkspace)uiWorkingWS.getChild(UIEditInlineWorkspace.class);
                uiWorking = uiEditWS.getUIComponent();
            }
            String sourceId = pcontext.getRequestParameter("srcID");
            UIComponent uiSource = uiWorking.findComponentById(sourceId);
            org.exoplatform.webui.core.UIContainer uiTarget = (org.exoplatform.webui.core.UIContainer)uiWorking.findComponentById(pcontext.getRequestParameter("targetID"));
            if (position < 0 && uiTarget.getChildren().size() > 0) {
                position = uiTarget.getChildren().size();
            } else if (position < 0) {
                position = 0;
            }
            if (uiSource == null) {
                uiSource = this.prepareUiSource(newComponent, uiApp, portalComposer, sourceId, uiTarget);
            }
            if (UIPortalComponentActionListener.canMove(uiSource, uiTarget)) {
                this.move(position, uiSource, uiTarget, pcontext);
            } else {
                portalComposer.updateWorkspaceComponent();
                pcontext.ignoreAJAXUpdateOnPortlets(true);
            }
        }

        private void tidyUp(PortalRequestContext pcontext, UIComponent uiSource) {
            UIContainer uiParent = (UIContainer)uiSource.getParent();
            if ("TabContainer".equals(uiParent.getFactoryId())) {
                if (uiParent.getChildren().size() == 1) {
                    org.exoplatform.webui.core.UIContainer uiTabParent = (org.exoplatform.webui.core.UIContainer)uiParent.getParent();
                    if (uiTabParent.getChildren().size() > 1) {
                        UIPortalComponentActionListener.removeUIComponent((UIComponent)uiParent, pcontext, false);
                    } else {
                        UIPortalComponentActionListener.removeUIComponent((UIComponent)uiTabParent, pcontext, false);
                    }
                } else {
                    uiParent.getChildren().remove(uiSource);
                    pcontext.addUIComponentToUpdateByAjax((UIComponent)uiParent);
                    pcontext.ignoreAJAXUpdateOnPortlets(true);
                }
            } else if ("TableColumnContainer".equals(uiParent.getFactoryId()) && uiParent.getChildren().size() == 1) {
                UIPortalComponentActionListener.removeUIComponent((UIComponent)uiParent, pcontext, false);
            } else {
                uiParent.getChildren().remove(uiSource);
            }
        }

        private UIComponent prepareUiSource(boolean newComponent, UIPortalApplication uiApp, UIPortalComposer portalComposer, String sourceId, org.exoplatform.webui.core.UIContainer uiTarget) throws Exception {
            UIPortalComponent uiSource;
            UITabPane subTabPane = (UITabPane)portalComposer.getChild(UITabPane.class);
            UIContainerList uiContainerConfig = (UIContainerList)subTabPane.getChild(UIContainerList.class);
            if (uiContainerConfig != null && subTabPane.getSelectedTabId().equals(uiContainerConfig.getId())) {
                Container container = uiContainerConfig.getContainer(sourceId);
                UIComponentFactory<UIContainer> factory = UIComponentFactory.getInstance(UIContainer.class);
                UIContainer uiContainer = factory.createUIComponent(container.getFactoryId(), (WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
                if (uiContainer == null) {
                    log.warn("Can't find container factory for: {}. Default container is used", new Object[]{container.getFactoryId()});
                    uiContainer = (UIContainer)uiTarget.createUIComponent(UIContainer.class, null, null);
                }
                container.setId(String.valueOf(Math.abs(container.hashCode())));
                uiContainer.setStorageId(container.getStorageId());
                PortalDataMapper.toUIContainer(uiContainer, container);
                uiSource = uiContainer;
            } else {
                String[] accessPers;
                UIApplicationList appList = (UIApplicationList)uiApp.findFirstComponentOfType(UIApplicationList.class);
                Application app = appList.getApplication(sourceId);
                ApplicationType applicationType = app.getType();
                UIPortlet uiPortlet = (UIPortlet)uiTarget.createUIComponent(UIPortlet.class, null, null);
                uiPortlet.setDescription(app.getDescription());
                ArrayList accessPersList = app.getAccessPermissions();
                for (String accessPer : accessPers = accessPersList.toArray(new String[accessPersList.size()])) {
                    if (!accessPer.equals("")) continue;
                    accessPers = null;
                }
                if (accessPers == null || accessPers.length == 0) {
                    accessPers = new String[]{"Everyone"};
                }
                uiPortlet.setAccessPermissions(accessPers);
                Object state = newComponent ? new TransientApplicationState(app.getContentId()) : new CloneApplicationState(app.getStorageId());
                PortletState newState = new PortletState(state, applicationType);
                uiPortlet.setState(newState);
                uiPortlet.setPortletInPortal(uiTarget instanceof UIPortal);
                UIPortal currentPortal = Util.getUIPortal();
                LayoutService layoutService = (LayoutService)uiApp.getApplicationComponent(LayoutService.class);
                uiPortlet.setShowInfoBar(layoutService.getPortalConfig(currentPortal.getSiteKey().getTypeName(), currentPortal.getSiteKey().getName()).isShowInfobar());
                uiSource = uiPortlet;
            }
            return uiSource;
        }

        private void move(int position, UIComponent uiSource, org.exoplatform.webui.core.UIContainer uiTarget, PortalRequestContext pcontext) {
            UIContainer uiParent = (UIContainer)uiSource.getParent();
            List children = uiTarget.getChildren();
            if (uiParent == uiTarget) {
                int currentIdx = children.indexOf(uiSource);
                if (position != currentIdx) {
                    children.remove(currentIdx);
                    if (position > children.size()) {
                        children.add(uiSource);
                    } else {
                        children.add(position, uiSource);
                    }
                }
            } else {
                boolean hadParent = uiSource.getParent() != null;
                children.add(position, uiSource);
                if (hadParent) {
                    this.tidyUp(pcontext, uiSource);
                }
                uiSource.setParent((UIComponent)uiTarget);
            }
        }
    }

    public static class DeleteComponentActionListener
    extends EventListener<UIComponent> {
        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        public void execute(Event<UIComponent> event) throws Exception {
            void var2_7;
            UIComponent uIComponent = (UIComponent)event.getSource();
            String id = uIComponent.getId();
            UIPortalApplication uiApp = Util.getUIPortalApplication();
            if (uIComponent.findFirstComponentOfType(UIPageBody.class) != null) {
                uiApp.addMessage(new ApplicationMessage("UIPortalApplication.msg.deletePageBody", new Object[0], 1));
                return;
            }
            UIContainer uiParent = (UIContainer)uIComponent.getParent();
            if (!UIPortalComponentActionListener.canMove(uIComponent, uiParent)) {
                return;
            }
            UIPortalComposer portalComposer = (UIPortalComposer)uiApp.findFirstComponentOfType(UIPortalComposer.class);
            portalComposer.setEditted(true);
            UIPage uiPage = (UIPage)uIComponent.getAncestorOfType(UIPage.class);
            if (uiPage != null && uiPage.getMaximizedUIPortlet() != null) {
                if (id.equals(uiPage.getMaximizedUIPortlet().getId())) {
                    uiPage.setMaximizedUIPortlet(null);
                }
            } else {
                UIPortal uiPortal = Util.getUIPortal();
                if (uiPortal != null && uiPortal.getMaximizedUIComponent() != null && id.equals(uiPortal.getMaximizedUIComponent().getId())) {
                    uiPortal.setMaximizedUIComponent(null);
                }
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            if ("TabContainer".equals(uiParent.getFactoryId())) {
                if (uiParent.getChildren().size() != 1) {
                    UIPortalComponentActionListener.removeUIComponent(uIComponent, pcontext, true);
                    return;
                }
                org.exoplatform.webui.core.UIContainer uiTabParent = (org.exoplatform.webui.core.UIContainer)uiParent.getParent();
                if (uiTabParent.getChildren().size() > 1) {
                    UIContainer uIContainer = uiParent;
                } else {
                    org.exoplatform.webui.core.UIContainer uIContainer = uiTabParent;
                }
            } else if ("TableColumnContainer".equals(uiParent.getFactoryId()) && uiParent.getChildren().size() == 1) {
                UIContainer uIContainer = uiParent;
            }
            UIPortalComponentActionListener.removeUIComponent((UIComponent)var2_7, pcontext, false);
        }
    }

    public static class ViewChildActionListener
    extends EventListener<org.exoplatform.webui.core.UIContainer> {
        public void execute(Event<org.exoplatform.webui.core.UIContainer> event) throws Exception {
            org.exoplatform.webui.core.UIContainer uiContainer = (org.exoplatform.webui.core.UIContainer)event.getSource();
            String id = event.getRequestContext().getRequestParameter("objectId");
            uiContainer.setRenderedChild(id);
        }
    }
}

