/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.task.integration.gamification;

import java.util.HashMap;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.task.dto.CommentDto;
import org.exoplatform.task.dto.TaskDto;
import org.exoplatform.task.service.TaskService;

public class GamificationTaskCommentListener
extends Listener<TaskService, CommentDto> {
    private static final String GAMIFICATION_TASK_ADDON_COMMENT_TASK = "commentTask";
    protected IdentityManager identityManager;
    protected ListenerService listenerService;

    public GamificationTaskCommentListener(IdentityManager identityManager, ListenerService listenerService) {
        this.identityManager = identityManager;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<TaskService, CommentDto> event) {
        String actorUsername = ConversationState.getCurrent().getIdentity().getUserId();
        TaskDto task = ((CommentDto)event.getData()).getTask();
        String actorId = this.identityManager.getOrCreateUserIdentity(actorUsername).getId();
        this.createGamificationRealization(actorId, actorId, GAMIFICATION_TASK_ADDON_COMMENT_TASK, String.valueOf(task.getId()));
    }

    private void createGamificationRealization(String earnerIdentityId, String receiverId, String gamificationEventName, String taskId) {
        HashMap<String, String> gam = new HashMap<String, String>();
        try {
            gam.put("eventId", gamificationEventName);
            gam.put("objectId", taskId);
            gam.put("objectType", "task");
            gam.put("senderId", earnerIdentityId);
            gam.put("receiverId", receiverId);
            this.listenerService.broadcast("exo.gamification.generic.action", gam, null);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error triggering Gamification Listener Event: " + gam, e);
        }
    }
}

