/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.settings.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.model.PluginInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.persistence.DataInitializer;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.job.NotificationJob;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

public class JPAUserSettingServiceImpl
extends AbstractService
implements UserSettingService {
    private static final Log LOG = ExoLogger.getLogger(JPAUserSettingServiceImpl.class);
    public static final Scope NOTIFICATION_SCOPE = Scope.APPLICATION.id("NOTIFICATION");
    public static final String NAME_PATTERN = "exo:{CHANNELID}Channel";
    private OrganizationService organizationService;
    private SettingService settingService;
    private ChannelManager channelManager;
    private PluginSettingService pluginSettingService;
    private UserSetting defaultSetting;
    private ListenerService listenerService;

    public JPAUserSettingServiceImpl(OrganizationService organizationService, SettingService settingService, ChannelManager channelManager, PluginSettingService pluginSettingService, DataInitializer dataInitializer, ListenerService listenerService) {
        this.organizationService = organizationService;
        this.settingService = settingService;
        this.channelManager = channelManager;
        this.pluginSettingService = pluginSettingService;
        this.listenerService = listenerService;
    }

    public void save(UserSetting model) {
        String userId = model.getUserId();
        String dailys = NotificationUtils.listToString(model.getDailyPlugins(), "{VALUE}");
        String weeklys = NotificationUtils.listToString(model.getWeeklyPlugins(), "{VALUE}");
        String channelActives = NotificationUtils.listToString(model.getChannelActives(), "{VALUE}");
        Set channels = model.getAllChannelPlugins().keySet();
        for (String channelId : channels) {
            this.saveUserSetting(userId, NOTIFICATION_SCOPE, this.getChannelProperty(channelId), NotificationUtils.listToString(model.getPlugins(channelId), "{VALUE}"));
        }
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:daily", dailys);
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:weekly", weeklys);
        this.saveUserSetting(userId, NOTIFICATION_SCOPE, "exo:isActive", channelActives);
        if (model.getLastReadDate() > 0L) {
            this.saveLastReadDate(userId, model.getLastReadDate());
        }
        this.saveUserSetting(userId, Scope.GLOBAL, "exo:isEnabled", "" + model.isEnabled());
        this.broadcastEvent("notifications.userSettingModified", model);
    }

    public void setUserEnabled(String username, boolean enabled) {
        this.saveUserSetting(username, Scope.GLOBAL, "exo:isEnabled", "" + enabled);
    }

    public UserSetting get(String userId) {
        UserSetting userSettings = this.getDefaultSettings();
        userSettings.setUserId(userId);
        userSettings.setEnabled(this.isUserEnabled(userId));
        Map userNotificationSettings = this.settingService.getSettingsByContext(Context.USER.id(userId));
        if (userNotificationSettings == null || userNotificationSettings.isEmpty()) {
            return userSettings;
        }
        List allChannels = this.channelManager.getChannels();
        Map channelPluginByName = allChannels.stream().collect(Collectors.toMap(channel -> this.getChannelProperty(channel.getId()), Function.identity()));
        if (userSettings.isEnabled() && userNotificationSettings.containsKey(Scope.GLOBAL) && ((Map)userNotificationSettings.get(Scope.GLOBAL)).containsKey("exo:isEnabled")) {
            SettingValue enabledSetting = (SettingValue)((Map)userNotificationSettings.get(Scope.GLOBAL)).get("exo:isEnabled");
            boolean isEnabled = enabledSetting != null && StringUtils.isNotBlank((String)((String)enabledSetting.getValue())) && Boolean.valueOf((String)enabledSetting.getValue()) != false;
            userSettings.setEnabled(isEnabled);
        }
        if (userNotificationSettings.containsKey(NOTIFICATION_SCOPE)) {
            Set channelActives = userSettings.getChannelActives();
            List dailyPlugins = userSettings.getDailyPlugins();
            List weeklyPlugins = userSettings.getWeeklyPlugins();
            Map notificationSettings = (Map)userNotificationSettings.get(NOTIFICATION_SCOPE);
            for (Map.Entry settingValue : notificationSettings.entrySet()) {
                String key = (String)settingValue.getKey();
                String value = (String)((SettingValue)settingValue.getValue()).getValue();
                if (value == null) continue;
                if ("exo:isActive".equals(key)) {
                    userSettings.setChannelActives(this.getSetFromValue(value, channelActives));
                    channelActives.forEach(channelId -> {
                        if (!userSettings.getChannelActives().contains(channelId) && this.getUserSetting(userId, NOTIFICATION_SCOPE, this.getChannelProperty((String)channelId)) == null) {
                            userSettings.getChannelActives().add(channelId);
                        }
                    });
                    continue;
                }
                if ("exo:lastReadDate".equals(key)) {
                    userSettings.setLastReadDate(Long.parseLong(value));
                    continue;
                }
                if ("exo:daily".equals(key)) {
                    userSettings.setDailyPlugins(this.getArrayListValue(value, dailyPlugins));
                    continue;
                }
                if ("exo:weekly".equals(key)) {
                    userSettings.setWeeklyPlugins(this.getArrayListValue(value, weeklyPlugins));
                    continue;
                }
                if (channelPluginByName.containsKey(key)) {
                    AbstractChannel channel2 = (AbstractChannel)channelPluginByName.get(key);
                    userSettings.setChannelPlugins(channel2.getId(), this.getArrayListValue(value, new ArrayList<String>()));
                    continue;
                }
                if (PropertyManager.isDevelopping()) {
                    LOG.warn("A setting was found for user {}, but not considered", new Object[]{userId});
                    continue;
                }
                LOG.debug("A setting was found for user {}, but not considered", new Object[]{userId});
            }
        }
        return userSettings;
    }

    public void initDefaultSettings(String userName) {
        try {
            this.fillDefaultSettingsOfUser(userName);
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to init default settings for user " + userName), (Throwable)e);
        }
    }

    public void initDefaultSettings(User[] users) {
        for (User user : users) {
            String userName = user.getUserName();
            try {
                this.fillDefaultSettingsOfUser(userName);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to init default settings for user " + userName), (Throwable)e);
            }
        }
    }

    public UserSetting getDefaultSettings() {
        if (this.defaultSetting == null || PropertyManager.isDevelopping()) {
            this.defaultSetting = UserSetting.getInstance();
            List<String> activeChannels = this.getDefaultSettingActiveChannels();
            if (CollectionUtils.isEmpty(activeChannels)) {
                for (AbstractChannel channel : this.channelManager.getChannels()) {
                    this.defaultSetting.setChannelActive(channel.getId());
                }
            } else {
                this.defaultSetting.getChannelActives().addAll(activeChannels);
            }
            List plugins = this.pluginSettingService.getAllPlugins();
            for (PluginInfo pluginInfo : plugins) {
                List pluginChannels = this.pluginSettingService.getPluginChannels(pluginInfo.getType());
                for (String defaultConf : pluginInfo.getDefaultConfig()) {
                    for (String channelId : pluginChannels) {
                        if (UserSetting.FREQUENCY.getFrequecy((String)defaultConf) == UserSetting.FREQUENCY.INSTANTLY) {
                            this.defaultSetting.addChannelPlugin(channelId, pluginInfo.getType());
                            continue;
                        }
                        this.defaultSetting.addPlugin(pluginInfo.getType(), UserSetting.FREQUENCY.getFrequecy((String)defaultConf));
                    }
                }
            }
        }
        return this.defaultSetting.clone();
    }

    public List<UserSetting> getDigestSettingForAllUser(NotificationContext notificationContext, int offset, int limit) {
        ArrayList<UserSetting> models = new ArrayList<UserSetting>();
        Boolean isWeekly = (Boolean)notificationContext.value(NotificationJob.JOB_WEEKLY);
        String frequency = "exo:daily";
        if (isWeekly != null && isWeekly.booleanValue()) {
            frequency = "exo:weekly";
        }
        try {
            boolean continueSearching = true;
            while (models.size() < limit && continueSearching) {
                List contexts = this.settingService.getContextsByTypeAndScopeAndSettingName(Context.USER.getName(), NOTIFICATION_SCOPE.getName(), NOTIFICATION_SCOPE.getId(), frequency, offset, limit);
                continueSearching = contexts.size() == limit;
                for (Context context : contexts) {
                    String username = context.getId();
                    UserSetting userSetting = this.get(username);
                    if (!userSetting.isEnabled()) continue;
                    models.add(userSetting);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get all " + frequency + " users have notification messages"), (Throwable)e);
        }
        return models;
    }

    public List<UserSetting> getDigestDefaultSettingForAllUser(int offset, int limit) {
        ArrayList<UserSetting> users = new ArrayList<UserSetting>();
        try {
            Set userNames = this.settingService.getEmptyContextsByTypeAndScopeAndSettingName(Context.USER.getName(), NOTIFICATION_SCOPE.getName(), NOTIFICATION_SCOPE.getId(), "exo:daily", offset, limit);
            for (String userName : userNames) {
                users.add(new UserSetting().setUserId(userName).setLastUpdateTime(Calendar.getInstance()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get default daily users have notification messages", (Throwable)e);
        }
        return users;
    }

    public void saveLastReadDate(String userId, Long time) {
        this.settingService.set(Context.USER.id(userId), NOTIFICATION_SCOPE, "exo:lastReadDate", SettingValue.create((Long)time));
    }

    public void clearDefaultSetting() {
        this.defaultSetting = null;
    }

    private String getChannelProperty(String channelId) {
        return NAME_PATTERN.replace("{CHANNELID}", channelId);
    }

    private SettingValue<?> getUserSetting(String userId, Scope scope, String key) {
        return this.settingService.get(Context.USER.id(userId), scope, key);
    }

    private void saveUserSetting(String userId, Scope scope, String key, String value) {
        this.settingService.set(Context.USER.id(userId), scope, key, SettingValue.create((String)value));
    }

    private List<String> getArrayListValue(String value, List<String> defaultValue) {
        if (StringUtils.isNotBlank((String)value) && !"false".equals(value)) {
            if ("true".equals(value)) {
                value = "MAIL_CHANNEL";
            }
            return NotificationUtils.stringToList(JPAUserSettingServiceImpl.getValues(value));
        }
        return defaultValue;
    }

    private Set<String> getSetFromValue(String value, Set<String> defaultValue) {
        if (StringUtils.isNotBlank((String)value) && !"false".equals(value)) {
            if ("true".equals(value)) {
                value = "MAIL_CHANNEL";
            }
            return NotificationUtils.stringToSet(JPAUserSettingServiceImpl.getValues(value));
        }
        return defaultValue;
    }

    private List<String> getDefaultSettingActiveChannels() {
        String activeChannels = System.getProperty("exo.notification.channels", "");
        return activeChannels.isEmpty() ? new ArrayList() : Arrays.asList(activeChannels.split(","));
    }

    private void fillDefaultSettingsOfUser(String username) {
        this.settingService.save(Context.USER.id(username));
    }

    private boolean isUserEnabled(String userId) {
        try {
            User user = this.organizationService.getUserHandler().findUserByName(userId);
            return user == null || user.isEnabled();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error getting user status from IDM store. Consider it as enabled.", (Throwable)e);
            return true;
        }
    }

    private void broadcastEvent(String eventName, UserSetting model) {
        try {
            this.listenerService.broadcast(eventName, (Object)model.getUserId(), (Object)model);
        }
        catch (Exception e) {
            LOG.warn("Error broadcasting modification on User Notification Settings '{}'", new Object[]{model, e});
        }
    }
}

