/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.dao;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.constant.EntityType;
import io.meeds.gamification.entity.RuleEntity;
import io.meeds.gamification.model.filter.RuleFilter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.persistence.GenericDAO;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;

public class RuleDAO
extends GenericDAOJPAImpl<RuleEntity, Long>
implements GenericDAO<RuleEntity, Long> {
    private static final String DATE_PARAM_NAME = "date";
    private static final String EVENT_PARAM_NAME = "event";
    private static final String QUERY_FILTER_FIND_PREFIX = "Rule.findAllRules";
    private static final String QUERY_FILTER_COUNT_PREFIX = "Rule.countAllRules";
    private static final String DOMAIN_ID_PARAM_NAME = "domainId";
    private Map<String, Boolean> filterNamedQueries = new HashMap<String, Boolean>();

    public List<Long> findHighestBudgetProgramIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getHighestBudgetDomainIds", Tuple.class);
        query.setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime());
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        Stream<Long> resultStream = result.stream().map(tuple -> (Long)tuple.get(0, Long.class));
        if (offset > 0) {
            resultStream = resultStream.skip(offset);
        }
        if (limit > 0) {
            resultStream = resultStream.limit(limit);
        }
        return resultStream.toList();
    }

    public List<Long> findHighestBudgetOpenProgramIds(int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getHighestBudgetOpenDomainIds", Tuple.class);
        query.setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime());
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        Stream<Long> resultStream = result.stream().map(tuple -> (Long)tuple.get(0, Long.class));
        if (offset > 0) {
            resultStream = resultStream.skip(offset);
        }
        if (limit > 0) {
            resultStream = resultStream.limit(limit);
        }
        return resultStream.toList();
    }

    public List<Long> findHighestBudgetProgramIdsBySpacesIds(List<Long> spacesIds, int offset, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getHighestBudgetDomainIdsBySpacesIds", Tuple.class);
        query.setParameter("spacesIds", spacesIds);
        query.setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime());
        List result = query.getResultList();
        if (result == null) {
            return Collections.emptyList();
        }
        Stream<Long> resultStream = result.stream().map(tuple -> (Long)tuple.get(0, Long.class));
        if (offset > 0) {
            resultStream = resultStream.skip(offset);
        }
        if (limit > 0) {
            resultStream = resultStream.limit(limit);
        }
        return resultStream.toList();
    }

    public RuleEntity findRuleByTitle(String ruleTitle) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findRuleByTitle", RuleEntity.class);
        query.setParameter("ruleTitle", (Object)ruleTitle);
        query.setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public RuleEntity findActiveRuleByEventAndProgramId(String event, long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.findActiveRuleByEventAndDomain", RuleEntity.class).setParameter(EVENT_PARAM_NAME, (Object)event).setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId).setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime()).setParameter("type", (Object)EntityType.AUTOMATIC);
        try {
            List ruleEntities = query.getResultList();
            return !ruleEntities.isEmpty() ? (RuleEntity)ruleEntities.get(0) : null;
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public long getRulesTotalScoreByProgramId(long domainId) throws PersistenceException {
        TypedQuery query = this.getEntityManager().createNamedQuery("Rule.getRulesTotalScoreByDomain", Long.class).setParameter(DOMAIN_ID_PARAM_NAME, (Object)domainId).setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime());
        Long score = (Long)query.getSingleResult();
        return score == null ? 0L : (long)score.intValue();
    }

    public List<Long> findRulesIdsByFilter(RuleFilter filter, int offset, int limit) {
        List result;
        TypedQuery<Tuple> query = this.buildQueryFromFilter(filter, Tuple.class, false);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        if (CollectionUtils.isEmpty((Collection)(result = query.getResultList()))) {
            return Collections.emptyList();
        }
        return result.stream().map(t -> (Long)t.get(0, Long.class)).toList();
    }

    public int countRulesByFilter(RuleFilter filter) {
        TypedQuery<Long> query = this.buildQueryFromFilter(filter, Long.class, true);
        return ((Long)query.getSingleResult()).intValue();
    }

    private <T> TypedQuery<T> buildQueryFromFilter(RuleFilter filter, Class<T> clazz, boolean count) {
        TypedQuery query;
        ArrayList<String> suffixes = new ArrayList<String>();
        ArrayList<String> predicates = new ArrayList<String>();
        this.buildPredicates(filter, suffixes, predicates);
        String queryName = this.getQueryFilterName(filter.getSortBy(), filter.isSortDescending(), suffixes, count);
        if (this.filterNamedQueries.containsKey(queryName)) {
            query = this.getEntityManager().createNamedQuery(queryName, clazz);
        } else {
            String queryContent = this.getQueryFilterContent(filter.getSortBy(), filter.isSortDescending(), predicates, count);
            query = this.getEntityManager().createQuery(queryContent, clazz);
            this.getEntityManager().getEntityManagerFactory().addNamedQuery(queryName, (Query)query);
            this.filterNamedQueries.put(queryName, true);
        }
        this.addQueryFilterParameters(filter, query);
        return query;
    }

    private <T> void addQueryFilterParameters(RuleFilter filter, TypedQuery<T> query) {
        EntityFilterType entityFilterType;
        DateFilterType dateFilterType;
        if (StringUtils.isNotBlank((String)filter.getTerm())) {
            query.setParameter("term", (Object)("%" + StringUtils.lowerCase((String)filter.getTerm()) + "%"));
        }
        if (StringUtils.isNotBlank((String)filter.getEventName())) {
            query.setParameter(EVENT_PARAM_NAME, (Object)filter.getEventName());
        }
        if (filter.getProgramId() > 0L) {
            query.setParameter(DOMAIN_ID_PARAM_NAME, (Object)filter.getProgramId());
        }
        if (CollectionUtils.isNotEmpty(filter.getSpaceIds())) {
            query.setParameter("ids", filter.getSpaceIds());
        }
        if (CollectionUtils.isNotEmpty(filter.getExcludedRuleIds())) {
            query.setParameter("excludedIds", filter.getExcludedRuleIds());
        }
        if (CollectionUtils.isNotEmpty(filter.getRuleIds())) {
            query.setParameter("ruleIds", filter.getRuleIds());
        }
        if ((dateFilterType = filter.getDateFilterType()) != null && dateFilterType != DateFilterType.ALL) {
            query.setParameter(DATE_PARAM_NAME, (Object)Calendar.getInstance().getTime());
        }
        if ((entityFilterType = filter.getType()) != null && entityFilterType != EntityFilterType.ALL) {
            query.setParameter("filterType", (Object)EntityType.valueOf(filter.getType().name()));
        }
    }

    private String getQueryFilterName(String sortField, boolean sortDescending, List<String> suffixes, boolean count) {
        Object queryName = suffixes.isEmpty() ? (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) : (count ? QUERY_FILTER_COUNT_PREFIX : QUERY_FILTER_FIND_PREFIX) + "By" + StringUtils.join(suffixes, (String)"And");
        if (StringUtils.isBlank((String)sortField)) {
            sortField = "Score";
        }
        queryName = (String)queryName + "OrderBy" + StringUtils.capitalize((String)sortField) + (sortDescending ? "Desc" : "Asc");
        return queryName;
    }

    private String getQueryFilterContent(String sortField, boolean sortDescending, List<String> predicates, boolean count) {
        String querySelect = count ? "SELECT COUNT(r) FROM Rule r " : "SELECT DISTINCT(r.id), " + this.getSortFieldName(sortField) + " FROM Rule r ";
        Object queryContent = predicates.isEmpty() ? querySelect : querySelect + " WHERE " + StringUtils.join(predicates, (String)" AND ");
        if (!count) {
            queryContent = (String)queryContent + " ORDER BY " + this.getSortFieldName(sortField) + (sortDescending ? " DESC " : " ASC ");
        }
        return queryContent;
    }

    private String getSortFieldName(String sortField) {
        if (StringUtils.isBlank((String)sortField)) {
            sortField = "Score";
        }
        return switch (sortField) {
            case "title" -> "r.title";
            case "id", "createdDate" -> "r.id";
            case "modifiedDate" -> "r.lastModifiedDate";
            case "startDate" -> "r.startDate";
            case "endDate" -> "r.endDate";
            case "type" -> "r.type";
            case "recurrence" -> "r.recurrence";
            default -> "r.score";
        };
    }

    private void buildPredicates(RuleFilter filter, List<String> suffixes, List<String> predicates) {
        suffixes.add("ExcludeDeleted");
        predicates.add("r.isDeleted = false");
        predicates.add("r.domainEntity.isDeleted = false");
        if (CollectionUtils.isNotEmpty(filter.getRuleIds())) {
            suffixes.add("RuleIds");
            predicates.add("r.id IN :ruleIds");
        }
        if (StringUtils.isNotBlank((String)filter.getTerm())) {
            suffixes.add("Term");
            predicates.add("LOWER(r.title) LIKE :term");
        }
        if (StringUtils.isNotBlank((String)filter.getEventName())) {
            suffixes.add("Event");
            predicates.add("r.event = :event");
        }
        if (filter.getProgramId() > 0L) {
            suffixes.add("Domain");
            predicates.add("r.domainEntity.id = :domainId");
        }
        if (CollectionUtils.isNotEmpty(filter.getSpaceIds())) {
            if (filter.isExcludeNoSpace()) {
                suffixes.add("StrictAudience");
                predicates.add("r.domainEntity.audienceId in (:ids)");
            } else {
                suffixes.add("Audience");
                predicates.add("(r.domainEntity.audienceId IS NULL OR r.domainEntity.audienceId in (:ids))");
            }
        } else if (!filter.isAllSpaces()) {
            suffixes.add("OpenAudience");
            predicates.add("r.domainEntity.audienceId IS NULL");
        }
        if (CollectionUtils.isNotEmpty(filter.getExcludedRuleIds())) {
            suffixes.add("ExcludeIds");
            predicates.add("r.id NOT IN :excludedIds");
        }
        DateFilterType dateFilterType = filter.getDateFilterType();
        EntityStatusType ruleStatus = filter.getStatus();
        EntityStatusType programStatus = filter.getProgramStatus();
        EntityFilterType ruleType = filter.getType();
        this.applyDateFilter(suffixes, predicates, dateFilterType);
        this.applyTypeFilter(suffixes, predicates, ruleType);
        this.applyStatusFilter(suffixes, predicates, ruleStatus, programStatus);
        if (StringUtils.isNotBlank((String)filter.getSortBy())) {
            suffixes.add("SortBy");
            suffixes.add(filter.getSortBy());
            if (filter.isSortDescending()) {
                suffixes.add("Descending");
            } else {
                suffixes.add("Ascending");
            }
        }
    }

    private void applyTypeFilter(List<String> suffixes, List<String> predicates, EntityFilterType entityFilterType) {
        if (entityFilterType != null && entityFilterType != EntityFilterType.ALL) {
            suffixes.add("Type");
            predicates.add("r.type = :filterType");
        }
    }

    private void applyDateFilter(List<String> suffixes, List<String> predicates, DateFilterType dateFilterType) {
        if (dateFilterType == null || dateFilterType == DateFilterType.ALL) {
            return;
        }
        switch (dateFilterType) {
            case ACTIVE: {
                suffixes.add("ActiveDate");
                predicates.add("(r.endDate IS NULL OR r.endDate > :date)");
                break;
            }
            case STARTED: {
                suffixes.add("StartDateAndEndDate");
                predicates.add("((r.startDate IS NULL OR r.startDate <= :date) AND (r.endDate IS NULL OR r.endDate > :date))");
                break;
            }
            case STARTED_WITH_END: {
                suffixes.add("StartDateAndEndDateNotNull");
                predicates.add("r.endDate IS NOT NULL");
                predicates.add("r.endDate > :date");
                predicates.add("(r.startDate IS NULL OR r.startDate <= :date)");
                break;
            }
            case UPCOMING: {
                suffixes.add("StartDate");
                predicates.add("r.startDate IS NOT NULL");
                predicates.add("r.startDate > :date");
                break;
            }
            case ENDED: {
                suffixes.add("EndDate");
                predicates.add("r.endDate <= :date");
                break;
            }
        }
    }

    private void applyStatusFilter(List<String> suffixes, List<String> predicates, EntityStatusType ruleStatus, EntityStatusType programStatus) {
        boolean enabledPrograms;
        boolean filterByProgramStatus = programStatus != null && programStatus != EntityStatusType.ALL;
        boolean filterByRuleStatus = ruleStatus != null && ruleStatus != EntityStatusType.ALL;
        boolean enabledRules = ruleStatus == EntityStatusType.ENABLED;
        boolean bl = enabledPrograms = programStatus == EntityStatusType.ENABLED;
        if (filterByRuleStatus && filterByProgramStatus && !enabledRules && !enabledPrograms) {
            suffixes.add("StatusDeactivated");
            predicates.add("(r.isEnabled = false OR r.domainEntity.isEnabled = false)");
        } else {
            if (filterByRuleStatus) {
                suffixes.add(enabledRules ? "StatusEnabled" : "StatusDisabled");
                predicates.add("r.isEnabled = " + enabledRules);
            }
            if (filterByProgramStatus) {
                suffixes.add(enabledPrograms ? "ProgramStatusEnabled" : "ProgramStatusDisabled");
                predicates.add("r.domainEntity.isEnabled = " + enabledPrograms);
            }
        }
    }
}

