/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.plugin.RuleConfigPlugin;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleRegistry;
import io.meeds.gamification.service.RuleService;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class RuleRegistryImpl
implements Startable,
RuleRegistry {
    private static final Log LOG = ExoLogger.getLogger(RuleRegistryImpl.class);
    public static final String GAMIFICATION_SETTINGS_RULE_KEY = "GAMIFICATION_SETTINGS_RULE_KEY";
    public static final String GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE = "GAMIFICATION_SETTINGS_RULE_PROCESSING_DONE";
    private final Map<String, RuleConfigPlugin> ruleMap;
    protected RuleService ruleService;
    protected ProgramService programService;

    public RuleRegistryImpl(ProgramService programService, RuleService ruleService) {
        this.programService = programService;
        this.ruleService = ruleService;
        this.ruleMap = new HashMap<String, RuleConfigPlugin>();
    }

    @Override
    public void addPlugin(RuleConfigPlugin ruleConfigPlugin) {
        if (StringUtils.isNotBlank((CharSequence)ruleConfigPlugin.getTitle())) {
            this.ruleMap.put(ruleConfigPlugin.getTitle(), ruleConfigPlugin);
        }
        this.registerAutomaticEvent(ruleConfigPlugin);
    }

    @Override
    public boolean remove(RuleConfigPlugin rule) {
        this.ruleMap.remove(rule.getTitle());
        return true;
    }

    public void start() {
        try {
            for (RuleConfigPlugin ruleConfigPlugin : this.ruleMap.values()) {
                RuleDTO ruleDTO = this.ruleService.findRuleByTitle("def_" + ruleConfigPlugin.getTitle());
                if (!ruleConfigPlugin.isEnable() || ruleDTO != null && ruleDTO.getEvent().equals(ruleConfigPlugin.getEvent()) && ruleDTO.getTitle().equals("def_" + ruleConfigPlugin.getTitle())) continue;
                this.store(ruleConfigPlugin, ruleDTO);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when processing Rules ", (Throwable)e);
        }
    }

    public void stop() {
    }

    private RuleDTO store(RuleConfigPlugin ruleConfig, RuleDTO ruleDTO) {
        try {
            if (ruleDTO != null) {
                ruleDTO.setTitle("def_" + ruleConfig.getTitle());
                ruleDTO.setDescription(ruleConfig.getDescription());
                ruleDTO.setEvent(ruleConfig.getEvent());
                if (!ruleDTO.isDeleted()) {
                    ruleDTO = this.ruleService.updateRule(ruleDTO);
                }
            } else {
                ruleDTO = new RuleDTO();
                ruleDTO.setTitle("def_" + ruleConfig.getTitle());
                ruleDTO.setScore(ruleConfig.getScore());
                ruleDTO.setEnabled(ruleConfig.isEnable());
                ruleDTO.setEvent(ruleConfig.getEvent());
                ruleDTO.setDeleted(false);
                ruleDTO.setDescription(ruleConfig.getDescription());
                ruleDTO = this.ruleService.createRule(ruleDTO);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error when saving Rule ", (Throwable)e);
        }
        return ruleDTO;
    }

    private void registerAutomaticEvent(RuleConfigPlugin ruleConfigPlugin) {
        if (StringUtils.isNotBlank((CharSequence)ruleConfigPlugin.getEvent())) {
            this.ruleService.addAutomaticEvent(ruleConfigPlugin.getEvent());
        } else if (StringUtils.isNotBlank((CharSequence)ruleConfigPlugin.getTitle())) {
            this.ruleService.addAutomaticEvent(ruleConfigPlugin.getTitle());
        }
    }
}

