/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.service.impl;

import io.meeds.gamification.constant.DateFilterType;
import io.meeds.gamification.constant.EntityStatusType;
import io.meeds.gamification.model.ProgramDTO;
import io.meeds.gamification.model.RuleDTO;
import io.meeds.gamification.model.RulePublication;
import io.meeds.gamification.model.filter.RuleFilter;
import io.meeds.gamification.search.RuleSearchConnector;
import io.meeds.gamification.service.ProgramService;
import io.meeds.gamification.service.RuleService;
import io.meeds.gamification.storage.RuleStorage;
import io.meeds.gamification.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.activity.model.ExoSocialActivityImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class RuleServiceImpl
implements RuleService {
    private static final Log LOG = ExoLogger.getLogger(RuleServiceImpl.class);
    private static final int MAX_RULES_TO_SEARCH = 100;
    private static final String USERNAME_IS_MANDATORY_MESSAGE = "Username is mandatory";
    private final ProgramService programService;
    private final RuleStorage ruleStorage;
    private final RuleSearchConnector ruleSearchConnector;
    private final SpaceService spaceService;
    private final ActivityManager activityManager;
    private final IdentityManager identityManager;
    private final ListenerService listenerService;
    private final List<String> automaticEventNames = new ArrayList<String>();

    public RuleServiceImpl(ProgramService programService, RuleStorage ruleStorage, RuleSearchConnector ruleSearchConnector, SpaceService spaceService, ActivityManager activityManager, IdentityManager identityManager, ListenerService listenerService) {
        this.programService = programService;
        this.listenerService = listenerService;
        this.spaceService = spaceService;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.ruleStorage = ruleStorage;
        this.ruleSearchConnector = ruleSearchConnector;
    }

    @Override
    public RuleDTO findRuleById(long id) throws IllegalArgumentException {
        if (id == 0L) {
            throw new IllegalArgumentException("Rule id is mandatory");
        }
        RuleDTO rule = this.ruleStorage.findRuleById(id);
        if (rule != null && rule.getProgram() != null) {
            rule.setProgram(this.programService.getProgramById(rule.getProgram().getId()));
        }
        return rule;
    }

    @Override
    public RuleDTO findRuleById(long ruleId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (ruleId <= 0L) {
            throw new IllegalArgumentException("ruleId is mandatory");
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new IllegalAccessException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        RuleDTO rule = this.findRuleById(ruleId);
        if (rule == null) {
            throw new ObjectNotFoundException("Rule doesn't exist");
        }
        if (rule.isDeleted()) {
            throw new ObjectNotFoundException("Rule has been deleted");
        }
        if (!(this.isRuleManager(rule, username) || rule.isEnabled() && rule.getProgram() != null && this.programService.isProgramMember(rule.getProgram().getId(), username))) {
            throw new IllegalAccessException("Rule isn't accessible");
        }
        if (rule.getProgram() != null) {
            this.computeActivity(rule, 0L, null, false, null, null, true);
        }
        return rule;
    }

    @Override
    public RuleDTO findRuleByTitle(String ruleTitle) throws IllegalArgumentException {
        if (StringUtils.isBlank((CharSequence)ruleTitle)) {
            throw new IllegalArgumentException("rule title is mandatory");
        }
        RuleDTO rule = this.ruleStorage.findRuleByTitle(ruleTitle);
        if (rule != null && rule.getProgram() != null) {
            rule.setProgram(this.programService.getProgramById(rule.getProgram().getId()));
        }
        return rule;
    }

    @Override
    public List<RuleDTO> getRules(RuleFilter ruleFilter, String username, int offset, int limit) {
        ruleFilter = this.computeUserSpaces(ruleFilter, username);
        return this.getRules(ruleFilter, offset, limit);
    }

    @Override
    public List<RuleDTO> getRules(RuleFilter ruleFilter, int offset, int limit) {
        List<Long> ruleIds;
        if (this.isSearchFilter(ruleFilter)) {
            int searchLimit = offset + limit * 2;
            ruleIds = this.ruleSearchConnector.search(ruleFilter, 0L, searchLimit);
            if (CollectionUtils.isEmpty(ruleIds)) {
                return Collections.emptyList();
            }
            ruleFilter.setTerm(null);
            ruleFilter.setRuleIds(ruleIds);
            ruleIds = this.ruleStorage.findRuleIdsByFilter(ruleFilter, offset, limit);
        } else {
            ruleIds = this.ruleStorage.findRuleIdsByFilter(ruleFilter, offset, limit);
        }
        return ruleIds.stream().map(id -> {
            RuleDTO rule = this.findRuleById((long)id);
            if (rule != null && rule.getProgram() != null) {
                this.computeActivity(rule, 0L, null, false, null, null, true);
            }
            return rule;
        }).toList();
    }

    @Override
    public int countRules(RuleFilter ruleFilter, String username) {
        ruleFilter = this.computeUserSpaces(ruleFilter, username);
        return this.countRules(ruleFilter);
    }

    @Override
    public int countRules(RuleFilter ruleFilter) {
        if (this.isSearchFilter(ruleFilter)) {
            List<Long> ruleIds = this.ruleSearchConnector.search(ruleFilter, 0L, 100L);
            if (CollectionUtils.isEmpty(ruleIds)) {
                return 0;
            }
            ruleFilter.setTerm(null);
            ruleFilter.setRuleIds(ruleIds);
            return this.ruleStorage.countRulesByFilter(ruleFilter);
        }
        return this.ruleStorage.countRulesByFilter(ruleFilter);
    }

    @Override
    public int countActiveRules(long programId) {
        RuleFilter ruleFilter = new RuleFilter(true);
        ruleFilter.setStatus(EntityStatusType.ENABLED);
        ruleFilter.setProgramStatus(EntityStatusType.ALL);
        ruleFilter.setProgramId(programId);
        ruleFilter.setDateFilterType(DateFilterType.ACTIVE);
        return this.countRules(ruleFilter);
    }

    @Override
    public List<String> getAllEvents() {
        return Collections.unmodifiableList(this.automaticEventNames);
    }

    @Override
    public void addAutomaticEvent(String eventName) {
        if (!this.automaticEventNames.contains(eventName)) {
            this.automaticEventNames.add(eventName);
        }
    }

    @Override
    public RuleDTO deleteRuleById(long ruleId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (ruleId <= 0L) {
            throw new IllegalArgumentException("ruleId must be positive");
        }
        RuleDTO rule = this.ruleStorage.findRuleById(ruleId);
        if (rule == null) {
            throw new ObjectNotFoundException("Rule with id " + ruleId + " is not found");
        }
        if (!this.isRuleManager(rule, username)) {
            throw new IllegalAccessException("The user is not authorized to delete a rule");
        }
        return this.deleteRule(ruleId, username);
    }

    @Override
    public RuleDTO deleteRuleById(long ruleId) {
        try {
            return this.deleteRule(ruleId, null);
        }
        catch (ObjectNotFoundException e) {
            LOG.debug("Rule with id {} not found. Continue processing without interrupting current operation.", new Object[]{ruleId, e});
            return null;
        }
    }

    @Override
    public RuleDTO createRule(RuleDTO rule, String username) throws IllegalAccessException, ObjectAlreadyExistsException, ObjectNotFoundException {
        if (rule == null) {
            throw new IllegalArgumentException("rule object is mandatory");
        }
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (rule.getId() != null) {
            throw new IllegalArgumentException("program id must be equal to 0");
        }
        long programId = rule.getProgram().getId();
        ProgramDTO program = this.programService.getProgramById(programId, username);
        rule.setProgram(program);
        this.checkPermissionAndDates(rule, username);
        rule.setCreatedBy(username);
        rule.setLastModifiedBy(username);
        rule.setDeleted(false);
        rule.setActivityId(0L);
        RuleDTO similarRule = this.ruleStorage.findActiveRuleByEventAndProgramId(rule.getEvent(), programId);
        if (similarRule != null && !similarRule.isDeleted()) {
            throw new ObjectAlreadyExistsException((Object)"Rule with same event and program already exist");
        }
        return this.createRuleAndBroadcast(rule, username);
    }

    @Override
    public RuleDTO createRule(RuleDTO rule) {
        rule.setLastModifiedBy("SYSTEM");
        rule.setCreatedBy("SYSTEM");
        rule.setActivityId(0L);
        return this.createRuleAndBroadcast(rule, null);
    }

    @Override
    public RuleDTO updateRule(RuleDTO rule, String username) throws ObjectNotFoundException, IllegalAccessException {
        if (username == null) {
            throw new IllegalArgumentException(USERNAME_IS_MANDATORY_MESSAGE);
        }
        if (rule.getId() == null || rule.getId() == 0L) {
            throw new ObjectNotFoundException("Rule with id 0 doesn't exist");
        }
        RuleDTO storedRule = this.ruleStorage.findRuleById(rule.getId());
        if (storedRule == null) {
            throw new ObjectNotFoundException("Rule doesn't exist");
        }
        if (storedRule.isDeleted()) {
            throw new ObjectNotFoundException("Rule with id '" + storedRule.getId() + "' was deleted");
        }
        if (rule.getProgram() == null) {
            throw new IllegalArgumentException("Program is mandatory");
        }
        ProgramDTO program = this.programService.getProgramById(rule.getProgram().getId());
        rule.setProgram(program);
        if (rule.getProgram() == null) {
            throw new IllegalArgumentException("Program with id " + rule.getProgram().getId() + " wasn't found");
        }
        if (!this.isRuleManager(storedRule, username)) {
            throw new IllegalAccessException("The user is not authorized to update a rule");
        }
        this.checkPermissionAndDates(storedRule, username);
        this.checkPermissionAndDates(rule, username);
        rule.setCreatedDate(storedRule.getCreatedDate());
        rule.setCreatedBy(storedRule.getCreatedBy());
        rule.setActivityId(storedRule.getActivityId());
        return this.updateRuleAndBroadcast(rule, username);
    }

    @Override
    public RuleDTO updateRule(RuleDTO ruleDTO) throws ObjectNotFoundException {
        return this.updateRuleAndBroadcast(ruleDTO, null);
    }

    @Override
    public List<RuleDTO> getPrerequisiteRules(long ruleId) {
        RuleDTO rule = this.ruleStorage.findRuleById(ruleId);
        if (rule != null && CollectionUtils.isNotEmpty(rule.getPrerequisiteRuleIds())) {
            return rule.getPrerequisiteRuleIds().stream().map(id -> {
                RuleDTO r = this.findRuleById((long)id);
                if (r == null || r.getProgram() == null || !r.isEnabled() || r.isDeleted()) {
                    return null;
                }
                return r;
            }).filter(Objects::nonNull).toList();
        }
        return Collections.emptyList();
    }

    private boolean isSearchFilter(RuleFilter ruleFilter) {
        return ruleFilter.isFavorites() || CollectionUtils.isNotEmpty(ruleFilter.getTagNames()) || StringUtils.isNotBlank((CharSequence)ruleFilter.getTerm()) && ruleFilter.getLocale() != null;
    }

    private RuleFilter computeUserSpaces(RuleFilter ruleFilter, String username) {
        ruleFilter = ruleFilter.clone();
        if (Utils.isRewardingManager(username)) {
            ruleFilter.setAllSpaces(CollectionUtils.isEmpty(ruleFilter.getSpaceIds()));
            return ruleFilter;
        }
        List memberSpacesIds = this.spaceService.getMemberSpacesIds(username, 0, -1).stream().map(Long::parseLong).toList();
        if (CollectionUtils.isNotEmpty(ruleFilter.getSpaceIds())) {
            memberSpacesIds = (List)CollectionUtils.intersection(memberSpacesIds, ruleFilter.getSpaceIds());
        }
        ruleFilter.setSpaceIds(memberSpacesIds);
        return ruleFilter;
    }

    private void checkPermissionAndDates(RuleDTO rule, String username) throws IllegalAccessException {
        if (!this.isRuleManager(rule, username)) {
            if (rule.getId() != null && rule.getId() > 0L) {
                throw new IllegalAccessException("User " + username + " is not allowed to update the rule with id " + rule.getId());
            }
            throw new IllegalAccessException("User " + username + " is not allowed to create a rule that it can't manage");
        }
        Date startDate = Utils.parseSimpleDate(rule.getStartDate());
        Date endDate = Utils.parseSimpleDate(rule.getEndDate());
        if (startDate != null && endDate != null && endDate.compareTo(startDate) <= 0) {
            throw new IllegalStateException("endDate must be greater than startDate");
        }
    }

    private RuleDTO updateRuleAndBroadcast(RuleDTO rule, String username) throws ObjectNotFoundException {
        if (rule.getId() == null || rule.getId() == 0L || this.ruleStorage.findRuleById(rule.getId()) == null) {
            throw new ObjectNotFoundException("Rule id is mandatory");
        }
        ProgramDTO program = rule.getProgram();
        if (program != null) {
            long programId = rule.getProgram().getId();
            RuleDTO similarRule = this.ruleStorage.findActiveRuleByEventAndProgramId(rule.getEvent(), programId);
            if (similarRule != null && !similarRule.getId().equals(rule.getId()) && !similarRule.isDeleted()) {
                throw new IllegalStateException("Rule with same event and program already exist");
            }
        }
        rule.setLastModifiedBy(username);
        rule.setLastModifiedDate(Utils.toRFC3339Date(new Date()));
        if (rule instanceof RulePublication) {
            RulePublication rulePublication = (RulePublication)rule;
            this.computeActivity(rule, rulePublication.getSpaceId(), username, rulePublication.isPublish(), rulePublication.getMessage(), rulePublication.getTemplateParams(), false);
        }
        rule = this.ruleStorage.saveRule(rule);
        Utils.broadcastEvent(this.listenerService, "rule.updated", rule.getId(), username);
        return rule;
    }

    private RuleDTO createRuleAndBroadcast(RuleDTO rule, String username) {
        RuleDTO savedRule = this.ruleStorage.saveRule(rule);
        if (rule instanceof RulePublication) {
            RulePublication rulePublication = (RulePublication)rule;
            savedRule = this.computeActivity(savedRule, rulePublication.getSpaceId(), username, rulePublication.isPublish(), rulePublication.getMessage(), rulePublication.getTemplateParams(), true);
        }
        if (savedRule != null) {
            Utils.broadcastEvent(this.listenerService, "rule.created", savedRule.getId(), username);
        }
        return savedRule;
    }

    private boolean isRuleManager(RuleDTO rule, String username) {
        ProgramDTO program = rule.getProgram();
        if (program == null) {
            return false;
        }
        return this.programService.isProgramOwner(program.getId(), username);
    }

    private RuleDTO deleteRule(Long ruleId, String username) throws ObjectNotFoundException {
        RuleDTO rule = this.ruleStorage.deleteRuleById(ruleId, username);
        Utils.broadcastEvent(this.listenerService, "rule.deleted", rule, username);
        return rule;
    }

    private RuleDTO computeActivity(RuleDTO rule, long spaceId, String username, boolean publish, String message, Map<String, String> templateParams, boolean saveRule) {
        if (rule == null || !rule.isEnabled() || rule.isDeleted() || rule.getProgram() == null || !rule.getProgram().isEnabled() || rule.getProgram().isDeleted()) {
            return rule;
        }
        ExoSocialActivity activity = this.getExistingActivity(rule);
        if (activity == null || spaceId > 0L && this.getSpaceId(activity) != spaceId) {
            Space space;
            Identity publisherIdentity;
            if (spaceId == 0L) {
                spaceId = rule.getSpaceId();
            }
            if ((publisherIdentity = this.getActivityPublisherIdentity(rule, space = spaceId > 0L ? this.spaceService.getSpaceById(String.valueOf(spaceId)) : null, username)) == null) {
                LOG.warn("Unable to generate and activity with a null publisher for a rule and/or program creator and/or modifier. Rule id : {}", new Object[]{rule.getId()});
                return rule;
            }
            activity = new ExoSocialActivityImpl();
            this.setActivityParams(activity, rule, publisherIdentity, message, templateParams, publish);
            this.createActivity(activity, space, publisherIdentity);
            rule.setActivityId(Long.parseLong(activity.getId()));
            if (saveRule) {
                rule = this.ruleStorage.saveRule(rule);
            }
            if (!activity.isHidden()) {
                Utils.broadcastEvent(this.listenerService, "rule.published", rule, username);
            }
        } else if (publish) {
            Identity publisherIdentity = this.getActivityPublisherIdentity(rule, null, username);
            if (publisherIdentity == null) {
                LOG.warn("Unable to generate and activity with a null publisher for a rule and/or program creator and/or modifier. Rule id : {}", new Object[]{rule.getId()});
                return rule;
            }
            boolean newlyPublished = activity.isHidden();
            this.setActivityParams(activity, rule, publisherIdentity, message, templateParams, publish);
            this.activityManager.updateActivity(activity);
            if (newlyPublished) {
                Utils.broadcastEvent(this.listenerService, "rule.published", rule, username);
            }
        }
        return rule;
    }

    private void createActivity(ExoSocialActivity activity, Space space, Identity publisherIdentity) {
        Identity streamOwner = space == null ? publisherIdentity : this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName());
        this.activityManager.saveActivityNoReturn(streamOwner, activity);
    }

    private void setActivityParams(ExoSocialActivity activity, RuleDTO rule, Identity publisherIdentity, String message, Map<String, String> templateParams, boolean publish) {
        activity.setUserId(publisherIdentity.getId());
        activity.setPosterId(publisherIdentity.getId());
        activity.setTitle(!publish || StringUtils.isBlank((CharSequence)message) ? "" : message);
        activity.setBody(!publish || StringUtils.isBlank((CharSequence)message) ? "" : message);
        activity.setType("gamificationRuleActivity");
        this.buildActivityParams(activity, templateParams);
        activity.setMetadataObjectType("rule");
        activity.setMetadataObjectId(String.valueOf(rule.getId()));
        activity.getTemplateParams().put("ruleId", String.valueOf(rule.getId()));
        activity.getTemplateParams().put("ruleTitle", rule.getTitle());
        activity.getTemplateParams().put("ruleTitle", rule.getDescription());
        activity.getTemplateParams().put("ruleScore", String.valueOf(rule.getScore()));
        activity.isHidden(!publish);
    }

    private Identity getActivityPublisherIdentity(RuleDTO rule, Space space, String username) {
        Iterator<String> potentialPublishers = Arrays.asList(username, rule.getCreatedBy(), rule.getLastModifiedBy(), rule.getProgram().getCreatedBy(), rule.getProgram().getLastModifiedBy()).iterator();
        Identity publisherIdentity = null;
        while (potentialPublishers.hasNext() && publisherIdentity == null) {
            Identity identity;
            String publisher = potentialPublishers.next();
            if (!this.isValidUsername(publisher) || (identity = this.getUserIdentity(publisher)) == null || !identity.isEnable() || identity.isDeleted() || space != null && !this.spaceService.isMember(space, identity.getRemoteId()) && !Utils.isRewardingManager(identity.getRemoteId())) continue;
            publisherIdentity = identity;
        }
        return publisherIdentity;
    }

    private ExoSocialActivity getExistingActivity(RuleDTO rule) {
        long activityId = rule.getActivityId();
        if (activityId != 0L) {
            return this.activityManager.getActivity(String.valueOf(activityId));
        }
        return null;
    }

    private long getSpaceId(ExoSocialActivity activity) {
        Space space;
        if (activity.getActivityStream().isSpace() && (space = this.spaceService.getSpaceByPrettyName(activity.getActivityStream().getPrettyId())) != null) {
            return Long.parseLong(space.getId());
        }
        return 0L;
    }

    private boolean isValidUsername(String username) {
        return StringUtils.isNotBlank((CharSequence)username) && !StringUtils.equals((CharSequence)"SYSTEM", (CharSequence)username);
    }

    private Identity getUserIdentity(String identityId) {
        Identity identity = this.identityManager.getOrCreateUserIdentity(identityId);
        if (identity == null && NumberUtils.isDigits((String)identityId)) {
            identity = this.identityManager.getIdentity(identityId);
        }
        return identity;
    }

    private void buildActivityParams(ExoSocialActivity activity, Map<String, String> templateParams) {
        HashMap<String, String> currentTemplateParams;
        HashMap<String, String> hashMap = currentTemplateParams = activity.getTemplateParams() == null ? new HashMap<String, String>() : new HashMap(activity.getTemplateParams());
        if (templateParams != null) {
            currentTemplateParams.putAll(templateParams);
        }
        for (Map.Entry entry : currentTemplateParams.entrySet()) {
            if (entry == null || !StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) && !StringUtils.equals((CharSequence)((CharSequence)entry.getValue()), (CharSequence)"-")) continue;
            entry.setValue("");
        }
        activity.setTemplateParams(currentTemplateParams);
    }
}

