/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.idm.impl.store.attribute;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.picketlink.idm.api.Attribute;
import org.picketlink.idm.api.CredentialEncoder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.api.PasswordCredential;
import org.picketlink.idm.impl.api.session.IdentitySessionImpl;
import org.picketlink.idm.impl.api.session.managers.AttributesManagerImpl;
import org.picketlink.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.picketlink.idm.spi.model.IdentityObjectCredential;

public class ExtendedAttributeManager
extends AttributesManagerImpl {
    private static final Log LOG = ExoLogger.getExoLogger(ExtendedAttributeManager.class);
    public static final String OLD_PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt";
    public static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt128";
    private static final String DEFAULT_ENCODER = "org.exoplatform.web.security.hash.Argon2IdPasswordEncoder";
    private static final String OLD_ENCODER_CLASS_PROPERTY = "oldCredentialEncoder.class";
    private static PicketLinkIDMService idmService;

    public ExtendedAttributeManager(IdentitySessionImpl session) {
        super(session);
    }

    public boolean validatePassword(User user, String password) throws IdentityException {
        Attribute salt = this.getAttribute(user.getKey(), PASSWORD_SALT_USER_ATTRIBUTE);
        if (!this.getCredentialEncoder().getClass().getName().equals(DEFAULT_ENCODER)) {
            return super.validatePassword(user, password);
        }
        if (salt != null) {
            if (super.validatePassword(user, password)) {
                return true;
            }
            return this.validateAndUpdateHash(this.getCredentialEncoder(), user, (String)new PasswordCredential(password, this.getOldCredentialEncoder(), user.getKey()).getEncodedValue(), password);
        }
        return this.validateAndUpdateHash(this.getOldCredentialEncoder(), user, password, password);
    }

    private boolean validateAndUpdateHash(CredentialEncoder credentialEncoder, User user, String password, String newPassword) throws IdentityException {
        if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(user), (IdentityObjectCredential)new PasswordCredential(password, credentialEncoder, user.getKey()))) {
            this.removeAttributes(user.getKey(), new String[]{OLD_PASSWORD_SALT_USER_ATTRIBUTE});
            this.updatePassword(user, newPassword);
            return true;
        }
        return false;
    }

    private CredentialEncoder getOldCredentialEncoder() {
        try {
            Class<?> credentialClass = Class.forName(this.getCredentialEncoderProps().get(OLD_ENCODER_CLASS_PROPERTY));
            CredentialEncoder oldCredentialEncoder = (CredentialEncoder)credentialClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            oldCredentialEncoder.setIdentitySession(this.getIdentitySession());
            oldCredentialEncoder.initialize(this.getCredentialEncoderProps(), ExtendedAttributeManager.getIdmService().getIdentityConfiguration().getIdentityConfigurationRegistry());
            return oldCredentialEncoder;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while initializing old credential encoder", (Throwable)e);
            throw new RuntimeException();
        }
    }

    private Map<String, String> getCredentialEncoderProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        ((RealmConfigurationMetaData)ExtendedAttributeManager.getIdmService().getConfigMD().getRealms().get(0)).getOptions().forEach((k, v) -> props.put((String)k, (String)v.get(0)));
        return props;
    }

    private static PicketLinkIDMService getIdmService() {
        if (idmService == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            idmService = (PicketLinkIDMService)container.getComponentInstanceOfType(PicketLinkIDMService.class);
        }
        return idmService;
    }

    public CredentialEncoder getDefaultCredentialEncoder() {
        return this.getCredentialEncoder();
    }
}

