/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jgroups.Address;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.util.AsciiString;

public class SingletonAddress
implements Address {
    private static final long serialVersionUID = 4251279268511779867L;
    protected final byte[] cluster_name;
    protected final Address addr;

    public SingletonAddress(byte[] cluster_name, Address addr) {
        this.cluster_name = cluster_name;
        this.addr = addr;
        if (cluster_name == null) {
            throw new NullPointerException("cluster_name must not be null");
        }
    }

    public SingletonAddress() {
        this.cluster_name = null;
        this.addr = null;
    }

    public Address getAddress() {
        return this.addr;
    }

    public byte[] getClusterName() {
        return this.cluster_name;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(DataOutput out) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFrom(DataInput in) throws Exception {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int retval = this.hash();
        if (this.addr != null) {
            retval += this.addr.hashCode();
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Address)) {
            throw new IllegalArgumentException("argument is " + obj.getClass());
        }
        return this.compareTo((Address)obj) == 0;
    }

    @Override
    public int compareTo(Address o) {
        SingletonAddress other = (SingletonAddress)o;
        if (this == other) {
            return 0;
        }
        if (other == null) {
            return 1;
        }
        int rc = SingletonAddress.compareTo(this.cluster_name, other.cluster_name);
        if (rc != 0) {
            return rc;
        }
        if (this.addr == null && other.addr == null) {
            return 0;
        }
        if (this.addr == null && other.addr != null) {
            return -1;
        }
        if (this.addr != null && other.addr == null) {
            return 1;
        }
        if (this.addr instanceof SiteUUID && !(other.addr instanceof SiteUUID)) {
            return 1;
        }
        if (!(this.addr instanceof SiteUUID) && other.addr instanceof SiteUUID) {
            return -1;
        }
        assert (this.addr != null);
        return this.addr.compareTo(other.addr);
    }

    public String toString() {
        return new AsciiString(this.cluster_name) + (this.addr != null ? ":" + this.addr.toString() : "");
    }

    protected int hash() {
        int h = 0;
        for (int i = 0; i < this.cluster_name.length; ++i) {
            h = 31 * h + this.cluster_name[i];
        }
        return h;
    }

    protected static int compareTo(byte[] v1, byte[] v2) {
        if (v2 == null) {
            return 1;
        }
        if (v1.hashCode() == v2.hashCode()) {
            return 0;
        }
        int len1 = v1.length;
        int len2 = v2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            byte c1 = v1[k];
            byte c2 = v2[k];
            if (c1 == c2) continue;
            return c1 > c2 ? 1 : -1;
        }
        return len1 > len2 ? 1 : (len1 < len2 ? -1 : 0);
    }
}

