/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.storage;

import java.util.Date;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.gamification.github.dao.WebHookDAO;
import org.exoplatform.gamification.github.entity.WebhookEntity;
import org.exoplatform.gamification.github.model.WebHook;
import org.exoplatform.gamification.github.storage.mapper.WebHookMapper;

public class WebHookStorage {
    private final WebHookDAO webHookDAO;

    public WebHookStorage(WebHookDAO gitHubHookDAO) {
        this.webHookDAO = gitHubHookDAO;
    }

    public WebHook saveWebHook(WebHook webHook) throws ObjectAlreadyExistsException {
        WebHook existsWebHook = this.getWebhookByOrganizationId(webHook.getOrganizationId());
        if (existsWebHook == null) {
            WebhookEntity webhookEntity = WebHookMapper.toEntity(webHook);
            webhookEntity.setWatchedDate(new Date());
            webhookEntity.setUpdatedDate(new Date());
            webhookEntity.setRefreshDate(new Date());
            webhookEntity.setEnabled(true);
            webhookEntity = (WebhookEntity)this.webHookDAO.create(webhookEntity);
            return WebHookMapper.fromEntity(webhookEntity);
        }
        throw new ObjectAlreadyExistsException((Object)existsWebHook);
    }

    public WebHook updateWebHook(WebHook webHook, boolean forceUpdate) {
        WebhookEntity webhookEntity = (WebhookEntity)this.webHookDAO.find(Long.valueOf(webHook.getId()));
        if (forceUpdate) {
            webhookEntity.setRefreshDate(new Date());
            webhookEntity.setTriggers(webHook.getTriggers());
        }
        webhookEntity.setUpdatedDate(new Date());
        return WebHookMapper.fromEntity((WebhookEntity)this.webHookDAO.update(webhookEntity));
    }

    public WebHook updateWebHookAccessToken(long webhookId, String accessToken) {
        WebhookEntity webhookEntity = (WebhookEntity)this.webHookDAO.find(Long.valueOf(webhookId));
        webhookEntity.setToken(accessToken);
        return WebHookMapper.fromEntity((WebhookEntity)this.webHookDAO.update(webhookEntity));
    }

    public WebHook getWebHookById(Long id) {
        return WebHookMapper.fromEntity((WebhookEntity)this.webHookDAO.find(id));
    }

    public List<Long> getWebhookIds(int offset, int limit) {
        return this.webHookDAO.getWebhookIds(offset, limit);
    }

    public int countWebhooks() {
        return this.webHookDAO.count().intValue();
    }

    public WebHook getWebhookByOrganizationId(long organizationId) {
        WebhookEntity connectorHookEntity = this.webHookDAO.getWebhookByOrganizationId(organizationId);
        return WebHookMapper.fromEntity(connectorHookEntity);
    }

    public WebHook deleteWebHook(long organizationId) {
        WebhookEntity webhookEntity = this.webHookDAO.getWebhookByOrganizationId(organizationId);
        if (webhookEntity != null) {
            this.webHookDAO.delete(webhookEntity);
        }
        return WebHookMapper.fromEntity(webhookEntity);
    }
}

