/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.organization.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.search.UserSearchService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/organization/account/UIUserSelector.gtmpl", events={@EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
@Serialized
public class UIUserSelector
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "Quick Search";
    protected Map<String, User> userData_ = new HashMap<String, User>();
    private boolean isShowSearch_ = false;
    private boolean isShowSearchUser = true;
    private UIPageIterator uiIterator_;
    private String selectedUsers;
    private boolean multi = true;

    public UIUserSelector() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        this.isShowSearch_ = true;
        this.uiIterator_ = new UIPageIterator();
        this.computePageList(null);
        this.uiIterator_.setId("UISelectUserPage");
    }

    private void computePageList(String keyword) {
        UserSearchService userSearchService = (UserSearchService)this.getApplicationComponent(UserSearchService.class);
        try {
            ListAccess userList = userSearchService.searchUsers(keyword);
            this.uiIterator_.setPageList((PageList)new LazyPageList(userList, 10));
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIUserSelector.errorListingUsers", null));
        }
    }

    public List<User> getData() throws Exception {
        if (this.getMulti()) {
            for (Object obj : this.uiIterator_.getCurrentPageData()) {
                User user = (User)obj;
                UIFormCheckBoxInput uiFormCheckBoxInput = this.getUIFormCheckBoxInput(user.getUserName());
                if (uiFormCheckBoxInput == null) {
                    uiFormCheckBoxInput = new UIFormCheckBoxInput(user.getUserName(), user.getUserName(), (Object)false);
                    this.addUIFormInput((UIFormInput)uiFormCheckBoxInput);
                }
                uiFormCheckBoxInput.setChecked(this.uiIterator_.isSelectedItem(user.getUserName()));
            }
        }
        return new ArrayList<User>(this.uiIterator_.getCurrentPageData());
    }

    public String getSelectedUsers() {
        return this.selectedUsers;
    }

    public void setSelectedUsers(String selectedUsers) {
        this.selectedUsers = selectedUsers;
    }

    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    public boolean getMulti() {
        return this.multi;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiIterator_;
    }

    public long getAvailablePage() {
        return this.uiIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiIterator_.getCurrentPage();
    }

    public String[] getActions() {
        return new String[]{"Add", "Close"};
    }

    public void activate() {
    }

    public void deActivate() {
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setShowSearch(boolean isShowSearch) {
        this.isShowSearch_ = isShowSearch;
    }

    public boolean isShowSearch() {
        return this.isShowSearch_;
    }

    public void setShowSearchUser(boolean isShowSearchUser) {
        this.isShowSearchUser = isShowSearchUser;
    }

    public void search(String keyword) throws Exception {
        this.computePageList(keyword);
    }

    public boolean isShowSearchUser() {
        return this.isShowSearchUser;
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiIterator_.setCurrentPage(page);
    }

    public void setKeyword(String value) {
        this.getUIStringInput(FIELD_KEYWORD).setValue((Object)value);
    }

    private void setSelectedItem() throws Exception {
        for (Object o : this.uiIterator_.getCurrentPageData()) {
            User u = (User)o;
            UIFormCheckBoxInput input = this.getUIFormCheckBoxInput(u.getUserName());
            if (input == null) continue;
            this.uiIterator_.setSelectedItem(u.getUserName(), input.isChecked());
        }
    }

    public static class ShowPageActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiSelectUserForm = (UIUserSelector)((Object)event.getSource());
            uiSelectUserForm.setSelectedItem();
            int page = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiSelectUserForm.updateCurrentPage(page);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSelectUserForm);
        }
    }

    public static class CloseActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)((Object)event.getSource());
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class SearchActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)((Object)event.getSource());
            String keyword = (String)uiForm.getUIStringInput(UIUserSelector.FIELD_KEYWORD).getValue();
            uiForm.search(keyword);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    public static class AddUserActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)((Object)event.getSource());
            String userName = event.getRequestContext().getRequestParameter("objectId");
            uiForm.setSelectedUsers(userName);
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }

    public static class AddActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)((Object)event.getSource());
            uiForm.setSelectedItem();
            StringBuilder sb = new StringBuilder();
            Set items = uiForm.uiIterator_.getSelectedItems();
            if (items.size() == 0) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIUserSelector.msg.user-required", null));
                return;
            }
            Object[] arrItems = items.toArray(new String[items.size()]);
            Arrays.sort(arrItems);
            for (Object key : arrItems) {
                if (sb.toString() != null && sb.toString().trim().length() != 0) {
                    sb.append(",");
                }
                sb.append((String)key);
            }
            uiForm.setSelectedUsers(sb.toString());
            uiForm.getParent().broadcast(event, event.getExecutionPhase());
        }
    }
}

