/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.resource.SkinConfig;
import org.exoplatform.portal.resource.SkinService;
import org.exoplatform.portal.resource.SkinURL;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.javascript.JavascriptConfigService;
import org.gatein.portal.controller.resource.ResourceId;
import org.gatein.portal.controller.resource.ResourceScope;
import org.gatein.portal.controller.resource.script.FetchMap;
import org.gatein.portal.controller.resource.script.FetchMode;
import org.gatein.portal.controller.resource.script.Module;
import org.gatein.portal.controller.resource.script.ScriptResource;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class JspBasedWebHandler
extends WebRequestHandler {
    private static final Log LOG = ExoLogger.getLogger(JspBasedWebHandler.class);
    protected static final String TEXT_HTML_CONTENT_TYPE = "text/html; charset=UTF-8";
    protected static final String JS_PATHS_PARAM = "paths";
    protected LocaleConfigService localeConfigService;
    protected BrandingService brandingService;
    protected JavascriptConfigService javascriptConfigService;
    protected SkinService skinService;

    protected JspBasedWebHandler(LocaleConfigService localeConfigService, BrandingService brandingService, JavascriptConfigService javascriptConfigService, SkinService skinService) {
        this.localeConfigService = localeConfigService;
        this.brandingService = brandingService;
        this.javascriptConfigService = javascriptConfigService;
        this.skinService = skinService;
    }

    public String getHandlerName() {
        throw new UnsupportedOperationException();
    }

    public boolean execute(ControllerContext context) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean getRequiresLifeCycle() {
        throw new UnsupportedOperationException();
    }

    public void prepareDispatch(ControllerContext context, String applicationModule, List<String> additionalJSModules, List<String> additionalCSSModules, Consumer<JSONObject> extendUIParameters) throws Exception {
        LocaleConfig localeConfig;
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        response.setContentType(TEXT_HTML_CONTENT_TYPE);
        LocaleConfig localeConfig2 = localeConfig = request.getLocale() == null ? this.localeConfigService.getDefaultLocaleConfig() : this.localeConfigService.getLocaleConfig(request.getLocale().getLanguage());
        if (localeConfig == null) {
            localeConfig = this.localeConfigService.getDefaultLocaleConfig();
        }
        request.setAttribute("localeConfig", (Object)localeConfig);
        Locale locale = localeConfig.getLocale();
        JavascriptManager javascriptManager = new JavascriptManager(this.javascriptConfigService);
        javascriptManager.loadScriptResource(ResourceScope.SHARED, "bootstrap");
        javascriptManager.loadScriptResource(ResourceScope.PORTLET, "social-portlet/Login");
        JSONObject params = new JSONObject();
        String companyName = this.brandingService.getCompanyName();
        params.put("companyName", (Object)companyName);
        String brandingLogo = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + "/v1/platform/branding/logo?v=" + this.brandingService.getLastUpdatedTime();
        params.put("brandingLogo", (Object)brandingLogo);
        params.put("authenticationBackground", (Object)this.brandingService.getLoginBackgroundPath());
        params.put("authenticationTextColor", (Object)this.brandingService.getLoginBackgroundTextColor());
        params.put("authenticationTitle", (Object)this.brandingService.getLoginTitle(locale));
        params.put("authenticationSubtitle", (Object)this.brandingService.getLoginSubtitle(locale));
        if (extendUIParameters != null) {
            extendUIParameters.accept(params);
        }
        if (StringUtils.isNotBlank((CharSequence)applicationModule)) {
            javascriptManager.require(applicationModule, "app").addScripts("app.init(" + params.toString() + ");");
        }
        JSONObject jsConfig = this.javascriptConfigService.getJSConfig(context, locale);
        request.setAttribute("jsConfig", (Object)jsConfig.toString());
        if (jsConfig.has(JS_PATHS_PARAM)) {
            JSONObject jsConfigPaths = jsConfig.getJSONObject(JS_PATHS_PARAM);
            LinkedList<String> headerScripts = this.getHeaderScripts(javascriptManager, jsConfigPaths);
            request.setAttribute("headerScripts", headerScripts);
            Set<String> pageScripts = this.getPageScripts(javascriptManager, additionalJSModules, jsConfigPaths);
            request.setAttribute("pageScripts", pageScripts);
        }
        request.setAttribute("inlineScripts", (Object)javascriptManager.getJavaScripts());
        String brandingPrimaryColor = (String)this.brandingService.getThemeStyle().get("primaryColor");
        String brandingThemeUrl = "/" + PortalContainer.getCurrentPortalContainerName() + "/" + PortalContainer.getCurrentRestContextName() + "/v1/platform/branding/css?v=" + this.brandingService.getLastUpdatedTime();
        request.setAttribute("brandingPrimaryColor", (Object)brandingPrimaryColor);
        request.setAttribute("brandingThemeUrl", (Object)brandingThemeUrl);
        request.setAttribute("brandingFavicon", (Object)this.brandingService.getFaviconPath());
        List<String> skinUrls = this.getPageSkins(context, additionalCSSModules, localeConfig.getOrientation());
        request.setAttribute("skinUrls", skinUrls);
    }

    private List<String> getPageSkins(ControllerContext controllerContext, List<String> additionalCSSModules, Orientation orientation) {
        String skinName = this.skinService.getDefaultSkin();
        ArrayList<SkinConfig> skins = new ArrayList<SkinConfig>();
        Collection<SkinConfig> portalSkins = this.skinService.getPortalSkins(skinName);
        skins.addAll(portalSkins);
        if (CollectionUtils.isNotEmpty(additionalCSSModules)) {
            additionalCSSModules.forEach(module -> {
                SkinConfig loginSkin = this.skinService.getSkin((String)module, skinName);
                if (loginSkin != null) {
                    skins.add(loginSkin);
                }
            });
        }
        Collection<SkinConfig> customSkins = this.skinService.getCustomPortalSkins(skinName);
        skins.addAll(customSkins);
        return skins.stream().map(skin -> {
            SkinURL url = skin.createURL(controllerContext);
            url.setOrientation(orientation);
            return url.toString();
        }).toList();
    }

    private Set<String> getPageScripts(JavascriptManager javascriptManager, List<String> additionalJSModules, JSONObject jsConfigPaths) throws JSONException {
        if (CollectionUtils.isNotEmpty(additionalJSModules)) {
            additionalJSModules.forEach(javascriptManager::require);
        }
        HashSet<String> pageScripts = new HashSet<String>();
        Map<String, Boolean> scriptsIdsMap = javascriptManager.getPageScripts();
        for (Map.Entry<String, Boolean> scriptEntry : scriptsIdsMap.entrySet()) {
            boolean isRemote = scriptEntry.getValue();
            String scriptId = scriptEntry.getKey();
            if (isRemote || !jsConfigPaths.has(scriptId)) continue;
            String scriptPath = jsConfigPaths.getString(scriptId) + ".js";
            pageScripts.add(scriptPath);
        }
        return pageScripts;
    }

    private LinkedList<String> getHeaderScripts(JavascriptManager javascriptManager, JSONObject jsConfigPaths) throws JSONException {
        Map<String, Boolean> scriptsURLs = this.getScripts(javascriptManager);
        LinkedList<String> headerScripts = new LinkedList<String>();
        for (Map.Entry<String, Boolean> moduleEntry : scriptsURLs.entrySet()) {
            String module = moduleEntry.getKey();
            String url = jsConfigPaths.has(module) ? jsConfigPaths.getString(module) : null;
            headerScripts.add((String)(url != null ? url + ".js" : module));
        }
        return headerScripts;
    }

    private Map<String, Boolean> getScripts(JavascriptManager javascriptManager) {
        FetchMap<ResourceId> requiredResources = javascriptManager.getScriptResources();
        Map<ScriptResource, FetchMode> resolved = this.javascriptConfigService.resolveIds(requiredResources);
        LinkedHashMap<String, Boolean> ret = new LinkedHashMap<String, Boolean>();
        LinkedHashMap<String, Boolean> tmp = new LinkedHashMap<String, Boolean>();
        for (ScriptResource rs : resolved.keySet()) {
            ResourceId id = rs.getId();
            if (ResourceScope.SHARED.equals((Object)id.getScope()) && "bootstrap".equals(id.getName())) {
                ret.put(id.toString(), false);
                continue;
            }
            boolean isRemote = !rs.isEmpty() && rs.getModules().get(0) instanceof Module.Remote;
            tmp.put(id.toString(), isRemote);
        }
        ret.putAll(tmp);
        for (String url : javascriptManager.getExtendedScriptURLs()) {
            ret.put(url, true);
        }
        LOG.debug((Object)("Resolved resources for page: " + ret));
        return ret;
    }
}

