/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.processor;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.social.core.BaseActivityProcessorPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.utils.MentionUtils;

public class MentionsProcessor
extends BaseActivityProcessorPlugin {
    private UserPortalConfigService userPortalConfigService;
    private IdentityManager identityManager;

    public MentionsProcessor(UserPortalConfigService userPortalConfigService, IdentityManager identityManager, InitParams params) {
        super(params);
        this.userPortalConfigService = userPortalConfigService;
        this.identityManager = identityManager;
    }

    public void processActivity(ExoSocialActivity activity) {
        if (activity != null) {
            String portalOwner = this.userPortalConfigService.getDefaultPortal();
            activity.setTitle(MentionUtils.substituteUsernames(this.identityManager, portalOwner, activity.getTitle()));
            activity.setBody(MentionUtils.substituteUsernames(this.identityManager, portalOwner, activity.getBody()));
            Map templateParams = activity.getTemplateParams();
            if (MapUtils.isNotEmpty((Map)templateParams)) {
                List templateParamKeys = this.getTemplateParamKeysToFilter(activity);
                for (String key : templateParamKeys) {
                    templateParams.put(key, MentionUtils.substituteUsernames(this.identityManager, portalOwner, (String)templateParams.get(key)));
                }
                if (templateParams.containsKey("comment")) {
                    templateParams.put("comment", MentionUtils.substituteUsernames(this.identityManager, portalOwner, (String)templateParams.get("comment")));
                }
                if (templateParams.containsKey("default_title")) {
                    templateParams.put("default_title", MentionUtils.substituteUsernames(this.identityManager, portalOwner, (String)templateParams.get("default_title")));
                }
            }
        }
    }
}

