/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.SiteBody;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.webui.application.PortletState;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIComponentFactory;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.page.UISiteBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.core.UIComponent;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.PortletInfo;

public class PortalDataMapper {
    protected static final Log log = ExoLogger.getLogger((String)"portal:PortalDataMapper");

    public static ModelObject buildModelObject(UIComponent uiComponent) {
        Container model;
        block6: {
            model = null;
            try {
                model = uiComponent.buildModelObject();
            }
            catch (UnsupportedOperationException ex) {
                if (uiComponent instanceof UIPortal) {
                    model = PortalDataMapper.toPortal((UIPortal)uiComponent);
                }
                if (uiComponent instanceof UIPageBody) {
                    model = new PageBody(((UIPageBody)uiComponent).getStorageId());
                }
                if (uiComponent instanceof UIPage) {
                    model = PortalDataMapper.toPageModel((UIPage)uiComponent);
                }
                if (uiComponent instanceof UIPortlet) {
                    model = PortalDataMapper.toPortletModel((UIPortlet)uiComponent);
                }
                if (!(uiComponent instanceof UIContainer)) break block6;
                model = PortalDataMapper.toContainer((UIContainer)uiComponent);
            }
        }
        return model;
    }

    public static void toContainer(Container model, UIContainer uiContainer) {
        model.setId(uiContainer.getId());
        model.setName(uiContainer.getName());
        model.setTitle(uiContainer.getTitle());
        model.setIcon(uiContainer.getIcon());
        model.setDescription(uiContainer.getDescription());
        model.setHeight(uiContainer.getHeight());
        model.setWidth(uiContainer.getWidth());
        model.setCssClass(uiContainer.getCssClass());
        model.setProfiles(uiContainer.getProfiles());
        model.setTemplate(uiContainer.getTemplate());
        model.setFactoryId(uiContainer.getFactoryId());
        model.setAccessPermissions(uiContainer.getAccessPermissions());
        model.setMoveAppsPermissions(uiContainer.getMoveAppsPermissions());
        model.setMoveContainersPermissions(uiContainer.getMoveContainersPermissions());
        List uiChildren = uiContainer.getChildren();
        if (uiChildren == null) {
            return;
        }
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        for (UIComponent child : uiChildren) {
            ModelObject component = PortalDataMapper.buildModelObject(child);
            if (component == null) continue;
            children.add(component);
        }
        model.setChildren(children);
    }

    private static <S> Application<S> toPortletModel(UIPortlet<S, ?> uiPortlet) {
        PortletState<S> state = uiPortlet.getState();
        ApplicationType<S> type = state.getApplicationType();
        if (type != ApplicationType.PORTLET) {
            throw new AssertionError();
        }
        Application model = Application.createPortletApplication((String)uiPortlet.getStorageId());
        model.setStorageName(uiPortlet.getStorageName());
        model.setState(state.getApplicationState());
        model.setTitle(uiPortlet.getTitle());
        model.setWidth(uiPortlet.getWidth());
        model.setHeight(uiPortlet.getHeight());
        model.setDescription(uiPortlet.getDescription());
        model.setShowInfoBar(uiPortlet.getShowInfoBar());
        model.setShowApplicationState(uiPortlet.getShowWindowState());
        model.setShowApplicationMode(uiPortlet.getShowPortletMode());
        model.setDescription(uiPortlet.getDescription());
        model.setIcon(uiPortlet.getIcon());
        model.setProperties(uiPortlet.getProperties());
        model.setTheme(uiPortlet.getTheme());
        model.setAccessPermissions(uiPortlet.getAccessPermissions());
        model.setModifiable(uiPortlet.isModifiable());
        return model;
    }

    private static Container toContainer(UIContainer uiContainer) {
        Container model = new Container(uiContainer.getStorageId());
        PortalDataMapper.toContainer(model, uiContainer);
        return model;
    }

    public static Page toPageModel(UIPage uiPage) {
        Page model = new Page(uiPage.getStorageId());
        PortalDataMapper.toContainer((Container)model, uiPage);
        model.setOwnerId(uiPage.getSiteKey().getName());
        model.setOwnerType(uiPage.getSiteKey().getTypeName());
        model.setIcon(uiPage.getIcon());
        model.setPageId(uiPage.getPageId());
        model.setTitle(uiPage.getTitle());
        model.setAccessPermissions(uiPage.getAccessPermissions());
        model.setEditPermission(uiPage.getEditPermission());
        model.setFactoryId(uiPage.getFactoryId());
        model.setShowMaxWindow(Boolean.valueOf(uiPage.isShowMaxWindow()));
        model.setHideSharedLayout(uiPage.isHideSharedLayout());
        model.setModifiable(uiPage.isModifiable());
        return model;
    }

    private static PortalConfig toPortal(UIPortal uiPortal) {
        PortalConfig model = new PortalConfig(uiPortal.getSiteType().getName(), uiPortal.getName(), uiPortal.getStorageId());
        model.setAccessPermissions(uiPortal.getAccessPermissions());
        model.setEditPermission(uiPortal.getEditPermission());
        model.setLabel(uiPortal.getLabel());
        model.setDescription(uiPortal.getDescription());
        model.setLocale(uiPortal.getLocale());
        model.setSkin(uiPortal.getSkin());
        model.setModifiable(uiPortal.isModifiable());
        model.setProperties(uiPortal.getProperties());
        model.setPortalRedirects(uiPortal.getPortalRedirects());
        model.setDefaultLayout(uiPortal.isUseDynamicLayout());
        model.setPortalLayout(new Container());
        LayoutService layoutService = (LayoutService)uiPortal.getApplicationComponent(LayoutService.class);
        PortalConfig portalConfig = layoutService.getPortalConfig(uiPortal.getSiteKey());
        model.setDisplayed(portalConfig.isDisplayed());
        model.setDisplayOrder(portalConfig.getDisplayOrder());
        model.setBannerFileId(portalConfig.getBannerFileId());
        List children = uiPortal.getChildren();
        if (children == null || children.isEmpty()) {
            model.useDefaultPortalLayout();
            return model;
        }
        ArrayList<ModelObject> newChildren = new ArrayList<ModelObject>();
        for (UIComponent child : children) {
            ModelObject component = PortalDataMapper.buildModelObject(child);
            if (component == null) continue;
            newChildren.add(component);
        }
        model.getPortalLayout().setChildren(newChildren);
        model.getPortalLayout().setMoveAppsPermissions(uiPortal.getMoveAppsPermissions());
        model.getPortalLayout().setMoveContainersPermissions(uiPortal.getMoveContainersPermissions());
        return model;
    }

    private static <S> void toUIPortlet(UIPortlet<S, ?> uiPortlet, Application<S> model) {
        PortletState portletState = new PortletState(model.getState(), model.getType());
        uiPortlet.setWidth(model.getWidth());
        uiPortlet.setHeight(model.getHeight());
        uiPortlet.setState(portletState);
        uiPortlet.setTitle(model.getTitle());
        uiPortlet.setIcon(model.getIcon());
        uiPortlet.setDescription(model.getDescription());
        uiPortlet.setShowInfoBar(model.getShowInfoBar());
        uiPortlet.setShowWindowState(model.getShowApplicationState());
        uiPortlet.setShowPortletMode(model.getShowApplicationMode());
        uiPortlet.setProperties(model.getProperties());
        uiPortlet.setTheme(model.getTheme());
        if (model.getAccessPermissions() != null) {
            uiPortlet.setAccessPermissions(model.getAccessPermissions());
        }
        uiPortlet.setModifiable(model.isModifiable());
        Portlet portlet = uiPortlet.getProducedOfferedPortlet();
        if (portlet == null || portlet.getInfo() == null) {
            return;
        }
        PortletInfo portletInfo = portlet.getInfo();
        Set modes = portletInfo.getCapabilities().getModes(MediaType.create((String)"text/html"));
        ArrayList<String> supportModes = new ArrayList<String>();
        for (ModeInfo modeInfo : modes) {
            String modeName = modeInfo.getModeName().toLowerCase();
            if ("config".equals(modeInfo.getModeName())) {
                supportModes.add(modeName);
                continue;
            }
            supportModes.add(modeName);
        }
        if (supportModes.size() > 1) {
            supportModes.remove("view");
        }
        uiPortlet.setSupportModes(supportModes);
    }

    public static void toUIContainer(UIContainer uiContainer, Container model) throws Exception {
        uiContainer.setStorageId(model.getStorageId());
        uiContainer.setId(model.getId());
        uiContainer.setWidth(model.getWidth());
        uiContainer.setHeight(model.getHeight());
        uiContainer.setProfiles(model.getProfiles());
        uiContainer.setCssClass(model.getCssClass());
        uiContainer.setTitle(model.getTitle());
        uiContainer.setIcon(model.getIcon());
        uiContainer.setDescription(model.getDescription());
        uiContainer.setFactoryId(model.getFactoryId());
        uiContainer.setName(model.getName());
        uiContainer.setTemplate(model.getTemplate());
        if (model.getAccessPermissions() != null) {
            uiContainer.setAccessPermissions(model.getAccessPermissions());
        }
        uiContainer.setMoveAppsPermissions(model.getMoveAppsPermissions());
        uiContainer.setMoveContainersPermissions(model.getMoveContainersPermissions());
        ArrayList children = model.getChildren();
        if (children == null) {
            return;
        }
        for (Object child : children) {
            PortalDataMapper.buildUIContainer(uiContainer, child);
        }
    }

    public static void toUIPage(UIPage uiPage, Page model) throws Exception {
        PortalDataMapper.toUIContainer(uiPage, (Container)model);
        uiPage.setSiteKey(new SiteKey(model.getOwnerType(), model.getOwnerId()));
        uiPage.setIcon(model.getIcon());
        uiPage.setAccessPermissions(model.getAccessPermissions());
        uiPage.setEditPermission(model.getEditPermission());
        uiPage.setFactoryId(model.getFactoryId());
        uiPage.setPageId(model.getPageId());
        uiPage.setTitle(model.getTitle());
        uiPage.setProfiles(model.getProfiles());
        uiPage.setShowMaxWindow(model.isShowMaxWindow());
        uiPage.setHideSharedLayout(model.isHideSharedLayout());
        uiPage.setModifiable(model.isModifiable());
        ArrayList portlets = new ArrayList();
        uiPage.findComponentOfType(portlets, UIPortlet.class);
        for (UIPortlet portlet : portlets) {
            portlet.setPortletInPortal(false);
        }
    }

    public static void toUIPortal(UIPortal uiPortal, PortalConfig model) throws Exception {
        uiPortal.setSiteKey(new SiteKey(model.getType(), model.getName()));
        uiPortal.setStorageId(model.getStorageId());
        uiPortal.setName(model.getName());
        uiPortal.setId("UIPortal");
        uiPortal.setModifiable(model.isModifiable());
        uiPortal.setLabel(model.getLabel());
        uiPortal.setDescription(model.getDescription());
        uiPortal.setLocale(model.getLocale());
        uiPortal.setSkin(model.getSkin());
        uiPortal.setAccessPermissions(model.getAccessPermissions());
        uiPortal.setEditPermission(model.getEditPermission());
        uiPortal.setProperties(model.getProperties());
        uiPortal.setRedirects(model.getPortalRedirects());
        uiPortal.setUseDynamicLayout(model.isDefaultLayout());
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)uiPortal.getApplicationComponent(UserPortalConfigService.class);
        PortalConfig metaSite = userPortalConfigService.getDefaultPortalConfig();
        Container layout = model.isDisplayed() ? metaSite.getPortalLayout() : model.getPortalLayout();
        uiPortal.setMoveAppsPermissions(layout.getMoveAppsPermissions());
        uiPortal.setMoveContainersPermissions(layout.getMoveContainersPermissions());
        ArrayList children = layout.getChildren();
        if (children != null) {
            for (Object child : children) {
                PortalDataMapper.buildUIContainer(uiPortal, child);
            }
        }
    }

    private static void buildUIContainer(UIContainer uiContainer, Object model) throws Exception {
        Object uiComponent = null;
        PortalRequestContext context = Util.getPortalRequestContext();
        if (model instanceof SiteBody) {
            UISiteBody uiSiteBody = (UISiteBody)uiContainer.createUIComponent(context, UISiteBody.class, null, null);
            uiSiteBody.setStorageId(((SiteBody)model).getStorageId());
            uiComponent = uiSiteBody;
        } else if (model instanceof PageBody) {
            UIPageBody uiPageBody = (UIPageBody)uiContainer.createUIComponent(context, UIPageBody.class, null, null);
            uiPageBody.setStorageId(((PageBody)model).getStorageId());
            uiComponent = uiPageBody;
        } else if (model instanceof Application) {
            Application application = (Application)model;
            UIPortlet uiPortlet = (UIPortlet)uiContainer.createUIComponent(context, UIPortlet.class, null, null);
            uiPortlet.setStorageId(application.getStorageId());
            if (application.getStorageName() != null) {
                uiPortlet.setStorageName(application.getStorageName());
            }
            PortalDataMapper.toUIPortlet(uiPortlet, application);
            uiComponent = uiPortlet;
        } else if (model instanceof Container) {
            Container container = (Container)model;
            UIComponentFactory<UIContainer> factory = UIComponentFactory.getInstance(UIContainer.class);
            UIContainer uiTempContainer = factory.createUIComponent(container.getFactoryId(), context);
            if (uiTempContainer == null) {
                log.warn("Can't find container factory for: {}. Default container is used", new Object[]{container.getFactoryId()});
                uiTempContainer = (UIContainer)uiContainer.createUIComponent(context, UIContainer.class, null, null);
            }
            PortalDataMapper.toUIContainer(uiTempContainer, (Container)model);
            uiComponent = uiTempContainer;
        }
        uiContainer.addChild((UIComponent)uiComponent);
    }
}

