/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.manager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.social.common.lifecycle.LifeCycleListener;
import org.exoplatform.social.core.identity.ConnectionFilterListAccess;
import org.exoplatform.social.core.identity.ConnectionListAccess;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.RelationshipLifeCycle;
import org.exoplatform.social.core.relationship.RelationshipListener;
import org.exoplatform.social.core.relationship.RelationshipListenerPlugin;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.storage.RelationshipStorageException;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.social.core.storage.api.RelationshipStorage;

public class RelationshipManagerImpl
implements RelationshipManager {
    protected static final int OFFSET = 0;
    protected static final int LIMIT = 200;
    private RelationshipLifeCycle lifeCycle = new RelationshipLifeCycle();
    private RelationshipStorage relationshipStorage;
    private IdentityStorage identityStorage;
    private IdentityManager identityManager;

    public RelationshipManagerImpl(IdentityManager identityManager, IdentityStorage identityStorage, RelationshipStorage relationshipStorage) {
        this.identityManager = identityManager;
        this.relationshipStorage = relationshipStorage;
        this.identityStorage = identityStorage;
    }

    public Relationship inviteToConnect(Identity invitingIdentity, Identity invitedIdentity) {
        Relationship relationship = this.get(invitingIdentity, invitedIdentity);
        if (relationship == null || Relationship.Type.IGNORED.equals((Object)relationship.getStatus())) {
            relationship = new Relationship(invitingIdentity, invitedIdentity);
            relationship.setStatus(Relationship.Type.PENDING);
            this.saveRelationship(relationship);
            this.lifeCycle.relationshipRequested(this, relationship);
        }
        return relationship;
    }

    public Relationship confirm(Identity invitedIdentity, Identity invitingIdentity) {
        Relationship relationship = this.get(invitedIdentity, invitingIdentity);
        if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
            relationship.setStatus(Relationship.Type.CONFIRMED);
            this.saveRelationship(relationship);
            this.lifeCycle.relationshipConfirmed(this, relationship);
        }
        return relationship;
    }

    public void deny(Identity invitedIdentity, Identity invitingIdentity) {
        Relationship relationship = this.get(invitedIdentity, invitingIdentity);
        if (relationship != null) {
            this.relationshipStorage.removeRelationship(relationship);
            this.lifeCycle.relationshipDenied(this, relationship);
        }
    }

    public Relationship ignore(Identity sender, Identity receiver) {
        Relationship relationship = this.get(sender, receiver);
        if (relationship == null || !Relationship.Type.IGNORED.equals((Object)relationship.getStatus())) {
            relationship = new Relationship(sender, receiver);
            relationship.setStatus(Relationship.Type.IGNORED);
            this.saveRelationship(relationship);
            this.lifeCycle.relationshipIgnored(this, relationship);
        }
        return relationship;
    }

    public void delete(Relationship existingRelationship) {
        this.relationshipStorage.removeRelationship(existingRelationship);
        this.lifeCycle.relationshipRemoved(this, existingRelationship);
    }

    public List<Identity> findRelationships(Identity ownerIdentity, Relationship.Type relationshipType) throws RelationshipStorageException {
        List<Relationship> allRelationships = this.getAll(ownerIdentity, relationshipType, null);
        ArrayList<Identity> identities = new ArrayList<Identity>();
        if (allRelationships == null || allRelationships.isEmpty()) {
            return identities;
        }
        for (Relationship relationship : allRelationships) {
            identities.add(relationship.getPartner(ownerIdentity));
        }
        return identities;
    }

    public Relationship get(Identity identity1, Identity identity2) throws RelationshipStorageException {
        return this.relationshipStorage.getRelationship(identity1, identity2);
    }

    public Relationship get(String relationshipId) {
        Relationship relationship = null;
        try {
            relationship = this.relationshipStorage.getRelationship(relationshipId);
        }
        catch (Exception e) {
            return null;
        }
        return relationship;
    }

    public List<Relationship> getAll(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.ALL, null);
    }

    public List<Relationship> getAll(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.ALL, identities);
    }

    public List<Relationship> getAll(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, type, identities);
    }

    public List<Relationship> getAllRelationships(Identity identity) throws RelationshipStorageException {
        return this.getAll(identity);
    }

    public ListAccess<Identity> getAllWithListAccess(Identity existingIdentity) {
        return new ConnectionListAccess(this.relationshipStorage, existingIdentity, ConnectionListAccess.Type.ALL);
    }

    public List<Relationship> getConfirmed(Identity identity) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, null);
    }

    public List<Relationship> getConfirmed(Identity identity, List<Identity> identities) throws RelationshipStorageException {
        return this.getRelationships(identity, Relationship.Type.CONFIRMED, identities);
    }

    public ListAccess<Identity> getConnections(Identity identity) {
        return new ConnectionListAccess(this.relationshipStorage, identity, ConnectionListAccess.Type.CONNECTION);
    }

    public ListAccess<Identity> getConnectionsByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        profileFilter = this.checkSortingOnProfileFilter(profileFilter);
        return new ConnectionFilterListAccess(this.identityStorage, this.relationshipStorage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_CONNECTION);
    }

    public int getConnectionsInCommonCount(Identity currentUserIdentity, Identity identity) {
        return this.relationshipStorage.getConnectionsInCommonCount(currentUserIdentity, identity);
    }

    public Relationship.Type getConnectionStatus(Identity fromIdentity, Identity toIdentity) throws Exception {
        return this.getStatus(fromIdentity, toIdentity);
    }

    public List<Relationship> getContacts(Identity identity) throws RelationshipStorageException {
        return this.getAll(identity, Relationship.Type.CONFIRMED, null);
    }

    public List<Relationship> getContacts(Identity currIdentity, List<Identity> identities) throws RelationshipStorageException {
        return this.getAll(currIdentity, Relationship.Type.CONFIRMED, identities);
    }

    public List<Identity> getIdentities(Identity id) throws Exception {
        return Arrays.asList((Identity[])this.getConnections(id).load(0, 200));
    }

    public List<Relationship> getIncoming(Identity receiver) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, null);
    }

    public List<Relationship> getIncoming(Identity receiver, List<Identity> identities) throws RelationshipStorageException {
        return this.getReceiver(receiver, Relationship.Type.PENDING, identities);
    }

    public ListAccess<Identity> getIncomingByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        profileFilter = this.checkSortingOnProfileFilter(profileFilter);
        return new ConnectionFilterListAccess(this.identityStorage, this.relationshipStorage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_INCOMMING);
    }

    public ListAccess<Identity> getIncomingWithListAccess(Identity existingIdentity) {
        return new ConnectionListAccess(this.relationshipStorage, existingIdentity, ConnectionListAccess.Type.INCOMING);
    }

    public List<Identity> getLastConnections(Identity identity, int limit) {
        return this.relationshipStorage.getLastConnections(identity, limit);
    }

    public ListAccess<Identity> getOutgoing(Identity existingIdentity) {
        return new ConnectionListAccess(this.relationshipStorage, existingIdentity, ConnectionListAccess.Type.OUTGOING);
    }

    public ListAccess<Identity> getOutgoingByFilter(Identity existingIdentity, ProfileFilter profileFilter) {
        profileFilter = this.checkSortingOnProfileFilter(profileFilter);
        return new ConnectionFilterListAccess(this.identityStorage, this.relationshipStorage, existingIdentity, profileFilter, ConnectionFilterListAccess.Type.PROFILE_FILTER_OUTGOING);
    }

    public List<Relationship> getPending(Identity sender) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, null);
    }

    public List<Relationship> getPending(Identity sender, List<Identity> identities) throws RelationshipStorageException {
        return this.getSender(sender, Relationship.Type.PENDING, identities);
    }

    public List<Relationship> getPendingRelationships(Identity identity) throws RelationshipStorageException {
        return this.getPending(identity);
    }

    public List<Relationship> getPendingRelationships(Identity identity, boolean toConfirm) throws RelationshipStorageException {
        return this.getAll(identity, Relationship.Type.PENDING, null);
    }

    public List<Relationship> getPendingRelationships(Identity currIdentity, List<Identity> identities, boolean toConfirm) throws RelationshipStorageException {
        return this.getAll(currIdentity, Relationship.Type.PENDING, identities);
    }

    public Relationship getRelationship(Identity sender, Identity receiver) throws RelationshipStorageException {
        return this.get(sender, receiver);
    }

    public Relationship getRelationshipById(String id) throws RelationshipStorageException {
        return this.get(id);
    }

    public List<Relationship> getRelationshipsByIdentityId(String id) throws RelationshipStorageException {
        return this.getAll(this.identityManager.getIdentity(id));
    }

    public List<Relationship> getRelationshipsByStatus(Identity identity, Relationship.Type type, int offset, int limit) {
        return this.relationshipStorage.getRelationshipsByStatus(identity, type, (long)offset, (long)limit);
    }

    public int getRelationshipsCountByStatus(Identity identity, Relationship.Type type) {
        return this.relationshipStorage.getRelationshipsCountByStatus(identity, type);
    }

    public Relationship.Type getRelationshipStatus(Relationship rel, Identity id) {
        return rel.getStatus();
    }

    public Relationship.Type getStatus(Identity identity1, Identity identity2) throws RelationshipStorageException {
        Relationship relationship = this.get(identity1, identity2);
        return relationship == null ? null : relationship.getStatus();
    }

    public void confirm(Relationship relationship) throws RelationshipStorageException {
        this.confirm(relationship.getReceiver(), relationship.getSender());
    }

    public void deny(Relationship relationship) throws RelationshipStorageException {
        this.deny(relationship.getReceiver(), relationship.getSender());
    }

    public Map<Identity, Integer> getSuggestions(Identity identity, int offset, int limit) {
        LinkedHashMap result = this.relationshipStorage.getSuggestions(identity, -1, -1, offset + limit);
        if (result != null && !result.isEmpty()) {
            Iterator it;
            if (offset > 0) {
                result = new LinkedHashMap(result);
                it = result.entrySet().iterator();
                for (int o = 0; it.hasNext() && o < offset; ++o) {
                    it.next();
                    it.remove();
                }
            }
            if (result.size() > limit) {
                result = new LinkedHashMap(result);
                int i = 0;
                it = result.entrySet().iterator();
                while (it.hasNext()) {
                    it.next();
                    if (i >= limit) {
                        it.remove();
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    public Map<Identity, Integer> getSuggestions(Identity identity, int maxConnections, int maxConnectionsToLoad, int maxSuggestions) {
        return this.relationshipStorage.getSuggestions(identity, maxConnections, maxConnectionsToLoad, maxSuggestions);
    }

    public void ignore(Relationship relationship) throws RelationshipStorageException {
        this.ignore(relationship.getSender(), relationship.getReceiver());
    }

    public Relationship invite(Identity sender, Identity receiver) throws RelationshipStorageException {
        return this.inviteToConnect(sender, receiver);
    }

    public void remove(Relationship relationship) throws RelationshipStorageException {
        this.delete(relationship);
    }

    public void addListenerPlugin(RelationshipListenerPlugin plugin) {
        this.registerListener((RelationshipListener)plugin);
    }

    public void registerListener(RelationshipListener listener) {
        this.lifeCycle.addListener((LifeCycleListener)listener);
    }

    public void unregisterListener(RelationshipListener listener) {
        this.lifeCycle.removeListener((LifeCycleListener)listener);
    }

    protected List<Relationship> getReceiver(Identity receiver, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.relationshipStorage.getReceiverRelationships(receiver, type, identities);
    }

    protected List<Relationship> getRelationships(Identity identity, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.relationshipStorage.getRelationships(identity, type, identities);
    }

    protected List<Relationship> getSender(Identity sender, Relationship.Type type, List<Identity> identities) throws RelationshipStorageException {
        return this.relationshipStorage.getSenderRelationships(sender, type, identities);
    }

    private ProfileFilter checkSortingOnProfileFilter(ProfileFilter profileFilter) {
        if (profileFilter == null) {
            profileFilter = new ProfileFilter();
        }
        if (profileFilter.isSortingEmpty()) {
            profileFilter.setSorting(this.identityManager.getDefaultSorting());
        }
        if (StringUtils.isBlank((CharSequence)profileFilter.getFirstCharFieldName())) {
            profileFilter.setFirstCharFieldName(this.identityManager.getFirstCharacterFiltering());
        }
        return profileFilter;
    }

    private void saveRelationship(Relationship relationship) throws RelationshipStorageException {
        String receiverId;
        String senderId = relationship.getSender().getId();
        if (senderId.equals(receiverId = relationship.getReceiver().getId())) {
            throw new RelationshipStorageException(RelationshipStorageException.Type.FAILED_TO_SAVE_RELATIONSHIP, "the two identity are the same");
        }
        this.relationshipStorage.saveRelationship(relationship);
    }
}

