/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.portal.security.service;

import io.meeds.portal.security.constant.UserRegistrationType;
import io.meeds.portal.security.model.RegistrationSetting;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class SecuritySettingService {
    public static final String ACCESS_TYPE_MODIFIED = "meeds.settings.access.type.modified";
    public static final String EXTERNAL_USER_REG_MODIFIED = "meeds.settings.access.externalUsers.modified";
    public static final String DEFAULT_GROUPS_MODIFIED = "meeds.settings.access.defaultGroups.modified";
    protected static final String INTERNAL_USERS_GROUP = "/platform/users";
    protected static final String EXTERNAL_USERS_GROUP = "/platform/externals";
    protected static final Context SECURITY_CONTEXT = Context.GLOBAL.id("SECURITY");
    protected static final Scope SECURITY_SCOPE = Scope.APPLICATION.id("SECURITY");
    protected static final String REGISTRATION_TYPE_PARAM = "REGISTRATION_TYPE";
    protected static final String REGISTRATION_EXTERNAL_USER_PARAM = "REGISTRATION_EXTERNAL_USER";
    protected static final String REGISTRATION_EXTRA_GROUPS_PARAM = "REGISTRATION_EXTRA_GROUPS";
    protected static final String EXTRA_GROUPS_SEPARATOR = ",";
    protected static final UserRegistrationType DEFAULT_REGISTRATION_TYPE = UserRegistrationType.valueOf(System.getProperty("meeds.settings.access.type.default", UserRegistrationType.OPEN.name()).toUpperCase());
    protected static final boolean DEFAULT_REGISTRATION_EXTERNAL_USER = Boolean.parseBoolean(System.getProperty("meeds.settings.access.externalUsers", "false").toLowerCase());
    private static final Log LOG = ExoLogger.getLogger(SecuritySettingService.class);
    private RegistrationSetting registrationSetting;
    private SettingService settingService;
    private ListenerService listenerService;

    public SecuritySettingService(SettingService settingService, ListenerService listenerService) {
        this.settingService = settingService;
        this.listenerService = listenerService;
    }

    public RegistrationSetting getRegistrationSetting() {
        if (this.registrationSetting == null) {
            this.registrationSetting = new RegistrationSetting(this.getRegistrationType(), this.isRegistrationExternalUser(), this.getRegistrationExtraGroupIds());
        }
        return this.registrationSetting;
    }

    public void saveRegistrationSetting(RegistrationSetting registrationSetting) {
        this.saveRegistrationType(registrationSetting.getType());
        this.saveRegistrationExternalUser(registrationSetting.isExternalUser());
        this.saveRegistrationExtraGroupIds(registrationSetting.getExtraGroupIds());
    }

    public String[] getRegistrationGroupIds() {
        ArrayList<String> registrationExtraGroupIds = new ArrayList<String>(Arrays.asList(this.getRegistrationExtraGroupIds()));
        if (this.isRegistrationExternalUser()) {
            registrationExtraGroupIds.add(EXTERNAL_USERS_GROUP);
        } else {
            registrationExtraGroupIds.add(INTERNAL_USERS_GROUP);
        }
        return registrationExtraGroupIds.stream().filter(StringUtils::isNotBlank).distinct().toList().toArray(new String[0]);
    }

    public UserRegistrationType getRegistrationType() {
        SettingValue settingValue = this.settingService.get(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_TYPE_PARAM);
        if (settingValue == null || settingValue.getValue() == null) {
            return DEFAULT_REGISTRATION_TYPE;
        }
        return UserRegistrationType.valueOf(settingValue.getValue().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRegistrationType(UserRegistrationType registrationType) {
        UserRegistrationType storedRegistrationType;
        boolean modified;
        if (registrationType == null) {
            registrationType = DEFAULT_REGISTRATION_TYPE;
        }
        boolean bl = modified = registrationType != (storedRegistrationType = this.getRegistrationType());
        if (modified) {
            try {
                this.settingService.set(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_TYPE_PARAM, SettingValue.create((String)registrationType.toString()));
                this.broadcastEvent(ACCESS_TYPE_MODIFIED, null, (Object)registrationType);
            }
            finally {
                this.registrationSetting = null;
            }
        }
    }

    public boolean isRegistrationExternalUser() {
        SettingValue settingValue = this.settingService.get(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_EXTERNAL_USER_PARAM);
        if (settingValue == null || settingValue.getValue() == null) {
            return DEFAULT_REGISTRATION_EXTERNAL_USER;
        }
        return Boolean.parseBoolean(settingValue.getValue().toString());
    }

    public void saveRegistrationExternalUser(boolean externalUser) {
        if (externalUser != this.isRegistrationExternalUser()) {
            try {
                this.settingService.set(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_EXTERNAL_USER_PARAM, SettingValue.create((String)String.valueOf(externalUser)));
                this.broadcastEvent(EXTERNAL_USER_REG_MODIFIED, null, externalUser);
            }
            finally {
                this.registrationSetting = null;
            }
        }
    }

    public String[] getRegistrationExtraGroupIds() {
        SettingValue settingValue = this.settingService.get(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_EXTRA_GROUPS_PARAM);
        if (settingValue == null || settingValue.getValue() == null) {
            return new String[0];
        }
        return (String[])Arrays.stream(settingValue.getValue().toString().split(EXTRA_GROUPS_SEPARATOR)).filter(StringUtils::isNotBlank).distinct().toArray(String[]::new);
    }

    public void saveRegistrationExtraGroupIds(String[] groupIds) {
        try {
            if (groupIds == null) {
                groupIds = new String[]{};
            }
            this.settingService.set(SECURITY_CONTEXT, SECURITY_SCOPE, REGISTRATION_EXTRA_GROUPS_PARAM, SettingValue.create((String)StringUtils.join((Object[])groupIds, (String)EXTRA_GROUPS_SEPARATOR)));
            this.broadcastEvent(DEFAULT_GROUPS_MODIFIED, null, groupIds);
        }
        finally {
            this.registrationSetting = null;
        }
    }

    private void broadcastEvent(String eventName, Object source, Object data) {
        try {
            this.listenerService.broadcast(eventName, source, data);
        }
        catch (Exception e) {
            LOG.warn("Error broacasting event {} with source {} and data {}", new Object[]{eventName, source, data, e});
        }
    }
}

