/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.log.LogLevel;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.idm.GroupDAOImpl;
import org.exoplatform.services.organization.idm.MembershipImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMOrganizationServiceImpl;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.services.organization.idm.Tools;
import org.picketlink.idm.api.IdentitySearchCriteria;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.SortOrder;
import org.picketlink.idm.api.User;
import org.picketlink.idm.impl.api.IdentitySearchCriteriaImpl;
import org.picketlink.idm.impl.api.model.SimpleRole;
import org.picketlink.idm.impl.api.model.SimpleRoleType;

public class IDMMembershipListAccess
implements ListAccess<Membership>,
Serializable {
    private static final long serialVersionUID = 6908892334798859546L;
    private static Log log = ExoLogger.getLogger(IDMMembershipListAccess.class);
    private final org.picketlink.idm.api.Group group;
    private String groupId;
    private final User user;
    private int size = -1;
    private final boolean usePaginatedQuery;
    private List<Role> fullResults;
    private String associationMembershipType = null;
    private int rolesCount = 0;
    private List<User> associatedUsers = null;

    public IDMMembershipListAccess(org.picketlink.idm.api.Group group, boolean usePaginatedQuery) {
        this.group = group;
        this.user = null;
        this.usePaginatedQuery = usePaginatedQuery;
        this.associationMembershipType = this.getOrganizationService().getConfiguration().getAssociationMembershipType();
    }

    public IDMMembershipListAccess(org.picketlink.idm.api.Group group, String groupId, boolean usePaginatedQuery) {
        this.group = group;
        this.user = null;
        this.usePaginatedQuery = usePaginatedQuery;
        this.groupId = groupId;
        this.associationMembershipType = this.getOrganizationService().getConfiguration().getAssociationMembershipType();
    }

    public IDMMembershipListAccess(User user, boolean usePaginatedQuery) {
        this.group = null;
        this.user = user;
        this.usePaginatedQuery = usePaginatedQuery;
        this.associationMembershipType = this.getOrganizationService().getConfiguration().getAssociationMembershipType();
    }

    public Membership[] load(int index, int length) throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "load", new Object[]{"index", index, "length", length});
        }
        if (this.size < -1) {
            this.getSize();
        }
        List<Role> roles = null;
        if (this.fullResults != null) {
            int toIndex = index + length > this.fullResults.size() ? this.fullResults.size() : index + length;
            roles = this.fullResults.subList(index, toIndex);
        } else {
            if (this.group != null) {
                if (this.isMembershipTypeNotUsed() && this.associatedUsers != null && !this.associatedUsers.isEmpty()) {
                    int startAssociatedUsersIndex = 0;
                    int associatedUsersLength = length;
                    if (this.rolesCount > 0) {
                        int startRolesIndex = index;
                        int rolesLength = length;
                        if (index + length <= this.rolesCount) {
                            associatedUsersLength = 0;
                        } else if (index < this.rolesCount && index + length > this.rolesCount) {
                            rolesLength = this.rolesCount - index;
                            startAssociatedUsersIndex = 0;
                            associatedUsersLength = length - rolesLength;
                        } else if (index >= this.rolesCount) {
                            rolesLength = 0;
                            startAssociatedUsersIndex = index - this.rolesCount;
                            associatedUsersLength = length;
                        }
                        if (rolesLength > 0) {
                            IdentitySearchCriteria crit = this.usePaginatedQuery ? new IdentitySearchCriteriaImpl().page(startRolesIndex, rolesLength) : new IdentitySearchCriteriaImpl().page(0, this.size);
                            crit.sort(SortOrder.ASCENDING);
                            roles = new LinkedList<Role>(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.group, null, crit));
                        }
                    }
                    if (roles == null) {
                        roles = new LinkedList<Role>();
                    }
                    if (associatedUsersLength > 0) {
                        List<User> subList = this.associatedUsers.subList(startAssociatedUsersIndex, startAssociatedUsersIndex + associatedUsersLength);
                        for (User user : subList) {
                            roles.add((Role)new SimpleRole((RoleType)new SimpleRoleType("JBOSS_IDENTITY_MEMBERSHIP"), user, this.group));
                        }
                    }
                } else {
                    IdentitySearchCriteria crit = this.usePaginatedQuery ? new IdentitySearchCriteriaImpl().page(index, length) : new IdentitySearchCriteriaImpl().page(0, this.rolesCount);
                    crit.sort(SortOrder.ASCENDING);
                    roles = new LinkedList<Role>(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.group, null, crit));
                }
            } else if (this.user != null) {
                IdentitySearchCriteria crit = this.usePaginatedQuery ? new IdentitySearchCriteriaImpl().page(index, length) : new IdentitySearchCriteriaImpl().page(0, this.size);
                crit.sort(SortOrder.ASCENDING);
                roles = new LinkedList<Role>(this.getIDMService().getIdentitySession().getRoleManager().findRoles((IdentityType)this.user, null, crit));
            }
            if (!this.usePaginatedQuery) {
                this.fullResults = roles;
                int toIndex = index + length > this.fullResults.size() ? this.fullResults.size() : index + length;
                roles = this.fullResults.subList(index, toIndex);
            }
        }
        HashSet<MembershipImpl> memberships = new HashSet<MembershipImpl>();
        for (int i = 0; i < roles.size(); ++i) {
            Role role = roles.get(i);
            Group exoGroup = ((GroupDAOImpl)this.getOrganizationService().getGroupHandler()).convertGroup(role.getGroup());
            MembershipImpl memb = new MembershipImpl();
            memb.setGroupId(exoGroup.getId());
            memb.setUserName(role.getUser().getId());
            if (role.getRoleType().getName().equals("JBOSS_IDENTITY_MEMBERSHIP")) {
                memb.setMembershipType(this.associationMembershipType);
            } else {
                memb.setMembershipType(role.getRoleType().getName());
            }
            memberships.add(memb);
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "load", memberships);
        }
        return memberships.toArray(new Membership[0]);
    }

    public int getSize() throws Exception {
        if (log.isTraceEnabled()) {
            Tools.logMethodIn(log, LogLevel.TRACE, "getSize", null);
        }
        int result = 0;
        if (this.size < 0) {
            if (this.group != null && this.user == null) {
                result = this.rolesCount = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.group, null, null);
                if (this.isMembershipTypeNotUsed()) {
                    Collection associatedUsersCollection = this.getIDMService().getIdentitySession().getRelationshipManager().findAssociatedUsers(this.group, false);
                    this.associatedUsers = associatedUsersCollection == null ? Collections.emptyList() : new LinkedList(associatedUsersCollection);
                    result += this.associatedUsers == null ? 0 : this.associatedUsers.size();
                }
            } else if (this.group == null && this.user != null) {
                result = this.rolesCount = this.getIDMService().getIdentitySession().getRoleManager().getRolesCount((IdentityType)this.user, null, null);
            }
            this.size = result;
        } else {
            result = this.size;
        }
        if (log.isTraceEnabled()) {
            Tools.logMethodOut(log, LogLevel.TRACE, "getSize", result);
        }
        return result;
    }

    PicketLinkIDMService getIDMService() {
        return (PicketLinkIDMService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(PicketLinkIDMService.class);
    }

    PicketLinkIDMOrganizationServiceImpl getOrganizationService() {
        return (PicketLinkIDMOrganizationServiceImpl)((Object)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class));
    }

    private boolean isMembershipTypeNotUsed() {
        return StringUtils.isNotBlank((String)this.groupId) && StringUtils.isNotBlank((String)this.associationMembershipType) && this.getOrganizationService().getConfiguration().isIgnoreMappedMembershipTypeForGroup(this.groupId);
    }
}

