/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.schema;

import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.MultiPartName;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;

public class Column
extends ASTNodeAccessImpl
implements Expression,
MultiPartName {
    private Table table;
    private String columnName;

    public Column() {
    }

    public Column(Table table, String string) {
        this.setTable(table);
        this.setColumnName(string);
    }

    public Column(List<String> list) {
        List<String> list2 = list;
        this(list.size() > 1 ? new Table(list.subList(0, list.size() - 1)) : null, list2.get(list2.size() - 1));
    }

    public Column(String string) {
        this(null, string);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getName(false);
    }

    public String getName(boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.table != null) {
            if (this.table.getAlias() != null && bl2) {
                stringBuilder.append(this.table.getAlias().getName());
            } else {
                stringBuilder.append(this.table.getFullyQualifiedName());
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append('.');
        }
        if (this.columnName != null) {
            stringBuilder.append(this.columnName);
        }
        return stringBuilder.toString();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return this.getName(true);
    }

    public Column withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public Column withColumnName(String string) {
        this.setColumnName(string);
        return this;
    }
}

