/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.portal.controller.resource.script;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.exoplatform.commons.utils.CompositeReader;
import org.exoplatform.commons.utils.PropertyResolverReader;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.controller.QualifiedName;
import org.gatein.portal.controller.resource.ResourceRequestHandler;
import org.gatein.portal.controller.resource.script.ScriptResource;

public abstract class Module {
    private static final Log log = ExoLogger.getLogger(Module.class);
    public static final ResourceBundle.Control CONTROL = new ResourceBundle.Control(){

        @Override
        public Locale getFallbackLocale(String baseName, Locale locale) {
            return locale.equals(Locale.ENGLISH) ? null : Locale.ENGLISH;
        }
    };
    protected static ResourceBundleService resourceBundleService;
    protected ScriptResource resource;
    protected final String contextPath;
    protected int priority;

    Module(ScriptResource resource, String contextPath, int priority) {
        this.resource = resource;
        this.contextPath = contextPath;
        this.priority = priority;
    }

    public ScriptResource getResource() {
        return this.resource;
    }

    public abstract boolean isRemote();

    public abstract String getURI();

    public String getContextPath() {
        return this.contextPath;
    }

    public int getPriority() {
        return this.priority;
    }

    private static String escapeJavascriptStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\'') {
                sb.append("\\'");
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static ResourceBundleService getResourceBundleService() {
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)PortalContainer.getInstance().getComponentInstanceOfType(ResourceBundleService.class);
        }
        return resourceBundleService;
    }

    public static class Local
    extends Module {
        private final Content[] contents;
        private final String resourceBundle;
        private final Map<QualifiedName, String> parameters;
        private final boolean minify;

        Local(ScriptResource resource, String contextPath, String path, String resourceBundle, int priority) {
            this(resource, contextPath, new Content[]{new Content(path)}, resourceBundle, priority);
        }

        Local(ScriptResource resource, String contextPath, Content[] contents, String resourceBundle, int priority) {
            this(resource, contextPath, contents, resourceBundle, priority, true);
        }

        Local(ScriptResource resource, String contextPath, Content[] contents, String resourceBundle, int priority, boolean minify) {
            super(resource, contextPath, priority);
            HashMap<QualifiedName, String> parameters = new HashMap<QualifiedName, String>();
            parameters.put(WebAppController.HANDLER_PARAM, "script");
            parameters.put(ResourceRequestHandler.RESOURCE_QN, resource.getId().getName());
            parameters.put(ResourceRequestHandler.SCOPE_QN, resource.getId().getScope().name());
            if (contents == null) {
                throw new IllegalArgumentException("contents must be not null");
            }
            this.contents = contents;
            this.parameters = parameters;
            this.resourceBundle = resourceBundle;
            this.minify = minify;
        }

        public String getPath() {
            for (Content ct : this.contents) {
                if (!ct.isPath()) continue;
                return ct.getSource();
            }
            return null;
        }

        public Content[] getContents() {
            return this.contents;
        }

        public String getResourceBundle() {
            return this.resourceBundle;
        }

        public Map<QualifiedName, String> getParameters() {
            return this.parameters;
        }

        public boolean isMinify() {
            return this.minify;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public String getURI() {
            return this.contextPath + this.getPath();
        }

        public Reader read(Locale locale, ServletContext scriptLoader, ClassLoader bundleLoader) {
            LinkedList<Reader> readers = new LinkedList<Reader>();
            for (Content content : this.contents) {
                if (content.isPath()) {
                    Reader script = this.getScript(content.getSource(), locale, scriptLoader, bundleLoader);
                    if (script != null) {
                        readers.add(script);
                        continue;
                    }
                    log.warn((Object)("File not found: " + content.getSource()));
                    continue;
                }
                readers.add(new StringReader("\n" + content.getSource() + "\n"));
            }
            if (readers.size() > 0) {
                return new CompositeReader(readers);
            }
            return null;
        }

        private Reader getScript(String pt, Locale locale, ServletContext scriptLoader, ClassLoader bundleLoader) {
            PortalContainer container;
            InputStream in = scriptLoader.getResourceAsStream(pt);
            if (in == null && (container = PortalContainer.getInstanceIfPresent()) != null && container.getPortalContext() != null) {
                in = PortalContainer.getInstance().getPortalContext().getResourceAsStream(pt);
            }
            if (in != null) {
                InputStreamReader reader = new InputStreamReader(in);
                if (this.resourceBundle != null) {
                    ResourceBundle bundle;
                    if (locale == null) {
                        locale = Locale.ENGLISH;
                    }
                    if ((bundle = Local.getResourceBundleService().getResourceBundle(this.resourceBundle, locale, bundleLoader)) == null && (bundle = ResourceBundle.getBundle(this.resourceBundle, locale, bundleLoader, CONTROL)) == null && locale != Locale.ENGLISH) {
                        bundle = ResourceBundle.getBundle(this.resourceBundle, Locale.ENGLISH, bundleLoader, CONTROL);
                    }
                    if (bundle != null) {
                        log.debug((Object)("Found bundle " + bundle + " for locale " + locale + " and bundle " + this.resourceBundle));
                        final ResourceBundle finalBundle = bundle;
                        reader = new PropertyResolverReader(reader){

                            protected String resolve(String name) {
                                try {
                                    String val = finalBundle.getString(name);
                                    return Module.escapeJavascriptStringLiteral(val);
                                }
                                catch (MissingResourceException e) {
                                    log.debug((Object)("Could not resolve property " + name + " when filtering JS"));
                                    return "";
                                }
                            }
                        };
                    }
                }
                return reader;
            }
            return null;
        }

        public static class Content {
            private String source;
            private boolean isPath;

            public Content(String source) {
                this(source, true);
            }

            public Content(String content, boolean isPath) {
                this.source = content;
                this.isPath = isPath;
            }

            public String getSource() {
                return this.source;
            }

            public boolean isPath() {
                return this.isPath;
            }
        }
    }

    public static class Remote
    extends Module {
        private final String uri;

        Remote(ScriptResource resource, String contextPath, String uri, int priority) {
            super(resource, contextPath, priority);
            this.uri = uri;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public String getURI() {
            return this.uri;
        }
    }
}

