/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.common;

import java.nio.ByteBuffer;

public class Z85 {
    private static char[] encodeTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '.', '-', ':', '+', '=', '^', '!', '/', '*', '?', '&', '<', '>', '(', ')', '[', ']', '{', '}', '@', '%', '$', '#'};
    private static final int[] decodeTable = new int[]{0, 68, 0, 84, 83, 82, 72, 0, 75, 76, 70, 65, 0, 63, 62, 69, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 64, 0, 73, 66, 74, 71, 81, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 77, 0, 78, 67, 0, 0, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 79, 0, 80, 0, 0};
    public static Encoder encoder = new Encoder();
    public static Decoder decoder = new Decoder();

    private Z85() {
    }

    public static class Encoder {
        public String encodeBytes(byte[] bytes) {
            int length = bytes.length;
            int remainder = length % 4;
            int padding = 4 - (remainder == 0 ? 4 : remainder);
            StringBuilder result = new StringBuilder();
            long value = 0L;
            for (int i = 0; i < length + padding; ++i) {
                boolean isPadding = i >= length;
                value = value * 256L + (long)(isPadding ? 0 : bytes[i] & 0xFF);
                if ((i + 1) % 4 != 0) continue;
                int divisor = 52200625;
                for (int j = 5; j > 0; --j) {
                    if (!isPadding || j > padding) {
                        int code = (int)(value / (long)divisor % 85L);
                        result.append(encodeTable[code]);
                    }
                    divisor /= 85;
                }
                value = 0L;
            }
            return result.toString();
        }

        public String encodeByteBuffer(ByteBuffer buffer) {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return this.encodeBytes(bytes);
        }
    }

    public static class Decoder {
        public byte[] decodeBytes(String string) {
            int remainder = ((String)string).length() % 5;
            int padding = 5 - (remainder == 0 ? 5 : remainder);
            for (int p = 0; p < padding; ++p) {
                string = (String)string + encodeTable[encodeTable.length - 1];
            }
            int length = ((String)string).length();
            byte[] bytes = new byte[length * 4 / 5 - padding];
            long value = 0L;
            int index = 0;
            for (int i = 0; i < length; ++i) {
                int code = ((String)string).charAt(i) - 32;
                value = value * 85L + (long)decodeTable[code];
                if ((i + 1) % 5 != 0) continue;
                for (int divisor = 0x1000000; divisor >= 1; divisor /= 256) {
                    if (index >= bytes.length) continue;
                    bytes[index++] = (byte)(value / (long)divisor % 256L);
                }
                value = 0L;
            }
            return bytes;
        }

        public ByteBuffer decodeByteBuffer(String string) {
            return ByteBuffer.wrap(this.decodeBytes(string));
        }
    }
}

