/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class UserFilterListAccess
implements ListAccess<User> {
    private static Log LOG = ExoLogger.getExoLogger(UserFilterListAccess.class);
    private IdentityStorage identityStorage;
    private OrganizationService organizationService;
    private ProfileFilter profileFilter;

    public UserFilterListAccess(OrganizationService organizationService, IdentityStorage identityStorage, ProfileFilter profileFilter) {
        this.identityStorage = identityStorage;
        this.organizationService = organizationService;
        this.profileFilter = profileFilter;
    }

    public User[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        List identities = null;
        identities = this.profileFilter.isEmpty() ? this.identityStorage.getIdentities("organization", (long)offset, (long)limit) : this.identityStorage.getIdentitiesForMentions("organization", this.profileFilter, null, (long)offset, (long)limit, false);
        if (identities == null || identities.isEmpty()) {
            return new User[0];
        }
        ArrayList<User> users = new ArrayList<User>();
        boolean i = false;
        for (Identity identity : identities) {
            String userId = identity.getRemoteId();
            User user = this.organizationService.getUserHandler().findUserByName(userId);
            if (user == null) {
                LOG.warn("Can't find user with name '{}'", new Object[]{userId});
                continue;
            }
            users.add(user);
        }
        return users.toArray(new User[0]);
    }

    public int getSize() throws Exception {
        int size = 0;
        size = this.profileFilter.isEmpty() ? this.identityStorage.getIdentitiesByProfileFilterCount("organization", this.profileFilter) : this.identityStorage.getIdentitiesForMentionsCount("organization", this.profileFilter, null);
        return size;
    }
}

