/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.gamification.twitter.service.impl;

import io.meeds.gamification.model.EventDTO;
import io.meeds.gamification.service.EventService;
import io.meeds.gamification.twitter.model.RemoteTwitterAccount;
import io.meeds.gamification.twitter.model.TwitterAccount;
import io.meeds.gamification.twitter.model.TwitterTrigger;
import io.meeds.gamification.twitter.service.TwitterAccountService;
import io.meeds.gamification.twitter.service.TwitterConsumerService;
import io.meeds.gamification.twitter.storage.TwitterAccountStorage;
import io.meeds.gamification.utils.Utils;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.web.security.codec.CodecInitializer;
import org.exoplatform.web.security.security.TokenServiceInitializationException;

public class TwitterAccountServiceImpl
implements TwitterAccountService {
    private static final Scope TWITTER_CONNECTOR_SCOPE = Scope.APPLICATION.id("twitterConnector");
    private static final String BEARER_TOKEN_KEY = "BEARER_TOKEN";
    public static final String ENABLED = ".enabled";
    private final SettingService settingService;
    private final TwitterConsumerService twitterConsumerService;
    private final TwitterAccountStorage twitterAccountStorage;
    private final EventService eventService;
    private final CodecInitializer codecInitializer;

    public TwitterAccountServiceImpl(SettingService settingService, TwitterConsumerService twitterConsumerService, TwitterAccountStorage twitterAccountStorage, EventService eventService, CodecInitializer codecInitializer) {
        this.settingService = settingService;
        this.twitterConsumerService = twitterConsumerService;
        this.twitterAccountStorage = twitterAccountStorage;
        this.eventService = eventService;
        this.codecInitializer = codecInitializer;
    }

    @Override
    public List<TwitterAccount> getTwitterAccounts(String currentUser, int offset, int limit, boolean forceUpdate) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        if (forceUpdate) {
            this.twitterConsumerService.clearCache();
        }
        return this.getTwitterAccounts(offset, limit);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId) {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Twitter account id is mandatory");
        }
        return this.twitterAccountStorage.getTwitterAccountById(accountId);
    }

    @Override
    public TwitterAccount getTwitterAccountById(long accountId, String username) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)username)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched account");
        }
        TwitterAccount twitterAccount = this.getTwitterAccountById(accountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account doesn't exist");
        }
        return twitterAccount;
    }

    @Override
    public List<TwitterAccount> getTwitterAccounts(int offset, int limit) {
        List<Long> hooksIds = this.twitterAccountStorage.getTwitterAccountIds(offset, limit);
        return hooksIds.stream().map(this.twitterAccountStorage::getTwitterAccountById).toList();
    }

    @Override
    public int countTwitterAccounts(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to access Twitter watched accounts");
        }
        return this.twitterAccountStorage.countTwitterAccounts();
    }

    @Override
    public void addTwitterAccount(String twitterUsername, String currentUser) throws ObjectAlreadyExistsException, IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to add a twitter watched account");
        }
        if (this.twitterAccountStorage.countTwitterAccounts() >= 2) {
            throw new IllegalStateException("The maximum number of watched twitter accounts has been reached");
        }
        RemoteTwitterAccount remoteTwitterAccount = this.twitterConsumerService.retrieveTwitterAccount(twitterUsername, this.getTwitterBearerToken(currentUser));
        if (remoteTwitterAccount != null) {
            TwitterAccount existsAccount = this.twitterAccountStorage.getTwitterAccountByRemoteId(remoteTwitterAccount.getId());
            if (existsAccount != null) {
                throw new ObjectAlreadyExistsException((Object)existsAccount);
            }
            TwitterAccount twitterAccount = new TwitterAccount();
            twitterAccount.setIdentifier(remoteTwitterAccount.getUsername());
            twitterAccount.setRemoteId(remoteTwitterAccount.getId());
            twitterAccount.setName(remoteTwitterAccount.getName());
            twitterAccount.setWatchedBy(currentUser);
            List<TwitterTrigger> mentionTriggers = this.twitterConsumerService.getMentionEvents(remoteTwitterAccount.getId(), 0L, this.getTwitterBearerToken());
            if (CollectionUtils.isNotEmpty(mentionTriggers)) {
                twitterAccount.setLastMentionTweetId(mentionTriggers.get(0).getTweetId());
            }
            this.twitterAccountStorage.addTwitterAccount(twitterAccount);
        }
    }

    @Override
    public void deleteTwitterAccount(long twitterAccountId, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter account");
        }
        TwitterAccount twitterAccount = this.twitterAccountStorage.getTwitterAccountById(twitterAccountId);
        if (twitterAccount == null) {
            throw new ObjectNotFoundException("Twitter account with remote id : " + twitterAccountId + " wasn't found");
        }
        this.twitterAccountStorage.deleteTwitterAccount(twitterAccountId);
        this.twitterConsumerService.clearCache(twitterAccount, this.getTwitterBearerToken());
    }

    @Override
    public void saveTwitterBearerToken(String bearerToken, String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to save or update Twitter Bearer Token");
        }
        String encodedBearerToken = this.encode(bearerToken);
        this.settingService.set(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY, SettingValue.create((String)encodedBearerToken));
    }

    @Override
    public void deleteTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to delete Twitter Bearer Token");
        }
        this.settingService.remove(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
    }

    @Override
    public String getTwitterBearerToken(String currentUser) throws IllegalAccessException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to check Twitter Bearer Token status");
        }
        return this.getTwitterBearerToken();
    }

    @Override
    public String getTwitterBearerToken() {
        SettingValue settingValue = this.settingService.get(Context.GLOBAL, TWITTER_CONNECTOR_SCOPE, BEARER_TOKEN_KEY);
        if (settingValue != null && settingValue.getValue() != null && StringUtils.isNotBlank((CharSequence)settingValue.getValue().toString())) {
            return this.decode(settingValue.getValue().toString());
        }
        return null;
    }

    @Override
    public void setEventEnabledForAccount(long eventId, long accountId, boolean enabled, String currentUser) throws IllegalAccessException, ObjectNotFoundException {
        if (!Utils.isRewardingManager((String)currentUser)) {
            throw new IllegalAccessException("The user is not authorized to enable/disable event for watched twitter account");
        }
        EventDTO eventDTO = this.eventService.getEvent(eventId);
        if (eventDTO == null) {
            throw new ObjectNotFoundException("event not found");
        }
        Map eventProperties = eventDTO.getProperties();
        if (eventProperties != null && !eventProperties.isEmpty()) {
            String eventProjectStatus = (String)eventProperties.get(accountId + ENABLED);
            if (StringUtils.isNotBlank((CharSequence)eventProjectStatus)) {
                eventProperties.remove(accountId + ENABLED);
                eventProperties.put(accountId + ENABLED, String.valueOf(enabled));
                eventDTO.setProperties(eventProperties);
            }
        } else {
            HashMap<CallSite, String> properties = new HashMap<CallSite, String>();
            properties.put((CallSite)((Object)(accountId + ENABLED)), String.valueOf(enabled));
            eventDTO.setProperties(properties);
        }
        this.eventService.updateEvent(eventDTO);
    }

    @Override
    public void updateAccountLastMentionTweetId(long accountId, long lastMentionTweetId) throws ObjectNotFoundException {
        if (accountId <= 0L) {
            throw new IllegalArgumentException("Account id must be positive");
        }
        TwitterAccount account = this.twitterAccountStorage.getTwitterAccountById(accountId);
        if (account == null) {
            throw new ObjectNotFoundException("Twitter account with id : " + accountId + " wasn't found");
        }
        this.twitterAccountStorage.updateAccountLastMentionTweetId(accountId, lastMentionTweetId);
    }

    private String encode(String token) {
        try {
            return this.codecInitializer.getCodec().encode(token);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error encrypting token", e);
        }
    }

    private String decode(String encryptedToken) {
        try {
            return this.codecInitializer.getCodec().decode(encryptedToken);
        }
        catch (TokenServiceInitializationException e) {
            throw new IllegalStateException("Error decrypting token", e);
        }
    }
}

