/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.job;

import java.util.List;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.reward.service.RewardReportService;
import org.exoplatform.wallet.service.WalletAccountService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardStatusVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(RewardStatusVerifierJob.class);
    protected ExoContainer container = PortalContainer.getInstance();
    protected RewardReportService rewardReportService;
    protected WalletAccountService walletAccountService;
    protected ListenerService listenerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            Wallet adminWallet = this.getWalletAccountService().getAdminWallet();
            if (!this.getWalletAccountService().isAdminAccountEnabled() || adminWallet == null || adminWallet.getEtherBalance() == null || adminWallet.getEtherBalance() == 0.0 || adminWallet.getTokenBalance() == null || adminWallet.getTokenBalance() == 0.0) {
                return;
            }
            List rewardPeriodsInProgress = this.getRewardReportService().getRewardPeriodsInProgress();
            if (rewardPeriodsInProgress != null && !rewardPeriodsInProgress.isEmpty()) {
                for (RewardPeriod rewardPeriod : rewardPeriodsInProgress) {
                    RewardReport rewardReport;
                    if (this.getRewardReportService().isRewardSendingInProgress() || (rewardReport = this.getRewardReportService().computeRewards(rewardPeriod.getPeriodMedianDate())) == null) continue;
                    if (rewardReport.isCompletelyProceeded()) {
                        this.getListenerService().broadcast("exo.wallet.reward.report.success", (Object)rewardReport, null);
                        this.getRewardReportService().saveRewardReport(rewardReport);
                        continue;
                    }
                    if (rewardReport.getPendingTransactionCount() != 0L || rewardReport.getTokensSent() != 0.0) continue;
                    this.getRewardReportService().saveRewardReport(rewardReport);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending rewards", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private RewardReportService getRewardReportService() {
        if (this.rewardReportService == null) {
            this.rewardReportService = (RewardReportService)CommonsUtils.getService(RewardReportService.class);
        }
        return this.rewardReportService;
    }

    private WalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.walletAccountService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

