/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.persistence.EntityManager;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EntityManagerHolder {
    private static final Log LOG = ExoLogger.getLogger(EntityManagerHolder.class);
    private static final EntityManager EM_PROXY = (EntityManager)Proxy.newProxyInstance(ExoEntityManagerInvocationHandler.class.getClassLoader(), new Class[]{EntityManager.class}, (InvocationHandler)new ExoEntityManagerInvocationHandler());

    public static EntityManager get() {
        return EM_PROXY;
    }

    private static EntityManagerService getService() {
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getService(EntityManagerService.class);
        if (service == null) {
            PortalContainer container = PortalContainer.getInstanceIfPresent();
            if (container != null) {
                service = (EntityManagerService)container.getComponentInstanceOfType(EntityManagerService.class);
            }
            if (service == null) {
                throw new IllegalStateException("Cannot find EntityManagerService instance. This may happen when ExoContainerContext.getCurrentContainer is not set in current thread.");
            }
        }
        return service;
    }

    private static class ExoEntityManagerInvocationHandler
    implements InvocationHandler {
        private ExoEntityManagerInvocationHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean emStarted = false;
            EntityManager entityManager = null;
            EntityManagerService service = EntityManagerHolder.getService();
            try {
                entityManager = service.getEntityManager();
                if (entityManager == null) {
                    LOG.debug((Object)"Injecting new EntityManager");
                    entityManager = service.createEntityManager();
                    emStarted = true;
                } else {
                    LOG.debug((Object)"Using existing EntityManager");
                }
                Object object = method.invoke((Object)entityManager, args);
                return object;
            }
            finally {
                if (emStarted && entityManager != null && !entityManager.getTransaction().isActive()) {
                    LOG.debug((Object)"Closing new EntityManager");
                    service.closeEntityManager();
                }
            }
        }
    }
}

