/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.dao;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerHolder;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.dao.AbstractDAO;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.PageDAOImpl$AjcClosure1;
import org.exoplatform.portal.mop.page.PageKey;
import org.gatein.api.common.Pagination;
import org.gatein.api.page.PageQuery;

public class PageDAOImpl
extends AbstractDAO<PageEntity>
implements PageDAO {
    private static final String SITE_TYPE = "siteType";
    private static final String DISPLAY_NAME = "displayName";
    private static final String NAME = "name";
    private static final String OWNER_ID = "ownerId";
    private static final String OWNER_TYPE = "ownerType";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    public PageEntity findByKey(PageKey pageKey) {
        TypedQuery query = this.getEntityManager().createNamedQuery("PageEntity.findByKey", PageEntity.class);
        SiteKey siteKey = pageKey.getSite();
        query.setParameter(OWNER_TYPE, (Object)siteKey.getType());
        query.setParameter(OWNER_ID, (Object)siteKey.getName());
        query.setParameter(NAME, (Object)pageKey.getName());
        try {
            return (PageEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    @Override
    @ExoTransactional
    public void deleteByOwner(long id) {
        long l = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        Object[] objectArray = new Object[]{this, Conversions.longObject((long)l), joinPoint};
        PageDAOImpl$AjcClosure1 pageDAOImpl$AjcClosure1 = new PageDAOImpl$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(pageDAOImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public ListAccess<PageKey> findByQuery(PageQuery query) {
        TypedQuery<PageKey> q = this.buildQuery(query);
        final List results = q.getResultList();
        return new ListAccess<PageKey>(){

            public int getSize() throws Exception {
                return results.size();
            }

            public PageKey[] load(int offset, int limit) throws Exception {
                if (limit < 0) {
                    limit = this.getSize();
                }
                return results.subList(offset, offset + limit).toArray(new PageKey[limit]);
            }
        };
    }

    public TypedQuery<PageKey> buildQuery(PageQuery query) {
        EntityManager em = EntityManagerHolder.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery criteria = cb.createQuery(PageKey.class);
        Root pageEntity = criteria.from(PageEntity.class);
        Join join = pageEntity.join("owner");
        CriteriaQuery select = criteria.multiselect(new Selection[]{join.get(SITE_TYPE), join.get(NAME), pageEntity.get(NAME)});
        select.distinct(true);
        LinkedList<Predicate> andPredicates = new LinkedList<Predicate>();
        LinkedList<Predicate> orPredicates = new LinkedList<Predicate>();
        if (query.getSiteType() != null && query.getSiteName() != null) {
            if (query.getSiteType() != null) {
                andPredicates.add(cb.equal((Expression)join.get(SITE_TYPE), (Object)this.convertSiteType(query.getSiteType())));
            }
            if (query.getSiteName() != null) {
                andPredicates.add(cb.equal((Expression)join.get(NAME), (Object)query.getSiteName()));
            }
        }
        if (query.getDisplayName() != null) {
            orPredicates.add(cb.like(cb.lower((Expression)pageEntity.get(DISPLAY_NAME)), "%" + query.getDisplayName().toLowerCase() + "%"));
            orPredicates.add(cb.like(cb.lower((Expression)pageEntity.get(NAME)), "%" + query.getDisplayName().toLowerCase() + "%"));
        }
        if (!orPredicates.isEmpty()) {
            select.where(new Predicate[]{cb.and(andPredicates.toArray(new Predicate[andPredicates.size()])), cb.or(orPredicates.toArray(new Predicate[orPredicates.size()]))});
        } else {
            select.where((Expression)cb.and(andPredicates.toArray(new Predicate[andPredicates.size()])));
        }
        TypedQuery typedQuery = em.createQuery(select);
        Pagination pagination = query.getPagination();
        if (pagination != null && pagination.getLimit() > 0) {
            select.orderBy(new Order[]{cb.desc((Expression)join.get(SITE_TYPE)), cb.asc((Expression)join.get(NAME)), cb.asc((Expression)pageEntity.get(NAME))});
            typedQuery.setFirstResult(pagination.getOffset());
            typedQuery.setMaxResults(pagination.getLimit());
        }
        return typedQuery;
    }

    private SiteType convertSiteType(org.gatein.api.site.SiteType siteType) {
        switch (siteType) {
            case SITE: {
                return SiteType.PORTAL;
            }
            case SPACE: {
                return SiteType.GROUP;
            }
        }
        return SiteType.USER;
    }

    static {
        PageDAOImpl.ajc$preClinit();
    }

    static /* synthetic */ void deleteByOwner_aroundBody0(PageDAOImpl ajc$this, long id, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("PageEntity.deleteByOwner");
        query.setParameter(OWNER_ID, (Object)id);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("PageDAOImpl.java", PageDAOImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteByOwner", "org.exoplatform.portal.mop.dao.PageDAOImpl", "long", "id", "", "void"), 58);
    }
}

