/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.notification.impl;

import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.notification.plugin.SocialNotificationUtils;

public class ActivityNotificationImpl
extends ActivityListenerPlugin {
    public void saveActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity originalActivity = (ExoSocialActivity)event.getSource();
        ExoSocialActivity activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(originalActivity.getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.append(SocialNotificationUtils.ORIGINAL_TITLE, (Object)originalActivity.getTitle());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"PostActivityPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"PostActivitySpaceStreamPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityMentionPlugin"))).execute(ctx);
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        Map mentionsTemplateParams = activity.getTemplateParams() != null ? activity.getTemplateParams() : new HashMap();
        activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activity.getId());
        if (mentionsTemplateParams.containsKey("PreviousMentions")) {
            Map templateParams = activity.getTemplateParams() != null ? activity.getTemplateParams() : new HashMap();
            templateParams.put("PreviousMentions", (String)mentionsTemplateParams.get("PreviousMentions"));
            activity.setTemplateParams(templateParams);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"EditActivityPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityMentionPlugin"))).execute(ctx);
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activity.getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"ActivityCommentPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityReplyToCommentPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityMentionPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityCommentWatchPlugin"))).execute(ctx);
    }

    public void updateComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        Map mentionsTemplateParams = activity.getTemplateParams() != null ? activity.getTemplateParams() : new HashMap();
        activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(activity.getId());
        if (mentionsTemplateParams.containsKey("PreviousMentions")) {
            Map templateParams = activity.getTemplateParams() != null ? activity.getTemplateParams() : new HashMap();
            templateParams.put("PreviousMentions", (String)mentionsTemplateParams.get("PreviousMentions"));
            activity.setTemplateParams(templateParams);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"EditCommentPlugin"))).with(ctx.makeCommand(PluginKey.key((String)"ActivityMentionPlugin"))).execute(ctx);
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"LikePlugin"))).execute(ctx);
    }

    public void likeComment(ActivityLifeCycleEvent event) {
        ExoSocialActivity activity = (ExoSocialActivity)event.getSource();
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"LikeCommentPlugin"))).execute(ctx);
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity originalActivity = (ExoSocialActivity)event.getSource();
        ExoSocialActivity activity = ((ActivityManager)CommonsUtils.getService(ActivityManager.class)).getActivity(originalActivity.getId());
        NotificationContext ctx = NotificationContextImpl.cloneInstance().append(SocialNotificationUtils.ACTIVITY, (Object)activity);
        ctx.append(SocialNotificationUtils.ORIGINAL_TITLE, (Object)originalActivity.getTitle());
        ctx.append(SocialNotificationUtils.ORIGINAL_TITLE_SHARED, (Object)originalActivity.getBody());
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"SharedActivitySpaceStreamPlugin"))).execute(ctx);
    }
}

