/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.externalstore;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Set;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.externalstore.model.IDMEntityType;

public interface IDMExternalStoreService {
    public static final String UPDATE_USER_ON_LOGIN_PARAM = "update.user.onlogin";
    public static final DateTimeFormatter LDAP_MODIFICATION_DATE_FORMAT = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4, 10, SignStyle.NEVER).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final String USER_AUTHENTICATED_USING_EXTERNAL_STORE = "exo.idm.externalStore.user.authenticated";
    public static final String USER_DELETED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.user.deleted";
    public static final String USER_ADDED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.user.new";
    public static final String USER_MODIFIED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.user.modified";
    public static final String GROUP_DELETED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.group.deleted";
    public static final String GROUP_ADDED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.group.new";
    public static final String GROUP_MODIFIED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.group.modified";
    public static final String USER_PROFILE_ADDED_FROM_EXTERNAL_STORE = "exo.idm.externalStore.user.profile.new";

    public boolean authenticate(String var1, String var2) throws Exception;

    public ListAccess<String> getAllOfType(IDMEntityType<?> var1, LocalDateTime var2) throws Exception;

    default public ListAccess<User> getAllInternalUsers() throws Exception {
        return this.getOrganizationService().getUserHandler().findAllUsers();
    }

    public <T> T getEntity(IDMEntityType<T> var1, Object var2) throws Exception;

    public boolean isEntityModified(IDMEntityType<?> var1, String var2) throws Exception;

    default public boolean isEntityPresent(IDMEntityType<?> entityType, Object entityId) throws Exception {
        return this.getEntity(entityType, entityId) != null;
    }

    public Set<IDMEntityType<?>> getManagedEntityTypes();

    public boolean isEnabled();

    public boolean isUpdateInformationOnLogin();

    public OrganizationService getOrganizationService();
}

