/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.config.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalRedirect;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.config.model.RedirectCondition;
import org.exoplatform.portal.config.model.RedirectMappings;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.pom.config.Utils;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.pom.data.RedirectConditionData;
import org.exoplatform.portal.pom.data.RedirectData;
import org.exoplatform.portal.pom.data.RedirectMappingsData;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class PortalConfig
extends ModelObject
implements Cloneable,
IUnmarshallable,
IMarshallable {
    public static final String USER_TYPE = SiteType.USER.getName();
    public static final String GROUP_TYPE = SiteType.GROUP.getName();
    public static final String PORTAL_TYPE = SiteType.PORTAL.getName();
    public static final String SPACE_TYPE = SiteType.SPACE.getName();
    public static final Container DEFAULT_LAYOUT = PortalConfig.initDefaultLayout();
    private String name;
    private String type;
    private String locale;
    private String label;
    private String description;
    private String[] accessPermissions;
    private String editPermission;
    private Properties properties;
    private String skin;
    private Container portalLayout;
    private boolean defaultLayout;
    private transient boolean modifiable;
    private boolean displayed = true;
    private int displayOrder;
    private String bannerUploadId;
    private long bannerFileId;
    private ArrayList<PortalRedirect> portalRedirects;
    public static final String JiBX_bindingList = "|org.exoplatform.portal.application.JiBX_bindingFactory|";

    public PortalConfig() {
        this(PORTAL_TYPE);
    }

    public PortalConfig(String type) {
        this(type, null);
    }

    public PortalConfig(String type, String ownerId) {
        this(type, ownerId, null);
    }

    public PortalConfig(String type, String ownerId, String storageId) {
        super(storageId);
        this.type = type;
        this.name = ownerId;
        this.portalLayout = new Container();
    }

    public PortalConfig(PortalData data) {
        super(data.getStorageId());
        this.name = data.getName();
        this.type = data.getType();
        this.locale = data.getLocale();
        this.label = data.getLabel();
        this.description = data.getDescription();
        this.accessPermissions = data.getAccessPermissions().toArray(new String[data.getAccessPermissions().size()]);
        this.editPermission = data.getEditPermission();
        this.properties = data.getProperties() == null ? new Properties() : new Properties(data.getProperties());
        this.skin = data.getSkin();
        this.portalLayout = new Container(data.getPortalLayout());
        this.defaultLayout = data.isDefaultLayout();
        this.portalRedirects = this.buildPortalRedirects(data.getRedirects());
        this.displayed = data.isDisplayed();
        this.displayOrder = data.getDisplayOrder();
        this.bannerFileId = data.getBannerFileId();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String[] getAccessPermissions() {
        return this.accessPermissions;
    }

    public void setAccessPermissions(String[] s) {
        this.accessPermissions = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public Container getPortalLayout() {
        return this.portalLayout;
    }

    public void setPortalLayout(Container container) {
        this.portalLayout = container;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public void setModifiable(boolean b) {
        this.modifiable = b;
    }

    public boolean isDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(boolean defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public void setPortalRedirects(ArrayList<PortalRedirect> portalRedirects) {
        this.portalRedirects = portalRedirects;
    }

    public ArrayList<PortalRedirect> getPortalRedirects() {
        if (this.portalRedirects == null) {
            this.portalRedirects = new ArrayList();
        }
        return this.portalRedirects;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null || !this.properties.containsKey(name)) {
            return null;
        }
        return (String)this.properties.get(name);
    }

    public String getProperty(String name, String defaultValue) {
        if ("cacheControl".equals(name)) {
            return "no-cache";
        }
        if ("sharedLayout".equals(name)) {
            return "allUsers";
        }
        if ("viewport".equals(name)) {
            return null;
        }
        String value = this.getProperty(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.setProperty(name, value);
    }

    public void removeProperty(String name) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.remove(name);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    public Boolean isShowInfobar() {
        String value = this.getProperty("showPortletInfo", "1");
        if (Integer.parseInt(value) == 1) {
            return true;
        }
        return false;
    }

    public void setShowInfobar(Boolean value) {
        if (value.booleanValue()) {
            this.setProperty("showPortletInfo", "1");
        } else {
            this.setProperty("showPortletInfo", "0");
        }
    }

    public String getViewport() {
        return this.getProperty("viewport");
    }

    public void setViewport(String viewport) {
        this.setProperty("viewport", viewport);
    }

    public String getSharedLayout() {
        return this.getProperty("sharedLayout", "allUsers");
    }

    public void setSharedLayout(String type) {
        if (type.equals("adminsOnly")) {
            this.setProperty("sharedLayout", "adminsOnly");
        } else {
            this.setProperty("sharedLayout", "allUsers");
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean isDisplayed() {
        return this.displayed;
    }

    public void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public String getBannerUploadId() {
        return this.bannerUploadId;
    }

    public void setBannerUploadId(String bannerUploadId) {
        this.bannerUploadId = bannerUploadId;
    }

    public long getBannerFileId() {
        return this.bannerFileId;
    }

    public void setBannerFileId(long bannerFileId) {
        this.bannerFileId = bannerFileId;
    }

    public String toString() {
        return "PortalConfig[name=" + this.name + ",type=" + this.type + "]";
    }

    public PortalConfig clone() {
        try {
            return (PortalConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return new PortalConfig(this.build());
        }
    }

    private static Container initDefaultLayout() {
        Container container = new Container();
        ArrayList<ModelObject> children = new ArrayList<ModelObject>();
        children.add(new PageBody());
        container.setChildren(children);
        return container;
    }

    @Override
    public PortalData build() {
        List<String> accessPermissions = Utils.safeImmutableList(this.accessPermissions);
        Map<String, String> properties = Utils.safeImmutableMap(this.properties);
        return new PortalData(this.storageId, this.name, this.type, this.locale, this.label, this.description, accessPermissions, this.editPermission, properties, this.skin, this.portalLayout.build(), this.defaultLayout, this.buildRedirectData(), this.displayed, this.displayOrder, this.bannerFileId);
    }

    private ArrayList<RedirectData> buildRedirectData() {
        if (this.portalRedirects != null) {
            ArrayList<RedirectData> redirects = new ArrayList<RedirectData>();
            for (PortalRedirect portalRedirect : this.portalRedirects) {
                redirects.add(portalRedirect.build());
            }
            return redirects;
        }
        return null;
    }

    private ArrayList<PortalRedirect> buildPortalRedirects(List<RedirectData> redirectsData) {
        if (redirectsData != null) {
            ArrayList<PortalRedirect> portalRedirects = new ArrayList<PortalRedirect>();
            for (RedirectData redirectData : redirectsData) {
                PortalRedirect portalRedirect = new PortalRedirect();
                portalRedirect.setName(redirectData.getRedirectName());
                portalRedirect.setRedirectSite(redirectData.getRedirectSiteName());
                portalRedirect.setEnabled(redirectData.isEnabled());
                portalRedirect.setConditions(this.buildRedirectConditions(redirectData.getConditions()));
                portalRedirect.setMappings(this.buildRedirectMappings(redirectData.getMappings()));
                portalRedirects.add(portalRedirect);
            }
            return portalRedirects;
        }
        return null;
    }

    private ArrayList<RedirectCondition> buildRedirectConditions(List<RedirectConditionData> conditionsData) {
        ArrayList<RedirectCondition> redirectConditions = new ArrayList<RedirectCondition>();
        for (RedirectConditionData conditionData : conditionsData) {
            RedirectCondition redirectCondition = conditionData.build();
            redirectConditions.add(redirectCondition);
        }
        return redirectConditions;
    }

    private RedirectMappings buildRedirectMappings(RedirectMappingsData mappingsData) {
        if (mappingsData != null) {
            return mappingsData.build();
        }
        return null;
    }

    public void useDefaultPortalLayout() {
        this.setPortalLayout(PortalConfig.initDefaultLayout());
        this.setDefaultLayout(true);
    }

    public /* synthetic */ void JiBX_access_store_name_2_0(String arg1) {
        this.name = arg1;
    }

    public /* synthetic */ void JiBX_access_store_label_2_0(String arg1) {
        this.label = arg1;
    }

    public /* synthetic */ void JiBX_access_store_description_2_0(String arg1) {
        this.description = arg1;
    }

    public /* synthetic */ void JiBX_access_store_locale_2_0(String arg1) {
        this.locale = arg1;
    }

    public /* synthetic */ void JiBX_access_store_accessPermissions_2_0(String[] arg1) {
        this.accessPermissions = arg1;
    }

    public /* synthetic */ void JiBX_access_store_editPermission_2_0(String arg1) {
        this.editPermission = arg1;
    }

    public /* synthetic */ void JiBX_access_store_skin_2_0(String arg1) {
        this.skin = arg1;
    }

    public /* synthetic */ void JiBX_access_store_displayed_2_0(boolean arg1) {
        this.displayed = arg1;
    }

    public /* synthetic */ void JiBX_access_store_displayOrder_2_0(int arg1) {
        this.displayOrder = arg1;
    }

    public /* synthetic */ Properties JiBX_access_load_properties_2_0() {
        return this.properties;
    }

    public /* synthetic */ void JiBX_access_store_properties_2_0(Properties arg1) {
        this.properties = arg1;
    }

    public /* synthetic */ Container JiBX_access_load_portalLayout_2_0() {
        return this.portalLayout;
    }

    public /* synthetic */ void JiBX_access_store_portalLayout_2_0(Container arg1) {
        this.portalLayout = arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.exoplatform.portal.config.model.PortalConfig").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.exoplatform.portal.config.model.PortalConfig";
    }

    public /* synthetic */ String JiBX_access_load_name_2_0() {
        return this.name;
    }

    public /* synthetic */ String JiBX_access_load_label_2_0() {
        return this.label;
    }

    public /* synthetic */ String JiBX_access_load_description_2_0() {
        return this.description;
    }

    public /* synthetic */ String JiBX_access_load_locale_2_0() {
        return this.locale;
    }

    public /* synthetic */ String[] JiBX_access_load_accessPermissions_2_0() {
        return this.accessPermissions;
    }

    public /* synthetic */ String JiBX_access_load_editPermission_2_0() {
        return this.editPermission;
    }

    public /* synthetic */ String JiBX_access_load_skin_2_0() {
        return this.skin;
    }

    public /* synthetic */ boolean JiBX_access_load_displayed_2_0() {
        return this.displayed;
    }

    public /* synthetic */ int JiBX_access_load_displayOrder_2_0() {
        return this.displayOrder;
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.exoplatform.portal.config.model.PortalConfig").marshal((Object)this, arg1);
    }

    public static class PortalConfigSet {
        private ArrayList<PortalConfig> portalConfigs;

        public ArrayList<PortalConfig> getPortalConfigs() {
            return this.portalConfigs;
        }

        public void setPortalConfigs(ArrayList<PortalConfig> list) {
            this.portalConfigs = list;
        }
    }
}

