/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.rest;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.resources.ResourceBundleService;

public class UserFieldValidator {
    private static final int DEFAULT_MIN_LENGTH = 3;
    private static final int DEFAULT_MAX_LENGTH = 255;
    private static final int MAX_FIELD_LENGTH = 255;
    public static final String DEFAULT_MAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String KEY_PREFIX = "gatein.validators.";
    private static final String ALLOWED_SYMBOLS = "'_', '.'";
    private static ResourceBundleService resourceBundleService;
    private int minLength = 3;
    private int maxLength = 255;
    private boolean usernameValidation = false;
    private boolean personalNameValidation = false;
    private boolean emailValidation = false;
    private boolean passwordValidation = false;
    private String field = null;
    private String pattern = null;
    private String formatMessage = null;

    public UserFieldValidator(String field, boolean usernameValidation, boolean personalNameValidation) {
        this(field, usernameValidation, personalNameValidation, 3, 255);
    }

    public UserFieldValidator(String field, boolean usernameValidation, boolean personalNameValidation, int defaultMin, int defaultMax) {
        this.field = field;
        this.usernameValidation = usernameValidation;
        this.personalNameValidation = personalNameValidation;
        this.emailValidation = StringUtils.contains((CharSequence)this.field, (CharSequence)"email");
        this.passwordValidation = StringUtils.contains((CharSequence)this.field, (CharSequence)"password");
        String prefixedKey = KEY_PREFIX + field;
        this.pattern = PropertyManager.getProperty((String)(prefixedKey + ".regexp"));
        this.formatMessage = PropertyManager.getProperty((String)(prefixedKey + ".format.message"));
        if (this.emailValidation && StringUtils.isBlank((CharSequence)this.pattern)) {
            this.pattern = DEFAULT_MAIL_REGEX;
        }
        String minProperty = PropertyManager.getProperty((String)(prefixedKey + ".length.min"));
        String maxProperty = PropertyManager.getProperty((String)(prefixedKey + ".length.max"));
        this.minLength = StringUtils.isNotBlank((CharSequence)minProperty) ? Integer.valueOf(minProperty) : defaultMin;
        this.maxLength = StringUtils.isNotBlank((CharSequence)maxProperty) ? Integer.valueOf(maxProperty) : defaultMax;
        if (this.maxLength > 255) {
            this.maxLength = 255;
        }
    }

    public String validate(Locale locale, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            String label = this.getFieldLabel(locale);
            return UserFieldValidator.getLabel(locale, "EmptyFieldValidator.msg.empty-input", label);
        }
        char[] buff = value.toCharArray();
        if (!(buff.length >= this.minLength && buff.length <= this.maxLength || this.passwordValidation)) {
            String label = this.getFieldLabel(locale);
            return UserFieldValidator.getLabel(locale, "StringLengthValidator.msg.length-invalid", label, this.minLength, this.maxLength);
        }
        if (StringUtils.isNotBlank((CharSequence)this.pattern) && !Pattern.matches(this.pattern, value)) {
            if (StringUtils.isNotBlank((CharSequence)this.formatMessage)) {
                return this.formatMessage;
            }
            if (this.emailValidation) {
                return UserFieldValidator.getLabel(locale, "EmailAddressValidator.msg.Invalid-input", new Object[0]);
            }
            String label = this.getFieldLabel(locale);
            return UserFieldValidator.getLabel(locale, "ExpressionValidator.msg.value-invalid", label, this.pattern);
        }
        if (this.personalNameValidation) {
            for (int i = 0; i < buff.length - 1; ++i) {
                char c = buff[i];
                if (Character.isLetter(c) || Character.isSpaceChar(c) || c == '\'' || c == '-') continue;
                String label = this.getFieldLabel(locale);
                return UserFieldValidator.getLabel(locale, "PersonalNameValidator.msg.Invalid-char", label);
            }
        } else if (this.usernameValidation) {
            if (!UserFieldValidator.isLowerCaseLetterOrDigit(buff[0])) {
                String label = this.getFieldLabel(locale);
                return UserFieldValidator.getLabel(locale, "FirstCharacterUsernameValidator.msg", label);
            }
            char c = buff[buff.length - 1];
            if (!UserFieldValidator.isLowerCaseLetterOrDigit(c)) {
                String label = this.getFieldLabel(locale);
                return UserFieldValidator.getLabel(locale, "LastCharacterUsernameValidator.msg", label, String.valueOf(c));
            }
            for (int i = 1; i < buff.length - 1; ++i) {
                c = buff[i];
                if (UserFieldValidator.isLowerCaseLetterOrDigit(c)) continue;
                if (UserFieldValidator.isSymbol(c)) {
                    char next = buff[i + 1];
                    if (UserFieldValidator.isSymbol(next)) {
                        String label = this.getFieldLabel(locale);
                        return UserFieldValidator.getLabel(locale, "ConsecutiveSymbolValidator.msg", label, ALLOWED_SYMBOLS);
                    }
                    if (Character.isLetterOrDigit(next)) continue;
                    String label = this.getFieldLabel(locale);
                    return UserFieldValidator.getLabel(locale, "UsernameValidator.msg.Invalid-char", label);
                }
                String label = this.getFieldLabel(locale);
                return UserFieldValidator.getLabel(locale, "UsernameValidator.msg.Invalid-char", label);
            }
        } else if (this.passwordValidation) {
            String regexProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.regexp");
            String maxLengthProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.max");
            String minLengthProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.length.min");
            Pattern customPasswordPattern = null;
            int customPasswordMaxlength = -1;
            int customPasswordMinlength = -1;
            if (StringUtils.isNotBlank((CharSequence)regexProperty)) {
                customPasswordPattern = Pattern.compile(regexProperty);
            }
            customPasswordMaxlength = StringUtils.isNotBlank((CharSequence)maxLengthProperty) ? Integer.parseInt(maxLengthProperty) : this.maxLength;
            customPasswordMinlength = StringUtils.isNotBlank((CharSequence)minLengthProperty) ? Integer.parseInt(minLengthProperty) : this.minLength;
            if (customPasswordPattern != null && !customPasswordPattern.matcher(value).matches() || customPasswordMaxlength != -1 && customPasswordMaxlength < value.length() || customPasswordMinlength != -1 && customPasswordMinlength > value.length()) {
                String passwordPolicyProperty = PropertyManager.getProperty((String)"gatein.validators.passwordpolicy.format.message");
                return passwordPolicyProperty != null ? passwordPolicyProperty : UserFieldValidator.getLabel(locale, "onboarding.login.passwordCondition", new Object[0]);
            }
        }
        return null;
    }

    public String getField() {
        return this.field;
    }

    public boolean isEmailValidation() {
        return this.emailValidation;
    }

    public boolean isPersonalNameValidation() {
        return this.personalNameValidation;
    }

    public boolean isUsernameValidation() {
        return this.usernameValidation;
    }

    private String getFieldLabel(Locale locale) {
        String label = UserFieldValidator.getLabel(locale, "UIRegisterForm.label." + this.field, new Object[0]);
        return label == null ? null : label.replace(" :", "").replace(":", "");
    }

    private static boolean isLowerCaseLetterOrDigit(char character) {
        return Character.isDigit(character) || character >= 'a' && character <= 'z';
    }

    private static boolean isSymbol(char c) {
        return c == '_' || c == '.' || c == '-';
    }

    private static String getLabel(Locale locale, String key, Object ... values) {
        ResourceBundle resourceBundle = UserFieldValidator.getResourceBundle(locale);
        if (resourceBundle == null || !resourceBundle.containsKey(key)) {
            resourceBundle = UserFieldValidator.getResourceBundle(Locale.ENGLISH);
        }
        if (resourceBundle != null && resourceBundle.containsKey(key)) {
            String label = resourceBundle.getString(key);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    String messageArg = String.valueOf(values[i]);
                    if (messageArg == null) continue;
                    label = label.replace("{" + i + "}", messageArg);
                }
            }
            return label;
        }
        return key;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        return UserFieldValidator.getResourceBundleService().getResourceBundle(UserFieldValidator.getResourceBundleService().getSharedResourceBundleNames(), locale);
    }

    private static ResourceBundleService getResourceBundleService() {
        if (resourceBundleService == null) {
            resourceBundleService = (ResourceBundleService)ExoContainerContext.getService(ResourceBundleService.class);
        }
        return resourceBundleService;
    }
}

