/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class CssClass
extends ElementSubsequent {
    private InterpolableName name;
    private String cachedName;
    private String cachedFullName;

    public CssClass(HiddenTokenAwareTree token, InterpolableName name) {
        super(token);
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.cachedName != null) {
            return this.cachedName;
        }
        String result = this.name.getName();
        if (!this.isInterpolated()) {
            this.cachedName = result;
        }
        return result;
    }

    @Override
    public String getFullName() {
        if (this.cachedFullName != null) {
            return this.cachedFullName;
        }
        String result = "." + this.getName();
        if (!this.isInterpolated()) {
            this.cachedFullName = result;
        }
        return result;
    }

    @Override
    public boolean isInterpolated() {
        return this.name.isInterpolated();
    }

    @Override
    public void extendName(String extension) {
        this.name.extendName(extension);
        this.cachedName = null;
        this.cachedFullName = null;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.CSS_CLASS;
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.name);
    }

    @Override
    public CssClass clone() {
        CssClass clone = (CssClass)super.clone();
        clone.name = this.name.clone();
        clone.configureParentToAllChilds();
        return clone;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CssClass [");
        builder.append(this.getFullName());
        builder.append("]");
        return builder.toString();
    }
}

