/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.pom.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.exoplatform.portal.config.model.DevicePropertyCondition;
import org.exoplatform.portal.config.model.RedirectCondition;
import org.exoplatform.portal.pom.data.ComponentData;
import org.exoplatform.portal.pom.data.RedirectDevicePropertyConditionData;
import org.exoplatform.portal.pom.data.RedirectUserAgentConditionData;

public class RedirectConditionData
extends ComponentData {
    protected String redirectName;
    protected RedirectUserAgentConditionData userAgentConditionData;
    protected List<RedirectDevicePropertyConditionData> devicePropertyConditionData;

    public RedirectConditionData(String storageId, String storageName, String redirectName) {
        super(storageId, null);
        this.redirectName = redirectName;
    }

    public String getRedirectName() {
        return this.redirectName;
    }

    public void setRedirectName(String redirectName) {
        this.redirectName = redirectName;
    }

    public RedirectUserAgentConditionData getUserAgentConditionData() {
        return this.userAgentConditionData;
    }

    public void setUserAgentConditionData(RedirectUserAgentConditionData userAgentConditionData) {
        this.userAgentConditionData = userAgentConditionData;
    }

    public List<RedirectDevicePropertyConditionData> getDevicePropertyConditionData() {
        if (this.devicePropertyConditionData == null) {
            this.devicePropertyConditionData = new ArrayList<RedirectDevicePropertyConditionData>();
        }
        return this.devicePropertyConditionData;
    }

    public RedirectCondition build() {
        RedirectCondition redirectCondition = new RedirectCondition();
        redirectCondition.setName(this.redirectName);
        redirectCondition.setStorageName(this.getStorageName());
        if (this.devicePropertyConditionData != null) {
            ArrayList<DevicePropertyCondition> devicePropertyConditions = new ArrayList<DevicePropertyCondition>();
            for (RedirectDevicePropertyConditionData conditionData : this.devicePropertyConditionData) {
                devicePropertyConditions.add(conditionData.build());
            }
            redirectCondition.setDeviceProperties(devicePropertyConditions);
        }
        if (this.userAgentConditionData != null) {
            redirectCondition.setUserAgentConditions(this.userAgentConditionData.build());
        }
        return redirectCondition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedirectConditionData)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RedirectConditionData that = (RedirectConditionData)o;
        return Objects.equals(this.redirectName, that.redirectName) && Objects.equals(this.userAgentConditionData, that.userAgentConditionData) && Objects.equals(this.devicePropertyConditionData, that.devicePropertyConditionData);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.redirectName, this.userAgentConditionData, this.devicePropertyConditionData);
    }
}

