/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.api.RuleListener;
import com.datical.liquibase.ext.rules.api.RulesEngine;
import com.datical.liquibase.ext.rules.api.RulesEngineListener;
import com.datical.liquibase.ext.rules.api.RulesEngineParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRulesEngine
implements RulesEngine {
    RulesEngineParameters parameters;
    List<RuleListener> ruleListeners;
    List<RulesEngineListener> rulesEngineListeners;

    AbstractRulesEngine() {
        this(new RulesEngineParameters());
    }

    AbstractRulesEngine(RulesEngineParameters rulesEngineParameters) {
        this.parameters = rulesEngineParameters;
        this.ruleListeners = new ArrayList<RuleListener>();
        this.rulesEngineListeners = new ArrayList<RulesEngineListener>();
    }

    @Override
    public RulesEngineParameters getParameters() {
        return new RulesEngineParameters(this.parameters.isSkipOnFirstAppliedRule(), this.parameters.isSkipOnFirstFailedRule(), this.parameters.isSkipOnFirstNonTriggeredRule(), this.parameters.getPriorityThreshold());
    }

    @Override
    public List<RuleListener> getRuleListeners() {
        return Collections.unmodifiableList(this.ruleListeners);
    }

    @Override
    public List<RulesEngineListener> getRulesEngineListeners() {
        return Collections.unmodifiableList(this.rulesEngineListeners);
    }

    public void registerRuleListener(RuleListener ruleListener) {
        this.ruleListeners.add(ruleListener);
    }

    public void registerRuleListeners(List<RuleListener> list) {
        this.ruleListeners.addAll(list);
    }

    public void registerRulesEngineListener(RulesEngineListener rulesEngineListener) {
        this.rulesEngineListeners.add(rulesEngineListener);
    }

    public void registerRulesEngineListeners(List<RulesEngineListener> list) {
        this.rulesEngineListeners.addAll(list);
    }
}

