/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.gamification.github.storage.cached;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.gamification.github.model.RemoteOrganization;
import org.exoplatform.gamification.github.model.RemoteRepository;
import org.exoplatform.gamification.github.model.TokenStatus;
import org.exoplatform.gamification.github.model.WebHook;
import org.exoplatform.gamification.github.storage.GithubConsumerStorage;
import org.exoplatform.gamification.github.storage.cached.model.CacheKey;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class GithubConsumerCachedStorage
extends GithubConsumerStorage {
    public static final String GITHUB_CACHE_NAME = "github.connector";
    private static final int ORG_REPOS_CONTEXT = 0;
    private static final int ORG_BY_ID_CONTEXT = 1;
    private static final int TOKEN_STATUS_CONTEXT = 2;
    private final FutureExoCache<Serializable, Object, CacheKey> githubFutureCache;

    public GithubConsumerCachedStorage(CacheService cacheService) {
        ExoCache cacheInstance = cacheService.getCacheInstance(GITHUB_CACHE_NAME);
        this.githubFutureCache = new FutureExoCache((context, key) -> {
            if (0 == context.getContext()) {
                return GithubConsumerCachedStorage.super.retrieveOrganizationRepos(context.getOrganizationName(), context.getAccessToken(), context.getPage(), context.getPerPage(), context.getKeyword());
            }
            if (1 == context.getContext()) {
                return GithubConsumerCachedStorage.super.retrieveRemoteOrganization(context.getOrganizationId(), context.getAccessToken());
            }
            if (2 == context.getContext()) {
                return GithubConsumerCachedStorage.super.checkGitHubTokenStatus(context.getAccessToken());
            }
            throw new UnsupportedOperationException();
        }, cacheInstance);
    }

    @Override
    public String deleteWebhookHook(WebHook webHook) {
        try {
            String string = super.deleteWebhookHook(webHook);
            return string;
        }
        finally {
            this.clearCache(webHook);
        }
    }

    @Override
    public List<RemoteRepository> retrieveOrganizationRepos(String organizationName, String accessToken, int page, int perPage, String keyword) {
        CacheKey cacheKey = new CacheKey(0, organizationName, accessToken, page, perPage, keyword);
        List remoteRepositories = (List)this.githubFutureCache.get((Object)cacheKey, (Object)cacheKey.hashCode());
        return remoteRepositories == null ? Collections.emptyList() : remoteRepositories;
    }

    @Override
    public RemoteOrganization retrieveRemoteOrganization(long organizationId, String accessToken) {
        CacheKey cacheKey = new CacheKey(1, organizationId, accessToken);
        return (RemoteOrganization)this.githubFutureCache.get((Object)cacheKey, (Object)cacheKey.hashCode());
    }

    @Override
    public TokenStatus checkGitHubTokenStatus(String token) {
        CacheKey cacheKey = new CacheKey(2, token);
        return (TokenStatus)this.githubFutureCache.get((Object)cacheKey, (Object)cacheKey.hashCode());
    }

    @Override
    public void clearCache() {
        this.githubFutureCache.clear();
    }

    @Override
    public void clearCache(WebHook webHook) {
        this.githubFutureCache.remove((Serializable)Integer.valueOf(new CacheKey(1, webHook.getOrganizationId(), webHook.getToken()).hashCode()));
        this.githubFutureCache.remove((Serializable)Integer.valueOf(new CacheKey(2, webHook.getToken()).hashCode()));
    }
}

