/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.social.translation.storage;

import io.meeds.social.translation.model.TranslationField;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataKey;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;

public class TranslationStorage {
    private static final Log LOG = ExoLogger.getLogger(TranslationStorage.class);
    private static final String LABEL_PROPERTY_NAME = "label";
    private static final String LOCALE_PROPERTY_NAME = "locale";
    public static final MetadataType METADATA_TYPE = new MetadataType(255L, "translation");
    private MetadataService metadataService;

    public TranslationStorage(MetadataService metadataService) {
        this.metadataService = metadataService;
    }

    public TranslationField getTranslationField(String objectType, long objectId, String fieldName) {
        Map<Locale, String> labels = this.getLabels(objectType, objectId, fieldName);
        return new TranslationField(objectType, objectId, fieldName, labels, System.currentTimeMillis());
    }

    public Map<Locale, String> getTranslationLabels(String objectType, long objectId, String fieldName) {
        return this.getTranslationField(objectType, objectId, fieldName).getLabels();
    }

    public String getTranslationLabel(String objectType, long objectId, String fieldName, Locale locale) {
        return this.getTranslationLabels(objectType, objectId, fieldName).get(locale);
    }

    public void saveTranslationLabels(String objectType, long objectId, String fieldName, Map<Locale, String> labels, long audienceId, long spaceId) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(fieldName, METADATA_TYPE.getName(), objectType, String.valueOf(objectId), 0L, -1L);
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            metadataItems.stream().map(MetadataItem::getId).forEach(id -> {
                try {
                    this.metadataService.deleteMetadataItem(id.longValue(), false);
                }
                catch (ObjectNotFoundException e) {
                    LOG.debug("Metadata Item with id {} not found, ignore deleting it", new Object[]{id, e});
                }
            });
        }
        labels.forEach((locale, label) -> this.createMetadataItem(this.getMetadataKey(fieldName, audienceId), this.getMetadataObject(objectType, objectId, spaceId), (Locale)locale, (String)label));
    }

    public void saveTranslationLabel(String objectType, long objectId, String fieldName, Locale locale, String label, long audienceId, long spaceId) {
        Map<Locale, String> translationLabels = this.getTranslationLabels(objectType, objectId, fieldName);
        translationLabels.put(locale, label);
        this.saveTranslationLabels(objectType, objectId, fieldName, translationLabels, audienceId, spaceId);
    }

    public void deleteTranslationLabels(String objectType, long objectId) {
        this.metadataService.deleteMetadataItemsByMetadataTypeAndObject(METADATA_TYPE.getName(), this.getMetadataObject(objectType, objectId, 0L));
    }

    public void deleteTranslationLabel(String objectType, long objectId, String fieldName, Locale locale) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(fieldName, METADATA_TYPE.getName(), objectType, String.valueOf(objectId), 0L, -1L);
        if (CollectionUtils.isNotEmpty((Collection)metadataItems)) {
            metadataItems.stream().filter(item -> MapUtils.isNotEmpty((Map)item.getProperties()) && StringUtils.equals((CharSequence)((CharSequence)item.getProperties().get(LOCALE_PROPERTY_NAME)), (CharSequence)locale.toLanguageTag())).map(MetadataItem::getId).forEach(id -> {
                try {
                    this.metadataService.deleteMetadataItem(id.longValue(), false);
                }
                catch (ObjectNotFoundException e) {
                    LOG.debug("Metadata Item with id {} not found, ignore deleting it", new Object[]{id, e});
                }
            });
        }
    }

    private void createMetadataItem(MetadataKey metadataKey, MetadataObject metadataObject, Locale locale, String label) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put(LOCALE_PROPERTY_NAME, locale.toLanguageTag());
            properties.put(LABEL_PROPERTY_NAME, label);
            this.metadataService.createMetadataItem(metadataObject, metadataKey, properties);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("An error occurred while saving metadata items of %s with id %s", metadataKey.getName(), metadataObject.getId()), e);
        }
    }

    private MetadataKey getMetadataKey(String fieldName, long audienceId) {
        return new MetadataKey(METADATA_TYPE.getName(), fieldName, audienceId);
    }

    private MetadataObject getMetadataObject(String objectType, long objectId, long spaceId) {
        return new MetadataObject(objectType, String.valueOf(objectId), null, spaceId);
    }

    private Map<Locale, String> getLabels(String objectType, long objectId, String fieldName) {
        List metadataItems = this.metadataService.getMetadataItemsByMetadataNameAndTypeAndObject(fieldName, METADATA_TYPE.getName(), objectType, String.valueOf(objectId), 0L, -1L);
        if (CollectionUtils.isEmpty((Collection)metadataItems)) {
            return new HashMap<Locale, String>();
        }
        return metadataItems.stream().filter(item -> MapUtils.isNotEmpty((Map)item.getProperties())).collect(Collectors.toMap(item -> Locale.forLanguageTag((String)item.getProperties().get(LOCALE_PROPERTY_NAME)), item -> (String)item.getProperties().get(LABEL_PROPERTY_NAME)));
    }
}

