/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.MetadataObject;

public class ActivityMetadataListener
extends ActivityListenerPlugin {
    private MetadataService metadataService;
    private ActivityManager activityManager;

    public ActivityMetadataListener(MetadataService metadataService, ActivityManager activityManager) {
        this.metadataService = metadataService;
        this.activityManager = activityManager;
    }

    public void deleteActivity(ActivityLifeCycleEvent event) {
        String activityId = event.getActivityId();
        this.metadataService.deleteMetadataItemsByObject(new MetadataObject("activity", activityId));
        this.metadataService.deleteMetadataItemsByParentObject(new MetadataObject("activity", null, activityId));
    }

    public void deleteComment(ActivityLifeCycleEvent event) {
        this.deleteActivity(event);
    }

    public void shareActivity(ActivityLifeCycleEvent event) {
        ExoSocialActivity targetActivity = event.getActivity();
        String targetActivityId = targetActivity.getId();
        String originalSharedActivityId = (String)targetActivity.getTemplateParams().get("originalActivityId");
        String posterId = StringUtils.isBlank((String)targetActivity.getUserId()) ? targetActivity.getUserId() : targetActivity.getPosterId();
        Identity targetStreamOwnerIdentity = this.activityManager.getActivityStreamOwnerIdentity(targetActivity.getId());
        this.metadataService.shareMetadataItemsByObject(new MetadataObject("activity", originalSharedActivityId), targetActivityId, Long.parseLong(targetStreamOwnerIdentity.getId()), Long.parseLong(posterId));
    }
}

