/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.upgrade;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.codec.binary.Hex;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.upgrade.UpgradePluginExecutionContext;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.idm.PicketLinkIDMService;
import org.exoplatform.social.core.upgrade.UserPasswordHashMigration$AjcClosure1;
import org.exoplatform.web.security.hash.Argon2IdPasswordEncoder;
import org.picketlink.idm.api.User;

public class UserPasswordHashMigration
extends UpgradeProductPlugin {
    private static final Log LOG;
    private static final int CHUNCK = 100;
    private final EntityManagerService entityManagerService;
    private final PicketLinkIDMService picketLinkIDMService;
    private static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt128";
    private static final String DEFAULT_ENCODER = "org.exoplatform.web.security.hash.Argon2IdPasswordEncoder";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public UserPasswordHashMigration(EntityManagerService entityManagerService, PicketLinkIDMService picketLinkIDMService, InitParams initParams) {
        super(initParams);
        this.entityManagerService = entityManagerService;
        this.picketLinkIDMService = picketLinkIDMService;
    }

    public void processUpgrade(String s, String s1) {
        LOG.info((Object)"Start upgrade of users passwords hashing algorithm");
        PortalContainer container = PortalContainer.getInstance();
        EntityManager entityManager = this.entityManagerService.getEntityManager();
        try {
            String sqlString = "SELECT jbid_io.NAME, jbid_io_creden.TEXT  FROM (jbid_io_creden INNER JOIN jbid_io ON jbid_io_creden.IDENTITY_OBJECT_ID = jbid_io.ID) INNER JOIN (SELECT jbid_io_attr.IDENTITY_OBJECT_ID FROM jbid_io_attr WHERE jbid_io_attr.IDENTITY_OBJECT_ID NOT IN (SELECT jbid_io_attr.IDENTITY_OBJECT_ID FROM jbid_io_attr WHERE NAME = 'passwordSalt128') GROUP BY jbid_io_attr.IDENTITY_OBJECT_ID) jia ON jbid_io_creden.IDENTITY_OBJECT_ID  = jia.IDENTITY_OBJECT_ID;";
            RequestLifeCycle.begin((ExoContainer)container);
            Query nativeQuery = entityManager.createNativeQuery(sqlString);
            List result = nativeQuery.getResultList();
            UpgradeReport upgradeReport = new UpgradeReport(result.size());
            result.forEach(item -> this.fixUser((Object[])item, upgradeReport));
            LOG.info("End upgrade of users passwords hashing algorithm. {} passwords has been updated. {} users where not treated due to error. It took {} ms", new Object[]{upgradeReport.getSuccess(), upgradeReport.getFailure(), upgradeReport.getDurationInMillis()});
            if (!upgradeReport.getFailedUser().isEmpty()) {
                LOG.error("Users with not modified password : {}", new Object[]{upgradeReport.getFailedUser()});
                throw new IllegalStateException("UserPasswordHashMigration upgrade failed due to previous errors");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("UserPasswordHashMigration upgrade failed due to previous errors");
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    @ExoTransactional
    private void fixUser(Object[] item, UpgradeReport upgradeReport) {
        Object[] objectArray = item;
        UpgradeReport upgradeReport2 = upgradeReport;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)objectArray, (Object)upgradeReport2);
        Object[] objectArray2 = new Object[]{this, objectArray, upgradeReport2, joinPoint};
        UserPasswordHashMigration$AjcClosure1 userPasswordHashMigration$AjcClosure1 = new UserPasswordHashMigration$AjcClosure1(objectArray2);
        ExoTransactionalAspect.aspectOf().around(userPasswordHashMigration$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousGroupVersion, UpgradePluginExecutionContext previousUpgradePluginExecution) {
        try {
            return this.picketLinkIDMService.getExtendedAttributeManager().getDefaultCredentialEncoder().getClass().getName().equals(DEFAULT_ENCODER) && super.shouldProceedToUpgrade(newVersion, previousGroupVersion, previousUpgradePluginExecution);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking current default credential encoder", (Throwable)e);
            return false;
        }
    }

    private byte[] generateRandomSalt() {
        try {
            if (this.picketLinkIDMService.getExtendedAttributeManager().getDefaultCredentialEncoder().getClass().getName().equals(DEFAULT_ENCODER)) {
                Argon2IdPasswordEncoder encoder = (Argon2IdPasswordEncoder)this.picketLinkIDMService.getExtendedAttributeManager().getDefaultCredentialEncoder();
                return encoder.generateRandomSalt();
            }
            return new byte[0];
        }
        catch (Exception e) {
            LOG.error((Object)"Error for generating salt", (Throwable)e);
            return new byte[0];
        }
    }

    static {
        UserPasswordHashMigration.ajc$preClinit();
        LOG = ExoLogger.getExoLogger(UserPasswordHashMigration.class);
    }

    static /* synthetic */ void fixUser_aroundBody0(UserPasswordHashMigration ajc$this, Object[] item, UpgradeReport upgradeReport, JoinPoint joinPoint) {
        String userName = (String)item[0];
        String passwordHash = (String)item[1];
        try {
            User user = ajc$this.picketLinkIDMService.getIdentitySession().getPersistenceManager().findUser(userName);
            String saltString = Hex.encodeHexString((byte[])ajc$this.generateRandomSalt());
            if (user != null && ajc$this.picketLinkIDMService.getExtendedAttributeManager().getAttribute(userName, PASSWORD_SALT_USER_ATTRIBUTE) == null) {
                ajc$this.picketLinkIDMService.getExtendedAttributeManager().addAttribute(userName, PASSWORD_SALT_USER_ATTRIBUTE, (Object)saltString);
                ajc$this.picketLinkIDMService.getExtendedAttributeManager().updatePassword(user, passwordHash);
            }
            upgradeReport.incrementSuccess();
            int count = upgradeReport.getFailure() + upgradeReport.getSuccess();
            if (count % 100 == 0) {
                if (ajc$this.picketLinkIDMService.getIdentitySession().getTransaction() != null) {
                    ajc$this.picketLinkIDMService.getIdentitySession().getTransaction().commit();
                }
                LOG.info("{}/{} passwords have been updated ({} ms for the chunck)", new Object[]{count, upgradeReport.total, upgradeReport.getChunkDurationInMillis()});
                upgradeReport.resetChunckTime();
            }
        }
        catch (Exception e) {
            upgradeReport.incrementFailure();
            upgradeReport.addFailUser(userName);
            LOG.error("Error while creating attribute salt and updating password hash for user : {}", new Object[]{userName, e});
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserPasswordHashMigration.java", UserPasswordHashMigration.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "fixUser", "org.exoplatform.social.core.upgrade.UserPasswordHashMigration", "[Ljava.lang.Object;:org.exoplatform.social.core.upgrade.UserPasswordHashMigration$UpgradeReport", "item:upgradeReport", "", "void"), 100);
    }

    public static class UpgradeReport {
        private long startTime = System.currentTimeMillis();
        private int total;
        private int success;
        private int failure;
        private long startChunckTime = System.currentTimeMillis();
        private List<String> failedUser = new ArrayList<String>();

        public UpgradeReport(int total) {
            this.total = total;
        }

        public void incrementSuccess() {
            ++this.success;
        }

        public void incrementFailure() {
            ++this.failure;
        }

        public long getDurationInMillis() {
            return System.currentTimeMillis() - this.startTime;
        }

        public long getChunkDurationInMillis() {
            return System.currentTimeMillis() - this.startChunckTime;
        }

        public void resetChunckTime() {
            this.startChunckTime = System.currentTimeMillis();
        }

        public void addFailUser(String username) {
            this.failedUser.add(username);
        }

        public int getTotal() {
            return this.total;
        }

        public int getSuccess() {
            return this.success;
        }

        public int getFailure() {
            return this.failure;
        }

        public long getStartChunckTime() {
            return this.startChunckTime;
        }

        public List<String> getFailedUser() {
            return this.failedUser;
        }
    }
}

