/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.infinispan.commons.util.FastCopyHashMap;

public class ObjectDuplicator {
    public static <K, V> Map<K, V> duplicateMap(Map<K, V> original) {
        if (original instanceof FastCopyHashMap) {
            return ((FastCopyHashMap)original).clone();
        }
        if (original instanceof HashMap) {
            return (Map)((HashMap)original).clone();
        }
        if (original instanceof TreeMap) {
            return (Map)((TreeMap)original).clone();
        }
        if (original.getClass().equals(Collections.emptyMap().getClass())) {
            return Collections.emptyMap();
        }
        if (original.getClass().equals(Collections.singletonMap("", "").getClass())) {
            Map.Entry<K, V> e = original.entrySet().iterator().next();
            return Collections.singletonMap(e.getKey(), e.getValue());
        }
        return ObjectDuplicator.attemptClone(original);
    }

    public static <E> Set<E> duplicateSet(Set<E> original) {
        if (original instanceof HashSet) {
            return (Set)((HashSet)original).clone();
        }
        if (original instanceof TreeSet) {
            return (Set)((TreeSet)original).clone();
        }
        if (original instanceof FastCopyHashMap.EntrySet || original instanceof FastCopyHashMap.KeySet) {
            return new HashSet<E>(original);
        }
        if (original.getClass().equals(Collections.emptySet().getClass())) {
            return Collections.emptySet();
        }
        if (original.getClass().equals(Collections.singleton("").getClass())) {
            return Collections.singleton(original.iterator().next());
        }
        if (original.getClass().getSimpleName().contains("$")) {
            return new HashSet<E>(original);
        }
        return ObjectDuplicator.attemptClone(original);
    }

    public static <E> Collection<E> duplicateCollection(Collection<E> original) {
        if (original instanceof HashSet) {
            return (Set)((HashSet)original).clone();
        }
        if (original instanceof TreeSet) {
            return (Set)((TreeSet)original).clone();
        }
        return ObjectDuplicator.attemptClone(original);
    }

    private static <T> T attemptClone(T source) {
        if (source instanceof Cloneable) {
            try {
                return (T)source.getClass().getMethod("clone", new Class[0]).invoke(source, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

