/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core;

import java.io.Writer;
import org.exoplatform.commons.serialization.api.annotations.Serialized;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.AbstractApplicationMessage;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupMessages;
import org.exoplatform.webui.exception.CSRFException;
import org.exoplatform.webui.exception.MessageException;

@Serialized
public abstract class UIApplication
extends UIContainer {
    protected static Log log = ExoLogger.getLogger((String)"portal:UIApplication");
    private String owner;
    private long lastAccessApplication_;
    private UIPopupMessages uiPopupMessages_;
    private static final String UIAPPLICATION = "uiapplication";

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String s) {
        this.owner = s;
    }

    public UIPopupMessages getUIPopupMessages() {
        if (USE_WEBUI_RESOURCES && this.uiPopupMessages_ == null) {
            try {
                this.uiPopupMessages_ = this.createUIComponent(UIPopupMessages.class, null, null);
                this.uiPopupMessages_.setId("_" + this.uiPopupMessages_.hashCode());
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return this.uiPopupMessages_;
    }

    public void addMessage(AbstractApplicationMessage message) {
        if (USE_WEBUI_RESOURCES) {
            this.getUIPopupMessages().addMessage(message);
        }
    }

    public void addMessage(ApplicationMessage message) {
        if (USE_WEBUI_RESOURCES) {
            this.addMessage((AbstractApplicationMessage)message);
        }
    }

    public void clearMessages() {
        if (USE_WEBUI_RESOURCES) {
            this.getUIPopupMessages().clearMessages();
        }
    }

    public long getLastAccessApplication() {
        return this.lastAccessApplication_;
    }

    public void setLastAccessApplication(long time) {
        this.lastAccessApplication_ = time;
    }

    @Override
    public String getUIComponentName() {
        return UIAPPLICATION;
    }

    @Override
    public <T extends UIComponent> T findComponentById(String lookupId) {
        if (USE_WEBUI_RESOURCES && this.getUIPopupMessages().getId().equals(lookupId)) {
            return (T)this.getUIPopupMessages();
        }
        return super.findComponentById(lookupId);
    }

    @Override
    public void renderChildren() throws Exception {
        super.renderChildren();
        if (!USE_WEBUI_RESOURCES || this.getUIPopupMessages() == null) {
            return;
        }
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        this.getUIPopupMessages().processRender(context);
    }

    @Override
    public void processAction(WebuiRequestContext context) throws Exception {
        try {
            super.processAction(context);
        }
        catch (MessageException ex) {
            this.addMessage(ex.getDetailMessage());
        }
        catch (CSRFException e) {
            context.getJavascriptManager().getRequireJS().addScripts("location.reload();");
        }
        catch (Throwable t) {
            ApplicationMessage msg = new ApplicationMessage("UIApplication.msg.unknown-error", null, 0);
            this.addMessage(msg);
            log.error((Object)"Error during the processAction phase", t);
        }
    }

    public void renderBlockToUpdate(UIComponent uicomponent, WebuiRequestContext context, Writer w) throws Exception {
        w.write("<div class=\"BlockToUpdate\">");
        w.append("<div class=\"BlockToUpdateId\">").append(uicomponent.getId()).append("</div>");
        w.write("<div class=\"BlockToUpdateData\">");
        uicomponent.processRender(context);
        w.write("</div>");
        w.write("</div>");
    }
}

