/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.spi;

import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ComponentRegistration;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.annotations.Managed;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.core.api.AbstractManagedResource;
import org.gatein.management.core.api.ManagementProviders;
import org.gatein.management.core.api.operation.global.ExportResource;
import org.gatein.management.core.api.operation.global.GlobalOperationHandlers;
import org.gatein.management.core.spi.AnnotatedResource;
import org.gatein.management.spi.ExtensionContext;

public class ExtensionContextImpl
implements ExtensionContext {
    private static final Logger log = LoggerFactory.getLogger((String)"org.gatein.management.core.spi");
    private final AbstractManagedResource rootResource;
    private final ManagementProviders providers;

    public ExtensionContextImpl(AbstractManagedResource rootResource, ManagementProviders providers) {
        this.rootResource = rootResource;
        this.providers = providers;
    }

    public ComponentRegistration registerManagedComponent(final String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        return new ComponentRegistration(){

            public ManagedResource.Registration registerManagedResource(ManagedDescription description) {
                ManagedResource.Registration registration = ExtensionContextImpl.this.rootResource.registerSubResource(name, description);
                registration.registerOperationHandler("export-resource", (OperationHandler)GlobalOperationHandlers.EXPORT_RESOURCE, ExportResource.DESCRIPTION, true);
                return registration;
            }

            public void registerBindingProvider(BindingProvider bindingProvider) {
                ExtensionContextImpl.this.providers.register(name, bindingProvider);
            }
        };
    }

    public ComponentRegistration registerManagedComponent(Class<?> component) {
        Managed managed;
        boolean debug = log.isDebugEnabled();
        if (debug) {
            log.debug((Object)("Processing managed annotations for class " + component));
        }
        if ((managed = component.getAnnotation(Managed.class)) == null) {
            throw new RuntimeException(Managed.class + " annotation not present on " + component);
        }
        String componentName = managed.value();
        if ("".equals(componentName)) {
            throw new RuntimeException(Managed.class + " annotation must have a value (path) for component class " + component);
        }
        if (debug) {
            log.debug((Object)("Registering managed component " + componentName));
        }
        ComponentRegistration registration = this.registerManagedComponent(componentName);
        registration.registerManagedResource(this.description(managed.description()));
        AnnotatedResource annotatedResource = new AnnotatedResource(component);
        annotatedResource.register(this.rootResource);
        return registration;
    }

    private ManagedDescription description(final String description) {
        return new ManagedDescription(){

            public String getDescription() {
                return description;
            }
        };
    }
}

