/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.navigation;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.exoplatform.portal.mop.navigation.HierarchyError;
import org.exoplatform.portal.mop.navigation.HierarchyException;
import org.exoplatform.portal.mop.navigation.NodeAdapter;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeState;
import org.exoplatform.portal.tree.diff.HierarchyAdapter;
import org.exoplatform.portal.tree.diff.HierarchyChangeIterator;
import org.exoplatform.portal.tree.diff.HierarchyChangeType;
import org.exoplatform.portal.tree.diff.HierarchyDiff;
import org.exoplatform.portal.tree.diff.ListAdapter;

class TreeDiff<L, N> {
    private static final Comparator<String> COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    private final N node;
    private final NodeAdapter<L, N> adapter;
    private final NodeContext<N> context;

    TreeDiff(N node, NodeContext<N> context, NodeAdapter<L, N> adapter) {
        this.node = node;
        this.context = context;
        this.adapter = adapter;
    }

    public void perform() {
        NodeContextHierarchyAdapter nc = new NodeContextHierarchyAdapter();
        HierarchyDiff<List<String>, NodeContext<N>, L, N, String> diff = HierarchyDiff.create(nc, nc, this.adapter, this.adapter, COMPARATOR);
        LinkedList<NodeContext<N>> previousStack = new LinkedList<NodeContext<N>>();
        LinkedList<NodeContext<N>> parentStack = new LinkedList<NodeContext<N>>();
        HierarchyChangeIterator i = diff.iterator(this.context, this.node);
        while (i.hasNext()) {
            HierarchyChangeType type = i.next();
            switch (type) {
                case ADDED: {
                    NodeState state = this.adapter.getState(i.getDestination());
                    String name = this.adapter.getName(i.getDestination());
                    Object parent = (NodeContext)parentStack.peekLast();
                    NodeContext previous = (NodeContext)previousStack.peekLast();
                    if (((NodeContext)parent).get(name) != null) {
                        throw new HierarchyException(HierarchyError.ADD_CONCURRENTLY_ADDED_NODE);
                    }
                    NodeContext added = previous != null ? ((NodeContext)parent).add((Integer)(previous.getIndex() + 1), name) : ((NodeContext)parent).add((Integer)0, name);
                    this.adapter.setHandle(i.getDestination(), added.handle);
                    previousStack.set(previousStack.size() - 1, added);
                    break;
                }
                case REMOVED: {
                    i.getSource().removeNode();
                    break;
                }
                case MOVED_OUT: {
                    break;
                }
                case MOVED_IN: {
                    NodeContext<N> moved = i.getSource();
                    Object cd = i.getDestination();
                    Object parent = this.adapter.getParent(cd);
                    String handle = (String)this.adapter.getHandle(parent);
                    NodeContext<N> parent2 = this.context.getDescendant(handle);
                    Object pre = this.adapter.getPrevious(parent, cd);
                    if (pre != null) {
                        String preHandle = (String)this.adapter.getHandle(pre);
                        NodeContext<N> foo = this.context.getDescendant(preHandle);
                        parent2.add((Integer)(foo.getIndex() + 1), moved);
                    } else {
                        parent2.add((Integer)0, moved);
                    }
                    previousStack.set(previousStack.size() - 1, moved);
                    break;
                }
                case KEEP: {
                    NodeState s = this.adapter.getState(i.getDestination());
                    i.getSource().setState(s);
                    previousStack.set(previousStack.size() - 1, i.getSource());
                    break;
                }
                case ENTER: {
                    NodeContext<N> parent = i.getSource();
                    if (parent == null) {
                        parentStack.addLast((NodeContext)previousStack.peekLast());
                    } else {
                        parentStack.addLast(parent);
                    }
                    previousStack.addLast(null);
                    break;
                }
                case LEAVE: {
                    parentStack.removeLast();
                    previousStack.removeLast();
                }
            }
        }
    }

    class NodeContextHierarchyAdapter
    implements HierarchyAdapter<List<String>, NodeContext<N>, String>,
    ListAdapter<List<String>, String> {
        NodeContextHierarchyAdapter() {
        }

        @Override
        public String getHandle(NodeContext<N> node) {
            return node.getId();
        }

        @Override
        public List<String> getChildren(NodeContext<N> node) {
            ArrayList<String> ret = new ArrayList<String>(node.getSize());
            ListIterator iter = node.listIterator();
            while (iter.hasNext()) {
                ret.add(((NodeContext)iter.next()).getId());
            }
            return ret;
        }

        @Override
        public NodeContext<N> getDescendant(NodeContext<N> node, String handle) {
            return node.getDescendant(handle);
        }

        @Override
        public int size(List<String> list) {
            return list.size();
        }

        @Override
        public Iterator<String> iterator(List<String> list, boolean reverse) {
            if (reverse) {
                final ListIterator<String> i = list.listIterator(list.size());
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasPrevious();
                    }

                    @Override
                    public String next() {
                        return (String)i.previous();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            return list.iterator();
        }
    }
}

